/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusBlockListener;
import org.biojavax.bio.phylo.io.nexus.NexusComment;

public interface NexusBlockBuilder
extends NexusBlockListener {
    public NexusBlock getNexusBlock();

    public static abstract class Abstract
    implements NexusBlockBuilder {
        private String blockName;
        private NexusBlock block;
        private NexusComment comment;

        protected String getBlockName() {
            return this.blockName;
        }

        public void beginComment() {
            if (this.comment != null) {
                this.comment.openSubComment();
            } else {
                this.comment = new NexusComment();
            }
        }

        public void commentText(String comment) {
            this.comment.addCommentText(comment);
        }

        public void endComment() {
            if (this.comment != null && this.comment.hasOpenSubComment()) {
                this.comment.closeSubComment();
            } else {
                this.addComment(this.comment);
                this.comment = null;
            }
        }

        protected abstract void addComment(NexusComment var1);

        public void startBlock(String blockName) {
            this.blockName = blockName;
            this.block = this.startBlockObject();
        }

        protected abstract NexusBlock startBlockObject();

        public NexusBlock getNexusBlock() {
            return this.block;
        }
    }
}

