/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import cern.jet.stat.Gamma;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures.BTExplainingAwayResidual;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class SeqLogoPlotter {
    private static Color getColor(double[] pwm, float ic) {
        float[] a = new float[]{0.0f, 1.0f, 0.0f};
        float[] c = new float[]{0.0f, 0.0f, 1.0f};
        float[] g = Color.ORANGE.getColorComponents(null);
        float[] t = new float[]{1.0f, 0.0f, 0.0f};
        float[] nc = new float[3];
        for (int i = 0; i < 3; ++i) {
            nc[i] = (float)(pwm[0] * (double)a[i] + pwm[1] * (double)c[i] + pwm[2] * (double)g[i] + pwm[3] * (double)t[i]);
        }
        return new Color(nc[0], nc[1], nc[2], ic);
    }

    private static double[][] getDeps(Sequence[] seqs, double[] w) {
        double[][][][] counts = new double[seqs[0].getLength()][seqs[0].getLength()][4][4];
        double sum = 0.0;
        for (int i = 0; i < seqs.length; ++i) {
            double weight = w == null ? 1.0 : w[i];
            sum += weight;
            for (int k = 0; k < seqs[i].getLength(); ++k) {
                for (int l = 0; l < seqs[i].getLength(); ++l) {
                    double[] dArray = counts[k][l][seqs[i].discreteVal(k)];
                    int n = seqs[i].discreteVal(l);
                    dArray[n] = dArray[n] + weight;
                }
            }
        }
        double[][] mis = new double[seqs[0].getLength()][seqs[0].getLength()];
        for (int k = 1; k < seqs[0].getLength(); ++k) {
            for (int l = 0; l < k; ++l) {
                double mi = 0.0;
                for (int a = 0; a < 4; ++a) {
                    for (int b = 0; b < 4; ++b) {
                        if (!(counts[k][l][a][b] > 0.0)) continue;
                        mi += counts[k][l][a][b] * (Math.log(counts[k][l][a][b]) - Math.log(counts[k][k][a][a]) - Math.log(counts[l][l][b][b]) + Math.log(sum));
                    }
                }
                mis[k][l] = mi;
                mis[l][k] = mi;
            }
        }
        return mis;
    }

    public static int getHeightForDependencyLogo(int seqLength, int numSeqs, int[] chunkHeights, int width, int blockSpacer) {
        int height = SeqLogoPlotter.getHeightForColorLogo(numSeqs, chunkHeights, blockSpacer);
        int topMargin = width / 5;
        height = (int)((double)height + 1.5 * (double)topMargin);
        return height;
    }

    private static int getHeightForColorLogo(int numSeqs, int[] chunkHeights, int blockSpacer) {
        int height = 0;
        for (int i = 0; i < chunkHeights.length; ++i) {
            height += chunkHeights[i] + blockSpacer;
        }
        return height;
    }

    private static void plotScale(Graphics g, int offx, int offy, int height) {
        g = g.create();
        g.setColor(Color.BLACK);
        Rectangle2D rect = g.getFontMetrics().getStringBounds("2", g);
        int w = (int)rect.getWidth();
        int h = -((int)rect.getCenterY());
        g.drawLine(offx, offy, offx, offy + height);
        g.drawString("2", offx - 2 * w, offy + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy, offx, offy);
        g.drawString("1", offx - 2 * w, (int)((double)offy + 0.5 * (double)height) + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + (int)(0.5 * (double)height), offx, offy + (int)(0.5 * (double)height));
        g.drawString("0", offx - 2 * w, offy + height + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + height, offx, offy + height);
    }

    public static BufferedImage plotDefaultDependencyLogoToBufferedImage(DataSet data, double[] weights, int width) throws Exception {
        int[] numPerChunk = new int[]{Math.min(250, (int)Math.round((double)data.getNumberOfElements() * 0.1)), Math.min(1250, (int)Math.round((double)data.getNumberOfElements() * 0.3)), 0};
        numPerChunk[2] = data.getNumberOfElements() - numPerChunk[0] - numPerChunk[1];
        int logoHeight = (int)Math.round((double)width / 10.0);
        int[] chunkHeights = new int[]{60, 75, 150};
        int height = SeqLogoPlotter.getHeightForDependencyLogo(data.getElementLength(), data.getNumberOfElements(), chunkHeights, width, logoHeight);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)img.getGraphics();
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotDependencyLogo(data, null, 1, null, weights, graph, width, 0, 0, numPerChunk, chunkHeights, 0.03, logoHeight, false, 3, false, true, true, 0.1);
        return img;
    }

    public static void plotDefaultDependencyLogoToGraphicsAdaptor(GraphicsAdaptor ga, DataSet data, double[] weights, int width) throws Exception {
        int[] numPerChunk = new int[]{Math.min(250, (int)Math.round((double)data.getNumberOfElements() * 0.1)), Math.min(1250, (int)Math.round((double)data.getNumberOfElements() * 0.3)), 0};
        numPerChunk[2] = data.getNumberOfElements() - numPerChunk[0] - numPerChunk[1];
        int logoHeight = (int)Math.round((double)width / 10.0);
        int[] chunkHeights = new int[]{60, 75, 150};
        int height = SeqLogoPlotter.getHeightForDependencyLogo(data.getElementLength(), data.getNumberOfElements(), chunkHeights, width, logoHeight);
        Graphics2D graph = ga.getGraphics(width, height);
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotDependencyLogo(data, null, 1, null, weights, graph, width, 0, 0, numPerChunk, chunkHeights, 0.03, logoHeight, false, 3, false, true, true, 0.1);
    }

    public static int plotDependencyLogo(DataSet seqs, Object[] labels, int ticPeriod, double[][] classProbs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numPerChunk, int[] chunkHeights, double minPercent, int logoHeight, boolean highlightMaxDeps, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, boolean scaleByDeps, double threshold) throws Exception {
        int h;
        int j;
        int i;
        int totalWidth = width;
        graph = (Graphics2D)graph.create();
        int leftMargin = width / 15;
        int tempWidth = width - 2 * leftMargin;
        if (labels == null) {
            labels = new String[seqs.getElementLength()];
            for (int i2 = 0; i2 < labels.length; ++i2) {
                labels[i2] = i2 + 1 + "";
            }
        }
        int partWidth = (int)Math.floor((double)tempWidth / (double)labels.length);
        Font font = new Font(graph.getFont().getName(), 1, width / 30);
        graph.setFont(font);
        int fac = 30;
        double maxWidth = 0.0;
        for (int i3 = 0; i3 < labels.length; ++i3) {
            double temp = graph.getFontMetrics().getStringBounds(labels[i3].toString(), graph).getWidth();
            if (!(temp > maxWidth)) continue;
            maxWidth = temp;
        }
        if (maxWidth > (double)partWidth * 0.9 * (double)ticPeriod) {
            fac = (int)((double)fac * (maxWidth / ((double)partWidth * 0.9 * (double)ticPeriod)));
            font = new Font(graph.getFont().getName(), 1, width / fac);
            graph.setFont(font);
        }
        graph.setStroke(new BasicStroke((float)width / 300.0f));
        double symHeight = graph.getFontMetrics().getStringBounds(labels[labels.length - 1].toString(), graph).getHeight();
        int topMargin = width / 5;
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, SeqLogoPlotter.getHeightForColorLogo(seqs.getNumberOfElements(), chunkHeights, logoHeight) + topMargin * 2);
        double labWidth = graph.getFontMetrics().getStringBounds("0.000E000", graph).getWidth();
        Sequence[] seqs2 = seqs.getAllElements();
        int[] heights = SeqLogoPlotter.plotColorLogo(seqs2, weights, graph, width -= 2 * leftMargin, offx + leftMargin, offy + topMargin, numPerChunk, chunkHeights, minPercent, logoHeight, numBestForSorting, sortGlobally, sortByWeights, threshold);
        seqs = new DataSet("", seqs2);
        graph.setColor(Color.BLACK);
        int off = topMargin;
        for (int i4 = 0; i4 < heights.length; ++i4) {
            String lab = numPerChunk[i4] + "";
            Rectangle2D rect = graph.getFontMetrics().getStringBounds(lab, graph);
            AffineTransform back = graph.getTransform();
            graph.rotate(-1.5707963267948966);
            graph.drawString(lab, -((int)((double)((heights[i4] + off - logoHeight) / 2) + rect.getCenterX())), (int)((double)leftMargin - rect.getHeight() / 2.0));
            graph.setTransform(back);
            off = heights[i4];
        }
        off = partWidth / 2;
        SeqLogoPlotter.addLabels(labels, ticPeriod, graph, partWidth, offx, leftMargin, off, symHeight, topMargin, offy, heights[heights.length - 1]);
        double[][] deps = null;
        if (classProbs == null || classProbs.length == 1) {
            deps = SeqLogoPlotter.getDeps(seqs2, classProbs == null ? null : classProbs[0]);
        } else {
            BTExplainingAwayResidual ear = new BTExplainingAwayResidual(new double[]{0.0, 0.0});
            deps = ear.getEAR(new DataSet("", seqs2), new DataSet("", seqs2), classProbs[0], classProbs[1], seqs2[0].getLength());
        }
        boolean[][] isMax = new boolean[deps.length][deps.length];
        if (highlightMaxDeps) {
            int i5;
            for (i5 = 0; i5 < deps.length; ++i5) {
                double max = ToolBox.max(deps[i5]);
                for (int j2 = 0; j2 < deps[i5].length; ++j2) {
                    if (deps[i5][j2] != max) continue;
                    isMax[i5][j2] = true;
                }
            }
            for (i5 = 1; i5 < deps.length; ++i5) {
                for (int j3 = 0; j3 < i5; ++j3) {
                    isMax[i5][j3] = isMax[i5][j3] || isMax[j3][i5];
                    isMax[j3][i5] = isMax[i5][j3];
                }
            }
        }
        double[][] ps = new double[deps.length][deps[0].length];
        double f = (double)(deps.length * (deps.length - 1)) / 2.0;
        double maxp = -Math.log10(1.0E-300 / f);
        double minp = -Math.log10(0.01 / f);
        for (i = 1; i < deps.length; ++i) {
            for (j = 0; j < i; ++j) {
                double p = -Math.log10(Gamma.incompleteGammaComplement((double)4.5, (double)(deps[i][j] * 2.0 / 2.0)));
                if (p > maxp) {
                    p = maxp;
                }
                ps[i][j] = p;
            }
        }
        if (scaleByDeps) {
            for (i = 1; i < deps.length; ++i) {
                for (j = 0; j < i; ++j) {
                    ps[i][j] = ps[i][j] > minp ? Math.log(deps[i][j] / (classProbs == null ? (double)seqs2.length : ToolBox.sum(classProbs[0]))) : Double.NEGATIVE_INFINITY;
                }
            }
            minp = Math.log(0.01);
            maxp = Math.log(Math.log(4.0));
        }
        graph.setColor(Color.BLACK);
        for (i = 1; i < deps.length; ++i) {
            for (j = 0; j < i; ++j) {
                if (!(ps[i][j] > minp) || isMax[i][j]) continue;
                Color c = new Color(0.0f, 0.0f, 0.0f, (float)((ps[i][j] - minp) / (maxp - minp)));
                graph.setColor(c);
                h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i - j) / (double)deps.length);
                graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i - j) * partWidth, h * 2, 0, 180);
            }
        }
        for (i = 1; i < deps.length; ++i) {
            for (j = 0; j < i; ++j) {
                if (!(ps[i][j] > minp) || !isMax[i][j]) continue;
                Color c = new Color(1.0f, 0.0f, 0.0f, (float)((ps[i][j] - minp) / (maxp - minp)));
                graph.setColor(c);
                h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i - j) / (double)deps.length);
                graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i - j) * partWidth, h * 2, 0, 180);
            }
        }
        off = 0;
        for (i = 0; i < heights.length; ++i) {
            double[][] pwm = PFMComparator.getPWM(seqs, off, off + numPerChunk[i]);
            off += numPerChunk[i];
            for (int j4 = 0; j4 < pwm.length; ++j4) {
                SeqLogoPlotter.plotLogo(graph, (double)(offx + leftMargin + j4 * partWidth), heights[i], partWidth, logoHeight, pwm[j4]);
            }
            SeqLogoPlotter.plotScale(graph, offx + leftMargin, heights[i] - logoHeight, logoHeight - 1);
        }
        return heights[heights.length - 1];
    }

    private static void addLabels(Object[] labels, int ticPeriod, Graphics2D graph, int partWidth, int offx, int leftMargin, int off, double symHeight, int topMargin, int offy, int lastHeight) {
        graph.setColor(Color.BLACK);
        for (int i = 0; i < labels.length; ++i) {
            int per = (i + ticPeriod - 1) % ticPeriod;
            int c = (int)graph.getFontMetrics().getStringBounds(labels[i].toString(), graph).getCenterX();
            if (labels[i] instanceof Integer) {
                int num = (Integer)labels[i];
                if (num < 0) {
                    c += (int)graph.getFontMetrics().getStringBounds("-", graph).getCenterX();
                }
                per = ((num < 0 ? -num : num) + ticPeriod) % ticPeriod;
            }
            if (per == 0) {
                if (ticPeriod != 1) {
                    graph.drawString(labels[i].toString(), offx + leftMargin + off + i * partWidth - c, offy + (int)((double)topMargin - symHeight / 1.5));
                } else {
                    graph.drawString(labels[i].toString(), offx + leftMargin + off + i * partWidth - c, offy + (int)((double)topMargin - symHeight / 2.0));
                }
                graph.drawString(labels[i].toString(), offx + leftMargin + off + i * partWidth - c, lastHeight + (int)(symHeight * 2.5));
                if (ticPeriod != 1) {
                    graph.drawLine(offx + leftMargin + off + i * partWidth, offy + (int)((double)topMargin - symHeight / 2.0), offx + leftMargin + off + i * partWidth, offy + (int)((double)topMargin - symHeight / 2.0 + symHeight * 0.4));
                }
                graph.drawLine(offx + leftMargin + off + i * partWidth, lastHeight + (int)symHeight, offx + leftMargin + off + i * partWidth, lastHeight + (int)(1.5 * symHeight));
                continue;
            }
            if (ticPeriod != 1) {
                graph.drawLine(offx + leftMargin + off + i * partWidth, offy + (int)((double)topMargin - symHeight / 2.0 + symHeight * 0.2), offx + leftMargin + off + i * partWidth, offy + (int)((double)topMargin - symHeight / 2.0 + symHeight * 0.4));
            }
            graph.drawLine(offx + leftMargin + off + i * partWidth, lastHeight + (int)symHeight, offx + leftMargin + off + i * partWidth, lastHeight + (int)(1.25 * symHeight));
        }
        graph.drawLine(offx + leftMargin + off, lastHeight + (int)symHeight, offx + leftMargin + off + (labels.length - 1) * partWidth, lastHeight + (int)symHeight);
        if (ticPeriod != 1) {
            graph.drawLine(offx + leftMargin + off, offy + (int)((double)topMargin - symHeight / 2.0 + symHeight * 0.4), offx + leftMargin + off + (labels.length - 1) * partWidth, offy + (int)((double)topMargin - symHeight / 2.0 + symHeight * 0.4));
        }
    }

    private static int plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int numOne, int numPerChunk, int oneHeight, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        int[] nums = new int[(int)Math.ceil((double)seqs.length / (double)numPerChunk)];
        int[] oneNums = new int[nums.length];
        int i = 0;
        int k = 0;
        while (i < seqs.length) {
            int numCurr;
            nums[k] = i + numPerChunk <= seqs.length ? numPerChunk : (numCurr = (int)Math.floor((seqs.length - i) / numOne) * numOne);
            oneNums[k] = numOne;
            i += numPerChunk;
            ++k;
        }
        int[] offs = SeqLogoPlotter.plotColorLogo(seqs, weights, graph, width, offx, offy, oneNums, nums, (double)oneHeight, blockSpacer, numBestForSorting, sortGlobally, sortByWeights, threshold);
        return offs[offs.length - 1];
    }

    private static int[] plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numPerChunk, int[] chunkHeights, double minPercent, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        int i;
        int[] offs = new int[numPerChunk.length];
        if (weights == null) {
            weights = new double[seqs.length];
            Arrays.fill(weights, 1.0);
        } else {
            Object[] els = new ComparableElement[seqs.length];
            for (i = 0; i < els.length; ++i) {
                els[i] = new ComparableElement<Sequence, Double>(seqs[i], weights[i]);
            }
            Arrays.sort(els);
            for (i = 0; i < els.length; ++i) {
                seqs[i] = (Sequence)((ComparableElement)els[els.length - 1 - i]).getElement();
                weights[i] = (Double)((ComparableElement)els[els.length - 1 - i]).getWeight();
            }
        }
        int off = 0;
        for (i = 0; i < numPerChunk.length; ++i) {
            SeqLogoPlotter.plotColorLogo(graph, seqs, weights, off, off + numPerChunk[i], width, offx, offy, chunkHeights[i], minPercent, numBestForSorting, sortGlobally, sortByWeights, threshold);
            Color back = graph.getColor();
            graph.setColor(Color.WHITE);
            graph.fillRect(offx, (offy += chunkHeights[i] + blockSpacer) - blockSpacer, width, blockSpacer);
            graph.setColor(back);
            off += numPerChunk[i];
            offs[i] = offy;
        }
        return offs;
    }

    private static int plotColorLogo(Graphics2D graph, Sequence[] seqs, double[] weights, int start, int end, int width, int offx, int offy, int chunkHeight, double minPercent, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        double mi = ToolBox.min(weights);
        double ma = ToolBox.max(weights);
        if (ma == (mi -= (ma - mi) * 1.0E-6)) {
            mi = 0.0;
        }
        graph = (Graphics2D)graph.create();
        Sequence[] temp = new Sequence[end - start];
        System.arraycopy(seqs, start, temp, 0, end - start);
        Pair[] sortTemp = new Pair[end - start];
        for (int i = 0; i < sortTemp.length; ++i) {
            sortTemp[i] = new Pair<Sequence, Double>(seqs[start + i], weights[start + i]);
        }
        double[][] fullPFM = PFMComparator.getPFM(new DataSet("", temp));
        int numSort = 6;
        LinkedList<ComparableElement<Integer, Double>> pivots = new LinkedList<ComparableElement<Integer, Double>>();
        Pair<Sequence, Double>[][] sorted = SeqLogoPlotter.sortLocal2(sortTemp, numBestForSorting, numSort, new boolean[temp[0].getLength()], (int)(minPercent * (double)sortTemp.length), sortByWeights, fullPFM, threshold, pivots);
        if (sortGlobally) {
            Object[] pivAr = pivots.toArray(new ComparableElement[0]);
            Arrays.sort(pivAr);
            IntList sortPos = new IntList();
            DoubleList sortVals = new DoubleList();
            int off = 0;
            boolean[] exclude = new boolean[temp[0].getLength()];
            double[] vals = new double[exclude.length];
            for (int i = pivAr.length - 1; i >= 0 && off < numSort; --i) {
                int idx = (Integer)((ComparableElement)pivAr[i]).getElement();
                double val = (Double)((ComparableElement)pivAr[i]).getWeight();
                int n = idx;
                vals[n] = vals[n] + val;
            }
            int[] o = ToolBox.order(vals, true);
            for (int i = 0; i < o.length; ++i) {
                sortPos.add(o[i]);
                sortVals.add(vals[o[i]]);
            }
            sorted = SeqLogoPlotter.partition(sortTemp, (int)(minPercent * (double)sortTemp.length), sortPos.toArray(), sortVals.toArray(), 0, sortByWeights, null);
        }
        int totalHeight = chunkHeight;
        double[][] pwm = new double[seqs[0].getLength()][4];
        for (int i = 0; i < sorted.length; ++i) {
            int numCurr = sorted[i].length;
            int heightCurr = totalHeight * numCurr / sortTemp.length;
            double meanW = 0.0;
            for (int k = 0; k < numCurr; ++k) {
                meanW += sorted[i][k].getSecondElement().doubleValue();
            }
            meanW /= (double)numCurr;
            for (int j = 0; j < pwm.length; ++j) {
                Arrays.fill(pwm[j], 0.0);
                for (int k = 0; k < numCurr; ++k) {
                    double[] dArray = pwm[j];
                    int n = sorted[i][k].getFirstElement().discreteVal(j);
                    dArray[n] = dArray[n] + 1.0;
                }
                Normalisation.sumNormalisation(pwm[j]);
            }
            SeqLogoPlotter.plotColorLogo(graph, pwm, (meanW - mi) / (ma - mi), true, true, heightCurr, width, offx, offy);
            offy += heightCurr;
        }
        return offx;
    }

    private static Pair<Sequence, Double>[] sortLocal3(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[] prevInf) {
        int i;
        if (maxNum == 0 || sortTemp.length < minElements * 4) {
            return sortTemp;
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        for (int i2 = 0; i2 < temp.length; ++i2) {
            temp[i2] = sortTemp[i2].getFirstElement();
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        int bestPrev = ToolBox.getMaxIndex(prevInf);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1 && (ToolBox.sum(exclude) == 0 || prevInf[bestPrev] / (double)temp.length / (double)ToolBox.sum(exclude) < 0.1)) {
            return sortTemp;
        }
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1) {
            best = bestPrev;
        }
        double[] mis = pair.getSecondElement()[best];
        exclude[best] = true;
        LinkedList[] partSort = new LinkedList[4];
        for (int i3 = 0; i3 < partSort.length; ++i3) {
            partSort[i3] = new LinkedList();
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        for (i = 0; i < temp.length; ++i) {
            Sequence seq = temp[i];
            int idx = seq.discreteVal(best);
            partSort[idx].add(sortTemp[i]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i].getSecondElement();
        }
        if (sortByWeights) {
            for (i = 0; i < freq.length; ++i) {
                freq[i] = ws[i] / freq[i];
            }
        }
        int[] ord = ToolBox.order(freq, true);
        int off = 0;
        for (int i4 = 0; i4 < ord.length; ++i4) {
            if (!(freq[ord[i4]] > 0.0)) continue;
            double[] tempPrev = (double[])prevInf.clone();
            for (int j = 0; j < tempPrev.length; ++j) {
                if (exclude[j]) {
                    tempPrev[j] = 0.0;
                    continue;
                }
                int n = j;
                tempPrev[n] = tempPrev[n] + mis[j];
            }
            Pair<Sequence, Double>[] part = SeqLogoPlotter.sortLocal3(partSort[ord[i4]].toArray(new Pair[0]), numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, tempPrev);
            int j = 0;
            while (j < part.length) {
                sortTemp[off] = part[j];
                ++j;
                ++off;
            }
        }
        return sortTemp;
    }

    private static Pair<Sequence, Double>[][] sortLocal2(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[][] fullPFM, double threshold, LinkedList<ComparableElement<Integer, Double>> pivots) throws Exception {
        int j;
        int i;
        if (maxNum <= 0 || sortTemp.length < minElements) {
            return new Pair[][]{sortTemp};
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        for (int i2 = 0; i2 < temp.length; ++i2) {
            temp[i2] = sortTemp[i2].getFirstElement();
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        double[][] deps = pair.getSecondElement();
        int best = ToolBox.getMaxIndex(inf);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < threshold) {
            return new Pair[][]{sortTemp};
        }
        exclude[best] = true;
        Pair<Sequence, Double>[][] partSort = SeqLogoPlotter.partition(sortTemp, minElements, best, inf[best] / (double)temp.length / (double)numBestForSorting, sortByWeights, pivots);
        double[] kls = deps[best];
        int i3 = 0;
        while (i3 < kls.length) {
            int n = i3++;
            kls[n] = kls[n] / (double)temp.length;
        }
        int[] o2 = ToolBox.order(kls, true);
        int secpos = -1;
        for (int i4 = 0; i4 < o2.length; ++i4) {
            if (exclude[o2[i4]] || !(kls[o2[i4]] > threshold)) continue;
            secpos = o2[i4];
            break;
        }
        if (secpos > -1) {
            LinkedList<Pair<Sequence, Double>[]> list = new LinkedList<Pair<Sequence, Double>[]>();
            for (i = 0; i < partSort.length; ++i) {
                if (partSort[i] == null) continue;
                Pair<Sequence, Double>[][] temp2 = SeqLogoPlotter.partition(partSort[i], minElements, secpos, kls[secpos], sortByWeights, pivots);
                temp2 = SeqLogoPlotter.joinSmall(temp2, minElements, sortByWeights);
                for (j = 0; j < temp2.length; ++j) {
                    list.add(temp2[j]);
                }
            }
            partSort = (Pair[][])list.toArray((T[])new Pair[0][0]);
            --maxNum;
            exclude[secpos] = true;
        }
        partSort = SeqLogoPlotter.joinSmall(partSort, minElements, false);
        LinkedList<Pair<Sequence, Double>[]> partitions = new LinkedList<Pair<Sequence, Double>[]>();
        for (i = 0; i < partSort.length; ++i) {
            if (partSort[i] == null) continue;
            Pair<Sequence, Double>[][] part = SeqLogoPlotter.sortLocal2(partSort[i], numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, fullPFM, threshold, pivots);
            for (j = 0; j < part.length; ++j) {
                partitions.add(part[j]);
            }
        }
        return (Pair[][])partitions.toArray((T[])new Pair[0][0]);
    }

    private static Pair<Sequence, Double>[][] joinSmall(Pair<Sequence, Double>[][] partSort, int minElements, boolean sortByWeights) {
        int i;
        if (partSort.length == 1) {
            return partSort;
        }
        boolean[] out = new boolean[partSort.length];
        int minAbove = Integer.MAX_VALUE;
        int idx = -1;
        int nout = 0;
        for (int i2 = 0; i2 < partSort.length; ++i2) {
            if (partSort[i2] == null) continue;
            if (partSort[i2].length < minElements) {
                out[i2] = true;
                nout += partSort[i2].length;
                continue;
            }
            if (partSort[i2].length >= minAbove) continue;
            minAbove = partSort[i2].length;
            idx = i2;
        }
        if (nout == 0 && idx == -1) {
            return partSort;
        }
        if (idx == -1) {
            minAbove = 0;
        }
        Pair[] joined = new Pair[minAbove + nout];
        int off = 0;
        if (idx > -1) {
            System.arraycopy(partSort[idx], 0, joined, 0, partSort[idx].length);
            off = partSort[idx].length;
        } else {
            for (i = 0; i < out.length; ++i) {
                if (!out[i]) continue;
                idx = i;
                break;
            }
        }
        for (i = 0; i < partSort.length; ++i) {
            if (partSort[i] == null || !out[i]) continue;
            System.arraycopy(partSort[i], 0, joined, off, partSort[i].length);
            off += partSort[i].length;
            partSort[i] = null;
        }
        partSort[idx] = joined;
        if (sortByWeights) {
            double[] meanw = new double[partSort.length];
            for (int i3 = 0; i3 < partSort.length; ++i3) {
                if (partSort[i3] == null) {
                    meanw[i3] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                for (int j = 0; j < partSort[i3].length; ++j) {
                    int n = i3;
                    meanw[n] = meanw[n] + partSort[i3][j].getSecondElement();
                }
                int n = i3;
                meanw[n] = meanw[n] / (double)partSort[i3].length;
            }
            int[] o = ToolBox.order(meanw, true);
            Pair[][] temp = new Pair[partSort.length][];
            for (int i4 = 0; i4 < o.length; ++i4) {
                temp[i4] = partSort[o[i4]];
            }
            partSort = temp;
        }
        return partSort;
    }

    private static double[] getAvgKLs(Pair<Sequence, Double>[] sortTemp, Pair<Sequence, Double>[][] partSort) throws EmptyDataSetException, WrongAlphabetException, CloneNotSupportedException {
        double[][] all = SeqLogoPlotter.getPFM(sortTemp);
        double n = sortTemp.length;
        double[] allAvgKLs = new double[sortTemp[0].getFirstElement().getLength()];
        for (int i = 0; i < partSort.length; ++i) {
            if (partSort[i] == null) continue;
            double[][] curr = SeqLogoPlotter.getPFM(partSort[i]);
            double m = partSort[i].length;
            double[] kls = SeqLogoPlotter.getKLDivergence(curr, (double[][])ArrayHandler.clone((Cloneable[])all));
            for (int j = 0; j < kls.length; ++j) {
                int n2 = j;
                allAvgKLs[n2] = allAvgKLs[n2] + m / n * kls[j];
            }
        }
        return allAvgKLs;
    }

    private static double[][] getPFM(Pair<Sequence, Double>[] sortTemp) throws EmptyDataSetException, WrongAlphabetException {
        LinkedList<Sequence> seqTemp = new LinkedList<Sequence>();
        for (int i = 0; i < sortTemp.length; ++i) {
            seqTemp.add(sortTemp[i].getFirstElement());
        }
        double[][] partPFM = PFMComparator.getPFM(new DataSet("", seqTemp));
        return partPFM;
    }

    private static Pair<Sequence, Double>[][] partition(Pair<Sequence, Double>[] sortTemp, int minElements, int[] ord, double[] values, int idx, boolean sortByWeights, LinkedList<ComparableElement<Integer, Double>> pivots) {
        if (idx == ord.length) {
            return new Pair[][]{sortTemp};
        }
        Pair<Sequence, Double>[][] partitions = SeqLogoPlotter.partition(sortTemp, minElements, ord[idx], values[idx], sortByWeights, pivots);
        LinkedList<Pair<Sequence, Double>[]> pairs = new LinkedList<Pair<Sequence, Double>[]>();
        for (int i = 0; i < partitions.length; ++i) {
            if (partitions[i] == null) continue;
            Pair<Sequence, Double>[][] part2 = SeqLogoPlotter.partition(partitions[i], minElements, ord, values, idx + 1, sortByWeights, pivots);
            for (int j = 0; j < part2.length; ++j) {
                pairs.add(part2[j]);
            }
        }
        return (Pair[][])pairs.toArray((T[])new Pair[0][0]);
    }

    private static Pair<Sequence, Double>[][] partition(Pair<Sequence, Double>[] sortTemp, int minElements, int curr, double value, boolean sortByWeights, LinkedList<ComparableElement<Integer, Double>> pivots) {
        int i;
        if (sortTemp.length < minElements) {
            return new Pair[][]{sortTemp};
        }
        if (pivots != null) {
            pivots.add(new ComparableElement<Integer, Double>(curr, value * (double)sortTemp.length));
        }
        LinkedList[] partSort = new LinkedList[4];
        for (int i2 = 0; i2 < partSort.length; ++i2) {
            partSort[i2] = new LinkedList();
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        for (i = 0; i < sortTemp.length; ++i) {
            Sequence seq = sortTemp[i].getFirstElement();
            int idx = seq.discreteVal(curr);
            partSort[idx].add(sortTemp[i]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i].getSecondElement();
        }
        if (sortByWeights) {
            for (i = 0; i < freq.length; ++i) {
                freq[i] = ws[i] / freq[i];
            }
        }
        int[] ord = ToolBox.order(freq, true);
        boolean off = false;
        Pair[][] partitions = new Pair[4][];
        for (int i3 = 0; i3 < ord.length; ++i3) {
            if (partSort[ord[i3]].size() <= 0) continue;
            partitions[i3] = partSort[ord[i3]].toArray(new Pair[0]);
        }
        return partitions;
    }

    private static double[] getKLDivergence(double[][] partPFM, double[][] fullPFM) {
        double full = ToolBox.sum(fullPFM[0]);
        double part = ToolBox.sum(partPFM[0]);
        double[] kls = new double[partPFM.length];
        for (int i = 0; i < fullPFM.length; ++i) {
            Normalisation.sumNormalisation(fullPFM[i]);
            Normalisation.sumNormalisation(partPFM[i]);
            for (int j = 0; j < fullPFM[i].length; ++j) {
                if (!(partPFM[i][j] > 0.0)) continue;
                int n = i;
                kls[n] = kls[n] + partPFM[i][j] * Math.log(partPFM[i][j] / fullPFM[i][j]);
            }
        }
        return kls;
    }

    private static Pair<double[], double[][]> getInformation(Sequence[] seqs, int numBest, boolean[] exclude) {
        double[][] mis = SeqLogoPlotter.getDeps(seqs, null);
        double[] vals = new double[seqs[0].getLength()];
        for (int i = 0; i < vals.length; ++i) {
            int[] o = ToolBox.order(mis[i], true);
            vals[i] = 0.0;
            if (exclude != null && exclude[i]) continue;
            int j = 0;
            for (int k = 0; k < numBest && j < mis[i].length; ++k, ++j) {
                int n = i;
                vals[n] = vals[n] + mis[i][o[j]];
            }
        }
        return new Pair<double[], double[][]>(vals, mis);
    }

    private static void plotColorLogo(Graphics2D graph, double[][] pwm, double weight, boolean mix, boolean icscale, int height, int width, int offx, int offy) {
        graph = (Graphics2D)graph.create();
        Color back = graph.getColor();
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, height);
        graph.setColor(back);
        int partWidth = (int)Math.floor((double)width / (double)pwm.length);
        double[] temp = new double[4];
        for (int i = 0; i < pwm.length; ++i) {
            if (mix) {
                Color c = SeqLogoPlotter.getColor(pwm[i], icscale ? (float)Math.sqrt(SeqLogoPlotter.getICScale(pwm[i])) : 1.0f);
                back = graph.getColor();
                graph.setColor(c);
                graph.fillRect(offx, offy, partWidth, height);
                graph.setColor(back);
            } else {
                int off2 = 0;
                float ic = icscale ? (float)Math.sqrt(SeqLogoPlotter.getICScale(pwm[i])) : 1.0f;
                for (int j = 0; j < pwm[i].length; ++j) {
                    Arrays.fill(temp, 0.0);
                    temp[j] = 1.0;
                    Color c = SeqLogoPlotter.getColor(temp, ic);
                    back = graph.getColor();
                    graph.setColor(c);
                    int partHeight = (int)Math.round((double)height * pwm[i][j]);
                    graph.fillRect(offx, offy + off2, partWidth, j < pwm[i].length - 1 ? partHeight : height - off2);
                    off2 += partHeight;
                    graph.setColor(back);
                }
            }
            offx += partWidth;
        }
        graph.setColor(back);
    }

    public static void plotLogoToPNG(String path, int height, double[][] ps) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotLogoToBufferedImage(int height, double[][] ps) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        return pair.getFirstElement();
    }

    public static Pair<BufferedImage, Graphics2D> getBufferedImageAndGraphics(int height, double[][] ps) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        BufferedImage img = new BufferedImage(w, height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        return new Pair<BufferedImage, Graphics2D>(img, g);
    }

    public static void plotLogo(Graphics2D g, int h, double[][] ps) {
        SeqLogoPlotter.plotLogo(g, h, ps, null, "Position", "bits");
    }

    public static void plotLogo(Graphics2D g, int height, double[][] ps, String[] labels, String labX, String labY) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotLogo(g, w, height, ps, labels, labX, labY);
    }

    public static int getWidth(int height, double[][] ps) {
        return SeqLogoPlotter.getWidth(height, ps.length);
    }

    public static int getWidth(int height, int numCol) {
        return (int)((double)height / 6.0 * (double)numCol + (double)height * 0.4);
    }

    public static int getColumnWidth(int height) {
        return (int)((double)height / 6.0);
    }

    public static int getHeight(int width, double[][] ps) {
        return (int)((double)width * 6.0 / ((double)ps.length + 1.5));
    }

    public static void plotLogo(Graphics2D g, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        SeqLogoPlotter.plotLogo(g, 0, h, w, h, ps, labels, labX, labY);
    }

    public static void plotLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 10);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            for (int i = 0; i < ps.length; ++i) {
                labels[i] = i + 1 + "";
            }
        }
        double wl = (double)h * 0.4;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = wl * 0.9;
        double h2 = (double)h * 0.65;
        double y2 = (double)y - (double)h * 0.3;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke((float)h / 100.0f));
        g.drawLine(x + (int)x2, (int)(y2 + 0.05 * (double)h), x + (int)(x2 + w2 * (double)ps.length), (int)(y2 + 0.05 * (double)h));
        g.drawLine(x + (int)(x2 * 0.94), (int)y2, x + (int)(x2 * 0.94), (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        for (int i = 0; i <= 4; ++i) {
            g.drawLine(x + (int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), x + (int)(x2 * 0.94), (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], x + (int)(x2 * 0.6 - rect.getWidth()), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
        x2 = wl;
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, x + (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.2 * rect.getHeight()));
        for (int i = 0; i < ps.length; ++i) {
            SeqLogoPlotter.plotLogo(g, (double)x + x2, y2, w2, h2, ps[i]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i], g);
            g.drawString(labels[i], (float)x + (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 1.5 * rect.getHeight()));
            x2 += w2;
        }
    }

    public static void plotTALgetterLogoToPNG(String path, int height, double[][] ps, double[] imp, String[] lab) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotTALgetterLogoToBufferedImage(int height, double[][] ps, double[] imp, String[] lab) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        return pair.getFirstElement();
    }

    public static void plotTALgetterLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, double[] imp, String[] labels, String labX, String labY, String labY2) {
        int i;
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            for (int i2 = 0; i2 < ps.length; ++i2) {
                labels[i2] = i2 + 1 + "";
            }
        }
        double wl = (double)h * 0.5;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = (double)x + wl * 0.45;
        double h2 = (double)h * 0.7;
        double y2 = (double)y * 0.75;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(h / 400 + 1));
        g.drawLine((int)x2, (int)(y2 * 1.04) + 1, (int)(x2 + w2 * (double)ps.length), (int)(y2 * 1.04) + 1);
        g.drawLine((int)(x2 * 0.94) - 1, (int)y2, (int)(x2 * 0.94) - 1, (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        for (int i3 = 0; i3 <= 4; ++i3) {
            g.drawLine((int)(x2 * 0.7), (int)(y2 - (double)i3 * h2 / 4.0), (int)(x2 * 0.94) - 1, (int)(y2 - (double)i3 * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i3], g);
            g.drawString(labs[i3], (int)(x2 * 0.6 - rect.getWidth() - 2.0), (int)(y2 - (double)i3 * h2 / 4.0 - rect.getCenterY()));
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getHeight()));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        for (int i4 = 0; i4 < ps.length; ++i4) {
            SeqLogoPlotter.plotLogo(g, x2, y2, w2, h2, ps[i4]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i4], g);
            g.drawString(labels[i4], (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
        }
        g.drawLine((int)(x2 + w2 * 0.1) + 1, (int)y2, (int)(x2 + w2 * 0.1) + 1, (int)(y2 - h2));
        labs = new String[]{"0", "0.5", "1"};
        Rectangle2D rect2 = g.getFontMetrics().getStringBounds("0.5", g);
        for (i = 0; i <= 2; ++i) {
            g.drawLine((int)(x2 + w2 * 0.34) + 2, (int)(y2 - (double)i * h2 / 2.0), (int)(x2 + w2 * 0.1) + 1, (int)(y2 - (double)i * h2 / 2.0));
            g.drawString(labs[i], (int)(x2 + w2 * 0.5 + 2.0), (int)(y2 - (double)i * h2 / 2.0 - rect.getCenterY()));
        }
        back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY2, g);
        g.drawString(labY2, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)w - rect.getHeight() / 2.0));
        g.setTransform(back);
        x2 = (double)x + wl * 0.45 + 2.0 * w2;
        g.setColor(Color.GRAY);
        for (i = 1; i < imp.length; ++i) {
            g.drawLine((int)(x2 - w2 / 2.0 + w2 / 20.0), (int)(y2 - h2 * imp[i - 1] + w2 / 20.0), (int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i] + w2 / 20.0));
            x2 += w2;
        }
        x2 = (double)x + wl * 0.45 + w2;
        g.setColor(Color.BLUE);
        for (i = 0; i < imp.length; ++i) {
            g.fillRect((int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i]), (int)(w2 / 10.0), (int)(w2 / 10.0));
            x2 += w2;
        }
    }

    protected static void plotLogo(Graphics2D g, double x, double y, double w, double h, double[] p) {
        int i;
        double ic = SeqLogoPlotter.getICScale(p);
        h *= ic;
        double[] mp = (double[])p.clone();
        int i2 = 0;
        while (i2 < mp.length) {
            int n = i2++;
            mp[n] = mp[n] * -1.0;
        }
        int[] r = ToolBox.rank(mp, false);
        int[] order = new int[r.length];
        for (i = 0; i < r.length; ++i) {
            order[r[i]] = i;
        }
        for (i = 0; i < order.length; ++i) {
            double curr = p[order[i]];
            if (order[i] == 0) {
                g.setColor(Color.GREEN);
                g.fill(SeqLogoPlotter.getA(x, y, w, h * curr));
            } else if (order[i] == 1) {
                g.setColor(Color.BLUE);
                g.fill(SeqLogoPlotter.getC(x, y, w, h * curr));
            } else if (order[i] == 2) {
                g.setColor(Color.ORANGE);
                g.fill(SeqLogoPlotter.getG(x, y, w, h * curr));
            } else {
                g.setColor(Color.RED);
                g.fill(SeqLogoPlotter.getT(x, y, w, h * curr));
            }
            y -= h * curr;
        }
    }

    public static double getICScale(double[] p) {
        double ic;
        double max = ic = Math.log(p.length) / Math.log(2.0);
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i] > 0.0)) continue;
            ic += p[i] * Math.log(p[i]) / Math.log(2.0);
        }
        return ic /= max;
    }

    private static Area getC(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        AffineTransform t = new AffineTransform();
        t.scale(0.011363636363636364, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getT(double x, double y, double w, double h) {
        Rectangle2D.Double s = new Rectangle2D.Double(37.5, -100.0, 15.0, 100.0);
        Area a1 = new Area(s);
        Rectangle2D.Double s2 = new Rectangle2D.Double(0.0, -100.0, 90.0, 15.0);
        Area a2 = new Area(s2);
        a1.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getG(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        Rectangle2D.Double s4 = new Rectangle2D.Double(55.0, -40.0, 35.0, 15.0);
        Area a4 = new Area(s4);
        a1.add(a4);
        Rectangle2D.Double s5 = new Rectangle2D.Double(80.0, -40.0, 10.0, 40.0);
        Area a5 = new Area(s5);
        a1.add(a5);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getA(double x, double y, double w, double h) {
        Polygon s = new Polygon(new int[]{0, 40, 50, 90, 75, 45, 45, 15, 0}, new int[]{0, -100, -100, 0, 0, -80, -80, 0, 0}, 9);
        Area a = new Area(s);
        Polygon s2 = new Polygon(new int[]{20, 70, 70, 20}, new int[]{-35, -35, -50, -50}, 4);
        Area a2 = new Area(s2);
        a.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a.transform(t);
        return a;
    }

    public static class SeqLogoPlotGenerator
    implements PlotGeneratorResult.PlotGenerator {
        private double[][] pwm;
        private int height;

        public SeqLogoPlotGenerator(double[][] pwm, int height) {
            this.pwm = pwm;
            this.height = height;
        }

        public SeqLogoPlotGenerator(StringBuffer xml) throws NonParsableException {
            this.pwm = (double[][])XMLParser.extractObjectForTags(xml, "pwm");
            this.height = (Integer)XMLParser.extractObjectForTags(xml, "height");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.pwm, "pwm");
            XMLParser.appendObjectWithTags(xml, this.height, "height");
            return xml;
        }

        @Override
        public void generatePlot(GraphicsAdaptor ga) throws Exception {
            int width = SeqLogoPlotter.getWidth(this.height, this.pwm);
            SeqLogoPlotter.plotLogo(ga.getGraphics(width, this.height), this.height, this.pwm);
        }
    }
}

