/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.galaxy;

import de.jstacs.DataType;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class GalaxyAdaptor {
    private ParameterSet parameters;
    private JstacsTool.ResultEntry[] defaultResults;
    private String[] defaultResultPaths;
    private boolean[] addLine;
    private String toolname;
    private String description;
    private String help;
    private String command;
    private String version;
    private NumberFormat format;
    private NumberFormat expFormat;
    private String labelName;
    private Protocol protocol;
    private boolean exportProtocol;
    private LinkedList<OutputElement> list = new LinkedList();
    private String outfile;
    private String outfileId;
    private String newFilePath;
    private String htmlFilesPath;
    private int threads;
    public static String stylesheet = "<style type=\"text/css\">body{font-family:sans-serif;font-size:10pt}\ntable{font-size:10pt;border-spacing:0px}\nth{font-weight:bold}\ndiv.tophead{font-size:16px;line-height:24px;padding:5px 10px;background:#ebd9b2;border-bottom:solid #d8b365 1px;font-weight:bold}\ndiv.head{font-size:12px;line-height:16px;padding:5px 10px;background:#ddddff;border-bottom:solid #8888ff 1px;font-weight:bold}\ndiv.comment{color:grey}\ndiv.tt{font-family:monospace}\nh2{text-align:center}</style>";
    private static int htmlId = 0;
    private static String[] colors = new String[]{"#99FFFF", "#CCCCFF", "#99FFCC", "#CCFF99", "#FFCC99"};

    public int getThreads() {
        return this.threads;
    }

    public static String getColor(int depth) {
        while (depth >= colors.length) {
            depth -= colors.length;
        }
        return colors[depth];
    }

    public static int getHtmlId() {
        return htmlId++;
    }

    public GalaxyAdaptor(ParameterSet parameters, JstacsTool.ResultEntry[] defaultResults, boolean[] addLine, String toolname, String description, String version, String command, String labelName) {
        this.parameters = parameters;
        if (defaultResults == null) {
            this.defaultResults = new JstacsTool.ResultEntry[0];
            this.defaultResultPaths = new String[0];
        } else {
            this.defaultResults = defaultResults;
            this.defaultResultPaths = new String[defaultResults.length];
        }
        this.addLine = addLine == null ? null : (boolean[])addLine.clone();
        this.toolname = toolname;
        this.description = description;
        this.version = version;
        this.help = description;
        this.command = command;
        this.labelName = labelName;
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
        this.format.setMinimumFractionDigits(3);
        this.expFormat = new DecimalFormat("0.00E0");
        this.threads = 1;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setHelp(File helpfile) throws IOException {
        BufferedReader read = new BufferedReader(new FileReader(helpfile));
        String temp = null;
        StringBuffer helpb = new StringBuffer();
        while ((temp = read.readLine()) != null) {
            helpb.append(temp);
            helpb.append("\n");
        }
        read.close();
        this.help = helpb.toString();
    }

    public Protocol getProtocol(boolean exportProtocol) {
        this.exportProtocol = exportProtocol;
        this.protocol = new Protocol();
        return this.protocol;
    }

    public String toGalaxyConfig(boolean configureThreads) throws Exception {
        StringBuffer allBuffer = new StringBuffer();
        XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.description, "description", null, false);
        allBuffer.append("\n");
        StringBuffer defaultOuts = new StringBuffer();
        String[] defaultNames = new String[this.defaultResults.length];
        HashSet<String> hash = new HashSet<String>();
        for (int i = 0; i < this.defaultResults.length; ++i) {
            defaultNames[i] = this.defaultResults[i].getName().replaceAll("(\\s|-)", "_");
            if (hash.contains(defaultNames[i])) {
                int j = 0;
                while (hash.contains(defaultNames[i] + "_" + j)) {
                    ++j;
                }
                int n = i;
                defaultNames[n] = defaultNames[n] + "_" + j;
            }
            hash.add(defaultNames[i]);
            defaultOuts.append(" $" + defaultNames[i]);
        }
        if (configureThreads) {
            XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.command + " --run $script_file $summary $summary.id $__new_file_path__ $summary.extra_files_path \\${GALAXY_SLOTS:-1}" + defaultOuts.toString(), "command", null, false);
        } else {
            XMLParser.appendObjectWithTagsAndAttributes(allBuffer, this.command + " --run $script_file $summary $summary.id $__new_file_path__ $summary.extra_files_path" + defaultOuts.toString(), "command", null, false);
        }
        allBuffer.append("\n");
        StringBuffer descBuffer = new StringBuffer();
        StringBuffer confBuffer = new StringBuffer();
        if (this.labelName != null) {
            XMLParser.addTagsAndAttributes(descBuffer, "param", "type=\"text\" size=\"40\" name=\"" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName + "\" label=\"Job name\" value=\"\" optional=\"true\" help=\"Please enter a name for your job that should be used in the history (optional)\"");
        }
        if (this.parameters instanceof SimpleParameterSet) {
            ((SimpleParameterSet)this.parameters).toGalaxy(GalaxyAdaptor.getLegalName(this.toolname), "", 0, descBuffer, confBuffer, this.addLine);
        } else {
            this.parameters.toGalaxy(GalaxyAdaptor.getLegalName(this.toolname), "", 0, descBuffer, confBuffer, false);
        }
        XMLParser.addTags(descBuffer, "inputs");
        confBuffer = GalaxyAdaptor.escape(confBuffer);
        XMLParser.addTagsAndAttributes(confBuffer, "configfile", "name=\"script_file\"");
        XMLParser.addTags(confBuffer, "configfiles");
        allBuffer.append(descBuffer);
        allBuffer.append(confBuffer);
        StringBuffer outBuf = new StringBuffer();
        String jobName = this.labelName == null ? "#$tool.name + ' on ' + $on_string" : "#if str($" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName + ") == '' then $tool.name + ' on ' + $on_string else $" + GalaxyAdaptor.getLegalName(this.toolname) + "_" + this.labelName;
        XMLParser.addTagsAndAttributes(outBuf, "data", "format=\"html\" name=\"summary\" label=\"" + jobName + "#\"");
        outBuf.append("\n");
        for (int i = 0; i < this.defaultResults.length; ++i) {
            String type = this.defaultResults[i].getFormat();
            if (type == null) {
                type = GalaxyAdaptor.getDefaultExtension(this.defaultResults[i].getDeclaredClass());
            }
            String label = jobName + "#: " + this.defaultResults[i].getName();
            StringBuffer temp = new StringBuffer();
            if (type == null) {
                XMLParser.addTagsAndAttributes(temp, "data", "auto_format=\"True\" name=\"" + defaultNames[i] + "\" label=\"" + label + "\"");
            } else {
                XMLParser.addTagsAndAttributes(temp, "data", "format=\"" + type + "\" name=\"" + defaultNames[i] + "\" label=\"" + label + "\"");
            }
            temp.append("\n");
            outBuf.append(temp);
        }
        XMLParser.addTags(outBuf, "outputs");
        allBuffer.append(outBuf);
        StringBuffer helpBuf = new StringBuffer();
        helpBuf.append(this.help);
        XMLParser.addTags(helpBuf, "help");
        allBuffer.append(helpBuf);
        XMLParser.addTagsAndAttributes(allBuffer, "tool", "id=\"" + GalaxyAdaptor.getLegalName(this.toolname) + "\" name=\"" + this.toolname + "\" version=\"" + this.version + "\" force_history_refresh=\"true\"");
        return allBuffer.toString();
    }

    public void fromGalaxyConfig(String filename) throws Exception {
        StringBuffer buf = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String tmp = null;
        while ((tmp = read.readLine()) != null) {
            buf.append(tmp);
        }
        read.close();
        this.parameters.fromGalaxy(GalaxyAdaptor.getLegalName(this.toolname), buf);
    }

    private String getLROutput(ListResult lr) throws IOException {
        StringBuffer all = new StringBuffer();
        if (lr.getAnnotation() != null) {
            ResultSet annotation = lr.getAnnotation();
            for (int i = 0; i < annotation.getNumberOfResults(); ++i) {
                Result r = annotation.getResultAt(i);
                DataType d = r.getDatatype();
                if (d == DataType.PNG || d == DataType.HTML || d == DataType.LIST || d == DataType.STORABLE) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("<label>" + r.getName() + ":</label>");
                sb.append(r.getValue().toString());
                XMLParser.addTags(sb, "div");
                all.append(sb);
            }
        }
        StringBuffer list = new StringBuffer();
        ResultSet[] res = lr.getValue();
        for (int i = 0; i < res.length; ++i) {
            int j;
            boolean newNames = i == 0;
            int k = res[i].getNumberOfResults() - 1;
            if (!newNames) {
                if (k + 1 != res[i - 1].getNumberOfResults()) {
                    newNames = true;
                } else {
                    for (j = 0; j <= k; ++j) {
                        if (res[i].getResultAt(j).getName().equals(res[i - 1].getResultAt(j).getName())) continue;
                        newNames = true;
                        break;
                    }
                }
            }
            if (newNames) {
                if (i != 0) {
                    list.append("</table>");
                }
                list.append("<table border=\"1\">");
                list.append("<tr>");
                for (j = 0; j <= k; ++j) {
                    list.append("<th>" + res[i].getResultAt(j).getName() + "</th>");
                }
                list.append("</tr>");
            }
            list.append("<tr>");
            for (j = 0; j <= k; ++j) {
                if (res[i].getResultAt(j) instanceof SimpleResult) {
                    if (res[i].getResultAt(j).getDatatype() == DataType.DOUBLE || res[i].getResultAt(j).getDatatype() == DataType.FLOAT) {
                        double d = ((Number)res[i].getResultAt(j).getValue()).doubleValue();
                        if (Math.abs(d) < 0.01 && d != 0.0) {
                            list.append("<td>" + this.expFormat.format(d) + "</td>");
                            continue;
                        }
                        list.append("<td>" + this.format.format(d) + "</td>");
                        continue;
                    }
                    list.append("<td>" + res[i].getResultAt(j).getValue() + "</td>");
                    continue;
                }
                list.append("<td>" + this.getOutput(res[i].getResultAt(j)) + "</td>");
            }
            list.append("</tr>");
        }
        list.append("</table>");
        XMLParser.addTags(list, "div");
        all.append(list);
        return all.toString();
    }

    private String getOutput(Result res) throws IOException {
        StringBuffer temp;
        StringBuffer buf = new StringBuffer();
        StringBuffer temp2 = new StringBuffer();
        temp2.append(res.getName());
        if (res instanceof HeadResult) {
            XMLParser.addTagsAndAttributes(temp2, "div", "class=\"tophead\"");
        } else {
            XMLParser.addTagsAndAttributes(temp2, "div", "class=\"head\"");
        }
        temp2.append("<br />");
        if (res instanceof SimpleResult) {
            temp = new StringBuffer();
            temp.append(res.getValue().toString().replaceAll("\\n", "<br />"));
            XMLParser.addTags(temp, "div");
            buf.append(temp);
        } else if (res instanceof ListResult) {
            buf.append(this.getLROutput((ListResult)res));
        } else if (res instanceof DataSetResult) {
            buf.append(this.getDataSetOutput((DataSetResult)res));
        } else if (res instanceof StorableResult) {
            buf.append(this.getStorableOutput((StorableResult)res));
        } else if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            buf.append(this.getDTROutput((AbstractScoreBasedClassifier.DoubleTableResult)res));
        } else if (res instanceof ImageResult) {
            buf.append(this.getIROutput((ImageResult)res));
        } else if (res instanceof FileResult) {
            buf.append(this.getFileOutput((FileResult)res));
        } else if (res instanceof LineBasedResult) {
            buf.append(this.getLBOutput((LineBasedResult)res));
        } else if (res instanceof TextResult) {
            buf.append("<div class=\"tt\">" + ((TextResult)res).getValue().getContent().replaceAll("\n", "<br>") + "</div>");
        }
        temp = new StringBuffer();
        temp.append(res.getComment());
        if (res instanceof LinkedImageResult) {
            temp.append("<br />Obtain &quot;" + ((LinkedImageResult)res).getLink().getName() + "&quot; (" + ((LinkedImageResult)res).getLink().getComment() + ") by clicking on the image");
        }
        XMLParser.addTagsAndAttributes(temp, "div", "class=\"comment\"");
        temp.append("<br />");
        buf.append(temp);
        temp2.append(buf);
        return temp2.toString();
    }

    private StringBuffer getLBOutput(LineBasedResult res) {
        StringBuffer sb = new StringBuffer();
        res.reset();
        String line = null;
        while ((line = res.getNextLine(false)) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb;
    }

    private String getDTROutput(AbstractScoreBasedClassifier.DoubleTableResult res) {
        double[][] r = res.getValue();
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\">");
        for (int i = 0; i < r.length; ++i) {
            sb.append("<tr>");
            for (int j = 0; j < r[i].length; ++j) {
                sb.append("<td>" + r[i][j] + "</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String getIROutput(ImageResult res) throws IOException {
        String name = GalaxyAdaptor.getLegalName(res.getName()) + GalaxyAdaptor.getHtmlId() + ".";
        String filename = this.htmlFilesPath + System.getProperty("file.separator") + name;
        File f = new File(filename + "png");
        f.getParentFile().mkdirs();
        BufferedImage img = res.getValue();
        ImageIO.write((RenderedImage)img, "png", f);
        String ext = "png";
        StringBuffer sb = new StringBuffer();
        sb.append("<img src=\"" + name + ext + "\" alt=\"" + res.getName() + "\" width=\"" + Math.min(700, img.getWidth()) + "\" height=\"" + (int)Math.min((double)img.getHeight() * 700.0 / (double)img.getWidth(), (double)img.getHeight()) + "\"/>");
        if (res instanceof LinkedImageResult) {
            FileResult fr = ((LinkedImageResult)res).getLink();
            XMLParser.addTagsAndAttributes(sb, "a", "href=\"" + fr.getFilename() + "." + fr.getExtension() + "\"");
            this.export(this.getHtmlFilesPath() + System.getProperty("file.separator") + fr.getFilename() + ".", fr, fr.getExtension());
        }
        return sb.toString();
    }

    private String getFileOutput(FileResult res) {
        return "<a href=\"" + res.getFilename() + "." + res.getExtension() + "\">" + res.getName() + "</a>";
    }

    private String getStorableOutput(StorableResult res) throws IOException {
        String name = GalaxyAdaptor.getLegalName(res.getName()) + GalaxyAdaptor.getHtmlId() + ".";
        String ext = this.export(this.htmlFilesPath + System.getProperty("file.separator") + name, res, null);
        return "<a href=\"" + name + ext + "\">" + res.getName() + "</a>";
    }

    private String getDataSetOutput(DataSetResult res) throws IOException {
        DataSet data = res.getValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (res.getParser() == null) {
            data.save(baos, '>', new SplitSequenceAnnotationParser(":", ";"));
        } else {
            data.save(baos, '>', res.getParser());
        }
        return baos.toString().replaceAll("\\n", "<br />");
    }

    private String getOutput(ResultSet res) throws IOException {
        Result[] ress = null;
        ress = res instanceof MeanResultSet ? ((MeanResultSet)res).getStatistics().getResults() : res.getResults();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ress.length; ++i) {
            sb.append(this.getOutput(ress[i]));
        }
        return sb.toString();
    }

    public static String getDefaultExtension(Class<? extends Result> resClass) {
        if (SimpleResult.class.isAssignableFrom(resClass)) {
            return "txt";
        }
        if (ListResult.class.isAssignableFrom(resClass)) {
            return "tabular";
        }
        if (DataSetResult.class.isAssignableFrom(resClass)) {
            return "fasta";
        }
        if (StorableResult.class.isAssignableFrom(resClass)) {
            return "xml";
        }
        if (AbstractScoreBasedClassifier.DoubleTableResult.class.isAssignableFrom(resClass)) {
            return "tabular";
        }
        if (ImageResult.class.isAssignableFrom(resClass)) {
            return "png";
        }
        if (FileResult.class.isAssignableFrom(resClass)) {
            return null;
        }
        if (LineBasedResult.class.isAssignableFrom(resClass)) {
            return "tabular";
        }
        if (LinkedImageResult.class.isAssignableFrom(resClass)) {
            return null;
        }
        return null;
    }

    public String export(String filename, Result res, String exportExtension) throws IOException {
        String ee = exportExtension;
        if (res instanceof SimpleResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + ee);
            pw.println(res.toString());
            pw.close();
            return ee;
        }
        if (res instanceof ListResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + ee);
            if (ee.equalsIgnoreCase("gff3")) {
                pw.println("##gff-version 3");
            } else if (ee.equalsIgnoreCase("gff")) {
                pw.println("##gff-version 2");
            }
            ((ListResult)res).print(pw);
            pw.close();
            return ee;
        }
        if (res instanceof DataSetResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(filename + ee);
            if (((DataSetResult)res).getParser() == null) {
                ((DataSetResult)res).getValue().save(fos, '>', new SplitSequenceAnnotationParser(":", ";"));
            } else {
                ((DataSetResult)res).getValue().save(fos, '>', ((DataSetResult)res).getParser());
            }
            fos.close();
            return ee;
        }
        if (res instanceof StorableResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + ee);
            pw.println(((StorableResult)res).getValue());
            pw.close();
            return ee;
        }
        if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + ee);
            double[][] tab = ((AbstractScoreBasedClassifier.DoubleTableResult)res).getValue();
            for (int i = 0; i < tab.length; ++i) {
                for (int j = 0; j < tab[i].length - 1; ++j) {
                    pw.print(tab[i][j] + "\t");
                }
                if (tab[i].length > 0) {
                    pw.println(tab[i][tab[i].length - 1]);
                    continue;
                }
                pw.println();
            }
            pw.close();
            return ee;
        }
        if (res instanceof LinkedImageResult) {
            return this.export(filename, ((LinkedImageResult)res).getLink(), exportExtension);
        }
        if (res instanceof ImageResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            BufferedImage img = ((ImageResult)res).getValue();
            ImageIO.write((RenderedImage)img, ee, new File(filename + ee));
            return ee;
        }
        if (res instanceof FileResult) {
            String ext = ((FileResult)res).getExtension();
            File f = new File(filename + ext);
            f.getParentFile().mkdirs();
            FileManager.copy(((FileResult)res).getValue().getAbsolutePath(), f.getAbsolutePath());
            return ext;
        }
        if (res instanceof LineBasedResult) {
            if (ee == null) {
                ee = GalaxyAdaptor.getDefaultExtension(res.getClass());
            }
            File f = new File(filename + ee);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(filename + ee);
            if (ee.equalsIgnoreCase("gff3")) {
                pw.println("##gff-version 3");
            } else if (ee.equalsIgnoreCase("gff")) {
                pw.println("##gff-version 2");
            }
            LineBasedResult lbr = (LineBasedResult)res;
            lbr.reset();
            String line = "";
            while ((line = lbr.getNextLine(true)) != null) {
                pw.println(line);
            }
            pw.close();
            return ee;
        }
        ResultSaver<?> saver = ResultSaverLibrary.getSaver(res.getClass());
        if (saver != null && saver.isAtomic()) {
            if (ee == null) {
                ee = saver.getFileExtensions(res)[0];
            }
            saver.writeOutput(res, new File(filename + ee));
            return ee;
        }
        return null;
    }

    public void writeOutput() throws IOException {
        StringBuffer summary = new StringBuffer();
        summary.append("<h2>Summary of " + this.toolname + " results</h2>");
        int i = 0;
        for (OutputElement el : this.list) {
            boolean export = el.export;
            Object res = el.result;
            boolean include = el.includeInSummary;
            String str = null;
            if (include) {
                str = res instanceof Result ? this.getOutput((Result)res) : (res instanceof ResultSet ? this.getOutput((ResultSet)res) : res.toString().replaceAll("\\n", "<br />"));
                summary.append(str);
            }
            if (!export) continue;
            if (res instanceof Result) {
                String string;
                String name = ++i + ": " + ((Result)res).getName().replaceAll(System.getProperty("file.separator"), " ");
                String defPath = this.getDefaultPath((Result)res);
                if (defPath == null) {
                    string = this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", (Result)res, el.exportExtension);
                    continue;
                }
                string = this.export(defPath, (Result)res, "");
                continue;
            }
            ResultSet rs = (ResultSet)res;
            for (int j = 0; j < rs.getNumberOfResults(); ++j) {
                String name = ++i + ": " + rs.getResultAt(j).getName().replaceAll(System.getProperty("file.separator"), " ");
                String defPath = this.getDefaultPath(rs.getResultAt(j));
                String string = defPath == null ? this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + name + "_visible_", rs.getResultAt(j), el.exportExtension) : this.export(defPath, rs.getResultAt(j), "");
            }
        }
        if (this.protocol != null) {
            CategoricalResult prot = new CategoricalResult("Protocol", "The protocol of this " + this.toolname + " run", this.protocol.toString());
            summary.append(this.getOutput(prot));
            if (this.exportProtocol) {
                this.export(this.newFilePath + System.getProperty("file.separator") + "primary_" + this.outfileId + "_" + ++i + "_visible_", prot, null);
            }
        }
        StringBuffer all = new StringBuffer();
        StringBuffer head = new StringBuffer();
        head.append("Summary of " + this.toolname + " results");
        XMLParser.addTags(head, "title");
        all.append(head);
        all.append(stylesheet);
        XMLParser.addTags(all, "head");
        XMLParser.addTags(summary, "body");
        all.append(summary);
        XMLParser.addTags(all, "html");
        PrintWriter wr = new PrintWriter(this.outfile);
        wr.println(all);
        wr.close();
    }

    private String getDefaultPath(Result res) {
        for (int i = 0; i < this.defaultResults.length; ++i) {
            if (!res.getClass().equals(this.defaultResults[i].getDeclaredClass()) || !res.getName().equals(this.defaultResults[i].getName())) continue;
            String def = this.defaultResultPaths[i];
            this.defaultResultPaths[i] = null;
            return def;
        }
        return null;
    }

    public boolean parse(String[] args, boolean configureThreads) throws Exception {
        if ("--create".equals(args[0])) {
            String str = this.toGalaxyConfig(configureThreads);
            PrintWriter wr = new PrintWriter(args[1]);
            wr.println(str);
            wr.close();
            return false;
        }
        if ("--run".equals(args[0])) {
            this.fromGalaxyConfig(args[1]);
            this.outfile = args[2];
            this.outfileId = args[3];
            this.newFilePath = args[4];
            this.htmlFilesPath = args[5];
            int i = 6;
            if (configureThreads) {
                this.threads = Integer.parseInt(args[6]);
                i = 7;
            }
            for (int j = i; j < args.length; ++j) {
                this.defaultResultPaths[j - i] = args[j];
            }
            return true;
        }
        return false;
    }

    public void addResult(Result res, boolean export, boolean includeInSummary) {
        this.list.add(new OutputElement(res, export, includeInSummary, null));
    }

    public void addResult(Result res, boolean export, boolean includeInSummary, String exportExtension) {
        this.list.add(new OutputElement(res, export, includeInSummary, exportExtension));
    }

    public void addResultSet(ResultSet res, boolean exportAll, boolean includeInSummary) {
        this.list.add(new OutputElement(res, exportAll, includeInSummary, null));
    }

    public static String getLegalName(String name) {
        return name.replaceAll("[\\s,-:()]+", "_");
    }

    private static StringBuffer escape(StringBuffer str) {
        return new StringBuffer(str.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
    }

    public String getHtmlFilesPath() {
        return this.htmlFilesPath;
    }

    private static class OutputElement {
        private Object result;
        private boolean export;
        private boolean includeInSummary;
        private String exportExtension;

        private OutputElement(Object result, boolean export, boolean includeInSummary, String exportExtension) {
            this.result = result;
            this.export = export;
            this.includeInSummary = includeInSummary;
            this.exportExtension = exportExtension;
        }
    }

    public static class Protocol
    implements de.jstacs.tools.Protocol {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter wr = new PrintWriter(this.baos);

        @Override
        public void append(String str) {
            this.wr.append(str.replaceAll("\n", "<br />\n"));
        }

        public PrintWriter getWriter() {
            return this.wr;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.baos;
        }

        @Override
        public void appendHeading(String str) {
            this.wr.append("<strong>" + str.replaceAll("\n", "<br />\n") + "</strong>\n");
            this.wr.flush();
        }

        @Override
        public void appendWarning(String str) {
            this.wr.append("<em>" + str.replaceAll("\n", "<br />\n") + "</em>\n");
            this.wr.flush();
        }

        public String toString() {
            this.wr.flush();
            return this.baos.toString();
        }

        @Override
        public void appendThrowable(Throwable th) {
            String msg = th.getMessage();
            this.wr.append("<em>" + (msg == null ? th.getClass().getName() : msg.replaceAll("\n", "<br />\n")) + "</em>\n");
            this.wr.flush();
        }

        @Override
        public void appendVerbatim(String verbatim) {
            this.wr.append("<pre>" + verbatim + "</pre>\n");
        }

        @Override
        public void flush() throws IOException {
            this.wr.flush();
        }
    }

    public static class FileResult
    extends Result {
        private String path;
        private String filename;
        private String extension;

        public FileResult(String name, String comment, String fullPath) {
            super(name, comment, DataType.FILE);
            int idx = fullPath.lastIndexOf(System.getProperty("file.separator"));
            int extIdx = fullPath.lastIndexOf(".");
            this.path = fullPath.substring(0, idx);
            this.filename = fullPath.substring(idx + 1, extIdx);
            this.extension = fullPath.substring(extIdx + 1);
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(String name, String comment, String path, String filename, String extension) {
            super(name, comment, DataType.FILE);
            this.path = path;
            this.filename = filename;
            this.extension = extension;
            this.getValue().getParentFile().mkdirs();
        }

        public FileResult(StringBuffer rep) throws NonParsableException {
            super(rep);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.path, "path");
            XMLParser.appendObjectWithTags(sb, this.filename, "filename");
            XMLParser.appendObjectWithTags(sb, this.extension, "extension");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer rep) throws NonParsableException {
            this.path = XMLParser.extractObjectForTags(rep, "path", String.class);
            this.filename = XMLParser.extractObjectForTags(rep, "filename", String.class);
            this.extension = XMLParser.extractObjectForTags(rep, "extension", String.class);
        }

        @Override
        public File getValue() {
            String sep = System.getProperty("file.separator");
            return new File(this.path + sep + this.filename + "." + this.extension);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }
    }

    public static class HeadResult
    extends CategoricalResult {
        public HeadResult(String name, String comment) {
            super(name, comment, "");
        }
    }

    public static class LinkedImageResult
    extends ImageResult {
        private FileResult link;

        public LinkedImageResult(String name, String comment, BufferedImage image, FileResult link) {
            super(name, comment, image);
            this.link = link;
        }

        public LinkedImageResult(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer sb) {
            XMLParser.appendObjectWithTags(sb, this.link, "link");
        }

        @Override
        protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
            this.link = XMLParser.extractObjectForTags(representation, "link", FileResult.class);
        }

        public FileResult getLink() {
            return this.link;
        }
    }

    public static abstract class LineBasedResult
    extends Result {
        protected LineBasedResult(String name, String comment, DataType datatype) {
            super(name, comment, datatype);
        }

        public abstract void reset();

        public abstract String getNextLine(boolean var1);
    }
}

