/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.DataType;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;

public class PMMExplainingAwayResidual
extends Measure {
    public PMMExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public PMMExplainingAwayResidual(byte order, double[] ess) throws Exception {
        this(new PMMExplainingAwayResidualParameterSet(order, ess));
    }

    public PMMExplainingAwayResidual(PMMExplainingAwayResidualParameterSet parameters) throws Exception {
        super(parameters);
    }

    @Override
    public String getInstanceName() {
        return "Permuted Markov model of order " + ((PMMExplainingAwayResidualParameterSet)this.parameters).getOrder() + " with explaining away residual";
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        byte order = ((PMMExplainingAwayResidualParameterSet)this.parameters).getOrder();
        double[] ess = ((PMMExplainingAwayResidualParameterSet)this.parameters).getEss();
        SymmetricTensor t = new SymmetricTensor(length, order);
        double nFg = PMMExplainingAwayResidual.sum(weightsFg) + ess[0];
        double nBg = PMMExplainingAwayResidual.sum(weightsBg) + ess[1];
        PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatistics(fg, weightsFg, length, ess[0]), PMMExplainingAwayResidual.getStatistics(bg, weightsBg, length, ess[1]), nFg, nBg));
        if (order == 2) {
            PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatisticsOrderTwo(fg, weightsFg, length, ess[0]), PMMExplainingAwayResidual.getStatisticsOrderTwo(bg, weightsBg, length, ess[1]), nFg, nBg));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMExplainingAwayResidual.toParents(o, order);
    }

    @Override
    public String getXMLTag() {
        return "pmmExplainingAwayResidual";
    }

    public static class PMMExplainingAwayResidualParameterSet
    extends Measure.MeasureParameterSet {
        public PMMExplainingAwayResidualParameterSet() throws SimpleParameter.DatatypeNotValidException {
            super((Class<? extends Measure>)PMMExplainingAwayResidual.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BYTE, "Order", "The order of the permuted Markov model. Only 1 or 2 allowed.", true, new NumberValidator<Byte>((byte)1, (byte)2))});
        }

        public PMMExplainingAwayResidualParameterSet(byte order, double[] ess) throws Exception {
            this();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue(order);
        }

        public PMMExplainingAwayResidualParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public byte getOrder() {
            return (Byte)((Parameter)this.parameters.get(2)).getValue();
        }

        @Override
        public String getInstanceComment() {
            return "Permuted Markov model - explaining away residual";
        }

        @Override
        public String getInstanceName() {
            return "Build a permuted Markov model using explaining away residual as structure measure.";
        }
    }
}

