/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.Storable;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Measure
implements Cloneable,
Storable,
InstantiableFromParameterSet {
    protected MeasureParameterSet parameters;

    protected Measure(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.parameters = XMLParser.extractObjectForTags(xml, "parameters", MeasureParameterSet.class);
    }

    protected Measure(MeasureParameterSet parameters) throws CloneNotSupportedException {
        this.parameters = (MeasureParameterSet)parameters.clone();
    }

    protected Measure() {
    }

    public abstract String getXMLTag();

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.parameters, "parameters");
        XMLParser.addTags(buf, this.getXMLTag());
        return buf;
    }

    public final InstanceParameterSet<Measure> getCurrentParameterSet() throws Exception {
        return this.parameters;
    }

    public abstract String getInstanceName();

    public abstract int[][] getParents(DataSet var1, DataSet var2, double[] var3, double[] var4, int var5) throws Exception;

    public Measure clone() throws CloneNotSupportedException {
        return (Measure)super.clone();
    }

    protected double[][] getMatrixForKruskal(double[][] fullMatrix) {
        double[][] triang = new double[fullMatrix.length][];
        for (int i = 0; i < triang.length; ++i) {
            triang[i] = new double[triang.length - i - 1];
            for (int j = 0; j < triang[i].length; ++j) {
                triang[i][j] = fullMatrix[i][i + j + 1];
            }
        }
        return triang;
    }

    protected int[][] reStructure(int[][] structure, int length) {
        int[][] dep = new int[length][];
        ArrayList<int[]> edges = new ArrayList<int[]>(structure.length);
        for (int counter3 = 0; counter3 < structure.length; ++counter3) {
            edges.add(structure[counter3]);
        }
        boolean[] used = new boolean[length];
        Arrays.fill(used, false);
        dep[0] = new int[]{0};
        used[0] = true;
        do {
            int counter3 = 0;
            while (counter3 < edges.size()) {
                int[] help = (int[])edges.get(counter3);
                if (used[help[0]] || used[help[1]]) {
                    if (used[help[1]]) {
                        int counter2 = help[1];
                        help[1] = help[0];
                        help[0] = counter2;
                    }
                    dep[help[1]] = (int[])edges.remove(counter3);
                    used[help[1]] = true;
                    continue;
                }
                ++counter3;
            }
        } while (edges.size() > 0);
        return dep;
    }

    protected static int[][] toParents(int[] o, byte order) {
        int[][] parents = new int[o.length][];
        for (int i = 0; i < parents.length; ++i) {
            parents[o[i]] = new int[(order < i ? order : i) + 1];
            for (int j = i; j >= i - order && j >= 0; --j) {
                parents[o[i]][parents[o[i]].length - (i - j) - 1] = o[j];
            }
        }
        return parents;
    }

    protected static void fillTensor(Tensor t, double[][] weights) {
        for (int i = 0; i < weights.length; ++i) {
            for (int j = 0; j < weights[i].length; ++j) {
                if (i != j) {
                    t.setValue((byte)1, weights[i][j], i, j);
                    continue;
                }
                t.setRootValue(i, weights[i][i]);
            }
        }
    }

    protected static void fillTensor(Tensor t, double[][][] weights) {
        for (int i = 0; i < weights.length; ++i) {
            for (int j = 0; j < weights[i].length; ++j) {
                if (i == j) continue;
                for (int k = j + 1; k < weights[j].length; ++k) {
                    if (i == k) continue;
                    t.setValue((byte)2, weights[i][j][k], i, j, k);
                }
            }
        }
    }

    protected static double[][][] getMI(double[][][][][][] counts, double n) {
        double[][][] mi = new double[counts.length][counts.length][counts.length];
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[i].length; ++j) {
                for (int k = j + 1; k < counts[i][j].length; ++k) {
                    for (int a = 0; a < counts[i][j][k].length; ++a) {
                        for (int b = 0; b < counts[i][j][k][a].length; ++b) {
                            for (int c = 0; c < counts[i][j][k][a][b].length; ++c) {
                                double[] dArray = mi[i][j];
                                int n2 = k;
                                dArray[n2] = dArray[n2] + counts[i][j][k][a][b][c] / n * Math.log(n * counts[i][j][k][a][b][c] / (counts[i][i][i][a][a][a] * counts[j][j][k][b][b][c]));
                                double[] dArray2 = mi[i][k];
                                int n3 = j;
                                dArray2[n3] = dArray2[n3] + counts[i][j][k][a][b][c] / n * Math.log(n * counts[i][j][k][a][b][c] / (counts[i][i][i][a][a][a] * counts[j][j][k][b][b][c]));
                            }
                        }
                    }
                }
            }
        }
        return mi;
    }

    protected static double[][][] getCMI(double[][][][][][] fgStats, double[][][][][][] bgStats, double n) {
        double[][][] cmi = new double[fgStats.length][fgStats.length][fgStats.length];
        for (int i = 0; i < fgStats.length; ++i) {
            for (int j = 0; j < fgStats[i].length; ++j) {
                for (int k = j + 1; k < fgStats[i][j].length; ++k) {
                    for (int a = 0; a < fgStats[i][j][k].length; ++a) {
                        for (int b = 0; b < fgStats[i][j][k][a].length; ++b) {
                            for (int c = 0; c < fgStats[i][j][k][a][b].length; ++c) {
                                double[] dArray = cmi[i][j];
                                int n2 = k;
                                dArray[n2] = dArray[n2] + fgStats[i][j][k][a][b][c] / n * Math.log(fgStats[i][j][k][a][b][c] * (fgStats[j][j][k][b][b][c] + bgStats[j][j][k][b][b][c]) / ((fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) * fgStats[j][j][k][b][b][c]));
                                double[] dArray2 = cmi[i][j];
                                int n3 = k;
                                dArray2[n3] = dArray2[n3] + bgStats[i][j][k][a][b][c] / n * Math.log(bgStats[i][j][k][a][b][c] * (fgStats[j][j][k][b][b][c] + bgStats[j][j][k][b][b][c]) / ((fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) * bgStats[j][j][k][b][b][c]));
                                double[] dArray3 = cmi[i][k];
                                int n4 = j;
                                dArray3[n4] = dArray3[n4] + fgStats[i][j][k][a][b][c] / n * Math.log(fgStats[i][j][k][a][b][c] * (fgStats[j][j][k][b][b][c] + bgStats[j][j][k][b][b][c]) / ((fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) * fgStats[j][j][k][b][b][c]));
                                double[] dArray4 = cmi[i][k];
                                int n5 = j;
                                dArray4[n5] = dArray4[n5] + bgStats[i][j][k][a][b][c] / n * Math.log(bgStats[i][j][k][a][b][c] * (fgStats[j][j][k][b][b][c] + bgStats[j][j][k][b][b][c]) / ((fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) * bgStats[j][j][k][b][b][c]));
                            }
                        }
                    }
                }
            }
        }
        return cmi;
    }

    public static double[][][] getEAR(double[][][][][][] fgStats, double[][][][][][] bgStats, double nFg, double nBg) {
        double pcFg = nFg / (nFg + nBg);
        double pcBg = nBg / (nFg + nBg);
        double[][][] ear = new double[fgStats.length][fgStats.length][fgStats.length];
        for (int i = 0; i < fgStats.length; ++i) {
            for (int j = 0; j < fgStats[i].length; ++j) {
                if (i == j) continue;
                for (int k = 0; k < fgStats[i][j].length; ++k) {
                    if (k == j || k == i) continue;
                    for (int a = 0; a < fgStats[i][j][k].length; ++a) {
                        for (int b = 0; b < fgStats[i][j][k][a].length; ++b) {
                            for (int c = 0; c < fgStats[i][j][k][a][b].length; ++c) {
                                double[] dArray = ear[i][j];
                                int n = k;
                                dArray[n] = dArray[n] + pcFg * (fgStats[i][j][k][a][b][c] / nFg * Math.log(nFg * fgStats[i][j][k][a][b][c] / (fgStats[i][i][i][a][a][a] * fgStats[j][j][k][b][b][c])));
                                double[] dArray2 = ear[i][j];
                                int n2 = k;
                                dArray2[n2] = dArray2[n2] + pcBg * (bgStats[i][j][k][a][b][c] / nBg * Math.log(nBg * bgStats[i][j][k][a][b][c] / (bgStats[i][i][i][a][a][a] * bgStats[j][j][k][b][b][c])));
                                double[] dArray3 = ear[i][j];
                                int n3 = k;
                                dArray3[n3] = dArray3[n3] - (fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) / (nFg + nBg) * Math.log((nFg + nBg) * (fgStats[i][j][k][a][b][c] + bgStats[i][j][k][a][b][c]) / ((fgStats[i][i][i][a][a][a] + bgStats[i][i][i][a][a][a]) * (fgStats[j][j][k][b][b][c] + bgStats[j][j][k][b][b][c])));
                            }
                        }
                    }
                }
            }
        }
        return ear;
    }

    protected static double[][][][][][] getStatisticsOrderTwo(DataSet s, double[] weights, int length, double ess) throws Exception {
        int i;
        if (s.getElementLength() != length) {
            throw new Exception("Lengths do not match.");
        }
        AlphabetContainer alph = s.getAlphabetContainer();
        double currEss = 0.0;
        double[][][][][][] counts = new double[length][length][length][][][];
        for (i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[i].length; ++j) {
                for (int k = 0; k < counts[i][j].length; ++k) {
                    counts[i][j][k] = new double[(int)alph.getAlphabetLengthAt(i)][(int)alph.getAlphabetLengthAt(j)][(int)alph.getAlphabetLengthAt(k)];
                    currEss = ess / (alph.getAlphabetLengthAt(i) * alph.getAlphabetLengthAt(j) * alph.getAlphabetLengthAt(k));
                    if (i == j && i == k) {
                        currEss = ess / alph.getAlphabetLengthAt(i);
                    } else if (i == j) {
                        currEss = ess / (alph.getAlphabetLengthAt(i) * alph.getAlphabetLengthAt(k));
                    } else if (i == k || j == k) {
                        currEss = ess / (alph.getAlphabetLengthAt(i) * alph.getAlphabetLengthAt(j));
                    }
                    for (int l = 0; l < counts[i][j][k].length; ++l) {
                        for (int m = 0; m < counts[i][j][k][l].length; ++m) {
                            Arrays.fill(counts[i][j][k][l][m], currEss);
                        }
                    }
                }
            }
        }
        for (i = 0; i < s.getNumberOfElements(); ++i) {
            Sequence seq = s.getElementAt(i);
            double w = weights[i];
            for (int j = 0; j < seq.getLength(); ++j) {
                double[] dArray = counts[j][j][j][seq.discreteVal(j)][seq.discreteVal(j)];
                int n = seq.discreteVal(j);
                dArray[n] = dArray[n] + w;
                for (int k = j + 1; k < seq.getLength(); ++k) {
                    double[] dArray2 = counts[j][j][k][seq.discreteVal(j)][seq.discreteVal(j)];
                    int n2 = seq.discreteVal(k);
                    dArray2[n2] = dArray2[n2] + w;
                    double[] dArray3 = counts[j][k][j][seq.discreteVal(j)][seq.discreteVal(k)];
                    int n3 = seq.discreteVal(j);
                    dArray3[n3] = dArray3[n3] + w;
                    double[] dArray4 = counts[k][j][j][seq.discreteVal(k)][seq.discreteVal(j)];
                    int n4 = seq.discreteVal(j);
                    dArray4[n4] = dArray4[n4] + w;
                    double[] dArray5 = counts[k][k][j][seq.discreteVal(k)][seq.discreteVal(k)];
                    int n5 = seq.discreteVal(j);
                    dArray5[n5] = dArray5[n5] + w;
                    double[] dArray6 = counts[k][j][k][seq.discreteVal(k)][seq.discreteVal(j)];
                    int n6 = seq.discreteVal(k);
                    dArray6[n6] = dArray6[n6] + w;
                    double[] dArray7 = counts[j][k][k][seq.discreteVal(j)][seq.discreteVal(k)];
                    int n7 = seq.discreteVal(k);
                    dArray7[n7] = dArray7[n7] + w;
                    for (int l = k + 1; l < seq.getLength(); ++l) {
                        double[] dArray8 = counts[j][k][l][seq.discreteVal(j)][seq.discreteVal(k)];
                        int n8 = seq.discreteVal(l);
                        dArray8[n8] = dArray8[n8] + w;
                        double[] dArray9 = counts[k][j][l][seq.discreteVal(k)][seq.discreteVal(j)];
                        int n9 = seq.discreteVal(l);
                        dArray9[n9] = dArray9[n9] + w;
                        double[] dArray10 = counts[l][j][k][seq.discreteVal(l)][seq.discreteVal(j)];
                        int n10 = seq.discreteVal(k);
                        dArray10[n10] = dArray10[n10] + w;
                        double[] dArray11 = counts[j][l][k][seq.discreteVal(j)][seq.discreteVal(l)];
                        int n11 = seq.discreteVal(k);
                        dArray11[n11] = dArray11[n11] + w;
                        double[] dArray12 = counts[l][k][j][seq.discreteVal(l)][seq.discreteVal(k)];
                        int n12 = seq.discreteVal(j);
                        dArray12[n12] = dArray12[n12] + w;
                        double[] dArray13 = counts[k][l][j][seq.discreteVal(k)][seq.discreteVal(l)];
                        int n13 = seq.discreteVal(j);
                        dArray13[n13] = dArray13[n13] + w;
                    }
                }
            }
        }
        return counts;
    }

    protected static double[][][][] getStatistics(DataSet s, double[] weights, int length, double ess) throws Exception {
        int i;
        if (s.getElementLength() != length) {
            throw new Exception("Lengths do not match.");
        }
        AlphabetContainer alph = s.getAlphabetContainer();
        double currEss = 0.0;
        double[][][][] counts = new double[length][length][][];
        for (i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[i].length; ++j) {
                counts[i][j] = new double[(int)alph.getAlphabetLengthAt(i)][(int)alph.getAlphabetLengthAt(j)];
                currEss = i == j ? ess / alph.getAlphabetLengthAt(i) : ess / (alph.getAlphabetLengthAt(i) * alph.getAlphabetLengthAt(j));
                for (int k = 0; k < counts[i][j].length; ++k) {
                    Arrays.fill(counts[i][j][k], currEss);
                }
            }
        }
        for (i = 0; i < s.getNumberOfElements(); ++i) {
            Sequence seq = s.getElementAt(i);
            double w = weights[i];
            for (int j = 0; j < seq.getLength(); ++j) {
                double[] dArray = counts[j][j][seq.discreteVal(j)];
                int n = seq.discreteVal(j);
                dArray[n] = dArray[n] + w;
                for (int k = j + 1; k < seq.getLength(); ++k) {
                    double[] dArray2 = counts[j][k][seq.discreteVal(j)];
                    int n2 = seq.discreteVal(k);
                    dArray2[n2] = dArray2[n2] + w;
                    double[] dArray3 = counts[k][j][seq.discreteVal(k)];
                    int n3 = seq.discreteVal(j);
                    dArray3[n3] = dArray3[n3] + w;
                }
            }
        }
        return counts;
    }

    protected static double[][] getMI(double[][][][] counts, double n) {
        double[][] mi = new double[counts.length][counts.length];
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[i].length; ++j) {
                int a;
                if (i != j) {
                    for (a = 0; a < counts[i][j].length; ++a) {
                        for (int b = 0; b < counts[i][j][a].length; ++b) {
                            if (!(counts[i][j][a][b] > 0.0)) continue;
                            double[] dArray = mi[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + counts[i][j][a][b] / n * Math.log(n * counts[i][j][a][b] / (counts[i][i][a][a] * counts[j][j][b][b]));
                        }
                    }
                    continue;
                }
                for (a = 0; a < counts[i][i].length; ++a) {
                    if (!(counts[i][i][a][a] > 0.0)) continue;
                    double[] dArray = mi[i];
                    int n3 = i;
                    dArray[n3] = dArray[n3] - counts[i][i][a][a] / n * Math.log(counts[i][i][a][a] / n);
                }
            }
        }
        return mi;
    }

    protected static double[][] getCMI(double[][][][] fgStats, double[][][][] bgStats, double n, double nFg, double nBg) {
        double[][] cmi = new double[fgStats.length][fgStats.length];
        for (int i = 0; i < fgStats.length; ++i) {
            for (int j = 0; j < fgStats[i].length; ++j) {
                int a;
                if (i != j) {
                    for (a = 0; a < fgStats[i][j].length; ++a) {
                        for (int b = 0; b < fgStats[i][j][a].length; ++b) {
                            double[] dArray = cmi[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + fgStats[i][j][a][b] / n * Math.log(fgStats[i][j][a][b] * (fgStats[j][j][b][b] + bgStats[j][j][b][b]) / ((fgStats[i][j][a][b] + bgStats[i][j][a][b]) * fgStats[j][j][b][b]));
                            double[] dArray2 = cmi[i];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + bgStats[i][j][a][b] / n * Math.log(bgStats[i][j][a][b] * (fgStats[j][j][b][b] + bgStats[j][j][b][b]) / ((fgStats[i][j][a][b] + bgStats[i][j][a][b]) * bgStats[j][j][b][b]));
                        }
                    }
                    continue;
                }
                for (a = 0; a < fgStats[i][i].length; ++a) {
                    double[] dArray = cmi[i];
                    int n4 = i;
                    dArray[n4] = dArray[n4] + fgStats[i][i][a][a] / n * Math.log(fgStats[i][i][a][a] * n / ((fgStats[i][i][a][a] + bgStats[i][i][a][a]) * nFg));
                    double[] dArray3 = cmi[i];
                    int n5 = i;
                    dArray3[n5] = dArray3[n5] + bgStats[i][i][a][a] / n * Math.log(bgStats[i][i][a][a] * n / ((fgStats[i][i][a][a] + bgStats[i][i][a][a]) * nBg));
                }
            }
        }
        return cmi;
    }

    protected static double[][] getEAR(double[][][][] fgStats, double[][][][] bgStats, double nFg, double nBg) {
        double pcFg = nFg / (nFg + nBg);
        double pcBg = nBg / (nFg + nBg);
        double[][] ear = new double[fgStats.length][fgStats.length];
        for (int i = 0; i < fgStats.length; ++i) {
            for (int j = 0; j < fgStats[i].length; ++j) {
                if (i != j) {
                    for (int a = 0; a < fgStats[i][j].length; ++a) {
                        for (int b = 0; b < fgStats[i][j][a].length; ++b) {
                            double[] dArray = ear[i];
                            int n = j;
                            dArray[n] = dArray[n] + pcFg * (fgStats[i][j][a][b] / nFg * Math.log(nFg * fgStats[i][j][a][b] / (fgStats[i][i][a][a] * fgStats[j][j][b][b])));
                            double[] dArray2 = ear[i];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + pcBg * (bgStats[i][j][a][b] / nBg * Math.log(nBg * bgStats[i][j][a][b] / (bgStats[i][i][a][a] * bgStats[j][j][b][b])));
                            double[] dArray3 = ear[i];
                            int n3 = j;
                            dArray3[n3] = dArray3[n3] - (fgStats[i][j][a][b] + bgStats[i][j][a][b]) / (nFg + nBg) * Math.log((nFg + nBg) * (fgStats[i][j][a][b] + bgStats[i][j][a][b]) / ((fgStats[i][i][a][a] + bgStats[i][i][a][a]) * (fgStats[j][j][b][b] + bgStats[j][j][b][b])));
                        }
                    }
                    continue;
                }
                ear[i][i] = 0.0;
            }
        }
        return ear;
    }

    protected static double sum(double[] ar) {
        double sum = 0.0;
        for (int i = 0; i < ar.length; ++i) {
            sum += ar[i];
        }
        return sum;
    }

    protected static double[] union(double[][] ar) {
        int num = 0;
        for (int i = 0; i < ar.length; ++i) {
            num += ar[i].length;
        }
        double[] un = new double[num];
        num = 0;
        for (int i = 0; i < ar.length; ++i) {
            System.arraycopy(ar[i], 0, un, num, ar[i].length);
            num += ar[i].length;
        }
        return un;
    }

    public boolean isShiftable() {
        return false;
    }

    public static abstract class MeasureParameterSet
    extends InstanceParameterSet<Measure> {
        protected MeasureParameterSet(Class<? extends Measure> clazz) {
            super(clazz);
        }

        protected MeasureParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }
    }
}

