/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DiscreteAlphabetMapping;
import de.jstacs.data.sequences.MappedDiscreteSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public final class MappingDiffSM
extends AbstractDifferentiableStatisticalModel
implements MutableMotifDiscoverer,
Mutable {
    private DifferentiableStatisticalModel nsf;
    private MutableMappedDiscreteSequence mappedSeq;
    private static final String XML_TAG = "MappingDiffSM";

    public MappingDiffSM(AlphabetContainer originalAlphabetContainer, DifferentiableStatisticalModel nsf, DiscreteAlphabetMapping ... mapping) throws WrongAlphabetException, CloneNotSupportedException {
        super(originalAlphabetContainer, nsf.getLength());
        this.nsf = (DifferentiableStatisticalModel)nsf.clone();
        this.mappedSeq = new MutableMappedDiscreteSequence(originalAlphabetContainer, mapping);
    }

    public MappingDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public MappingDiffSM clone() throws CloneNotSupportedException {
        MappingDiffSM clone = (MappingDiffSM)super.clone();
        clone.nsf = (DifferentiableStatisticalModel)this.nsf.clone();
        try {
            clone.mappedSeq = new MutableMappedDiscreteSequence(this.alphabets, this.mappedSeq.getTransformations());
            clone.mappedSeq.setSequence(this.mappedSeq.getOriginalSequence());
        }
        catch (WrongAlphabetException wae) {
            throw new CloneNotSupportedException(wae.getMessage());
        }
        return clone;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.nsf, "nsf");
        XMLParser.appendObjectWithTags(xml, this.mappedSeq.getTransformations(), "transformations");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.nsf = (DifferentiableStatisticalModel)XMLParser.extractObjectForTags(xml, "nsf");
        this.length = this.nsf.getLength();
        try {
            this.mappedSeq = new MutableMappedDiscreteSequence(this.alphabets, XMLParser.extractObjectForTags(xml, "transformations", DiscreteAlphabetMapping[].class));
        }
        catch (WrongAlphabetException e) {
            throw new NonParsableException();
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        this.nsf.addGradientOfLogPriorTerm(grad, start);
    }

    @Override
    public double getESS() {
        return this.nsf.getESS();
    }

    @Override
    public double getLogNormalizationConstant() {
        return this.nsf.getLogNormalizationConstant();
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return this.nsf.getLogPartialNormalizationConstant(parameterIndex);
    }

    @Override
    public double getLogPriorTerm() {
        return this.nsf.getLogPriorTerm();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return this.nsf.getSizeOfEventSpaceForRandomVariablesOfParameter(index);
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return this.nsf.getCurrentParameterValues();
    }

    @Override
    public String getInstanceName() {
        return "MappingDiffSM for " + this.nsf.getInstanceName();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        this.mappedSeq.setSequence(seq);
        return this.nsf.getLogScoreFor(this.mappedSeq, start) - this.mappedSeq.getLogNumberOfPossibleOriginalSequences(start, this.length == 0 ? seq.getLength() : start + this.length);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        this.mappedSeq.setSequence(seq);
        return this.nsf.getLogScoreAndPartialDerivation(this.mappedSeq, start, indices, partialDer) - this.mappedSeq.getLogNumberOfPossibleOriginalSequences(start, this.length == 0 ? seq.getLength() : start + this.length);
    }

    @Override
    public int getNumberOfParameters() {
        return this.nsf.getNumberOfParameters();
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        DataSet[] mappedData = this.getMappedData(data);
        this.nsf.initializeFunction(index, freeParams, mappedData, weights);
        for (int i = 0; i < data.length; ++i) {
            mappedData[i] = null;
        }
        mappedData = null;
        System.gc();
    }

    private DataSet[] getMappedData(DataSet ... data) throws WrongAlphabetException, EmptyDataSetException {
        DataSet[] mappedData = new DataSet[data.length];
        DiscreteAlphabetMapping[] transformation = this.mappedSeq.getTransformations();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            Sequence[] seqs = new Sequence[data[i].getNumberOfElements()];
            for (int n = 0; n < seqs.length; ++n) {
                seqs[n] = new MappedDiscreteSequence((SimpleDiscreteSequence)data[i].getElementAt(n), transformation);
            }
            mappedData[i] = new DataSet("mapped: " + data[i].getAnnotation(), seqs);
        }
        return mappedData;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.nsf.initializeFunctionRandomly(freeParams);
    }

    @Override
    public boolean isInitialized() {
        return this.nsf.isInitialized();
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.nsf.setParameters(params, start);
    }

    @Override
    public String toString(NumberFormat nf) {
        return this.getInstanceName() + "\n" + this.nsf.toString(nf);
    }

    public DifferentiableStatisticalModel getFunction() throws CloneNotSupportedException {
        return (DifferentiableStatisticalModel)this.nsf.clone();
    }

    @Override
    public int getNumberOfMotifs() {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfMotifs();
        }
        return 0;
    }

    @Override
    public void adjustHiddenParameters(int index, DataSet[] data, double[][] weights) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            DataSet[] mappedData = this.getMappedData(data);
            ((MutableMotifDiscoverer)((Object)this.nsf)).adjustHiddenParameters(index, mappedData, weights);
            for (int i = 0; i < data.length; ++i) {
                mappedData[i] = null;
            }
            mappedData = null;
            System.gc();
        }
    }

    @Override
    public void initializeMotif(int motifIndex, DataSet data, double[] weights) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            DataSet[] mappedData = this.getMappedData(data);
            ((MutableMotifDiscoverer)((Object)this.nsf)).initializeMotif(motifIndex, mappedData[0], weights);
            mappedData[0] = null;
            mappedData = null;
            System.gc();
        }
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            ((MutableMotifDiscoverer)((Object)this.nsf)).initializeMotifRandomly(motif);
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        if (this.nsf instanceof MutableMotifDiscoverer) {
            return ((MutableMotifDiscoverer)((Object)this.nsf)).modifyMotif(motifIndex, offsetLeft, offsetRight);
        }
        return false;
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getGlobalIndexOfMotifInComponent(component, motif);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            return ((MotifDiscoverer)((Object)this.nsf)).getIndexOfMaximalComponentFor(this.mappedSeq);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getMotifLength(int motif) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getMotifLength(motif);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getNumberOfComponents() {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfComponents();
        }
        return 1;
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        if (this.nsf instanceof MotifDiscoverer) {
            return ((MotifDiscoverer)((Object)this.nsf)).getNumberOfMotifsInComponent(component);
        }
        if (component > 0) {
            throw new IllegalArgumentException();
        }
        return 1;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            double[] res = ((MotifDiscoverer)((Object)this.nsf)).getProfileOfScoresFor(component, motif, this.mappedSeq, startpos, kind);
            double norm = this.mappedSeq.getLogNumberOfPossibleOriginalSequences(startpos, this.length == 0 ? sequence.getLength() : startpos + this.length);
            int i = 0;
            while (i < res.length) {
                int n = i++;
                res[n] = res[n] - norm;
            }
            return res;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (this.nsf instanceof MotifDiscoverer) {
            this.mappedSeq.setSequence(sequence);
            return ((MotifDiscoverer)((Object)this.nsf)).getStrandProbabilitiesFor(component, motif, this.mappedSeq, startpos);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (this.nsf instanceof Mutable) {
            return ((Mutable)((Object)this.nsf)).modify(offsetLeft, offsetRight);
        }
        return false;
    }

    private static final class MutableMappedDiscreteSequence
    extends MappedDiscreteSequence {
        private MutableMappedDiscreteSequence(AlphabetContainer originalAlphabetContainer, DiscreteAlphabetMapping[] transformation) throws WrongAlphabetException {
            super(originalAlphabetContainer, null, transformation);
        }

        private void setSequence(Sequence original) throws IllegalArgumentException {
            if (original == null || !(original instanceof SimpleDiscreteSequence) || !this.originalAlphabetContainer.checkConsistency(original.getAlphabetContainer())) {
                throw new IllegalArgumentException();
            }
            this.original = (SimpleDiscreteSequence)original;
        }

        private DiscreteAlphabetMapping[] getTransformations() {
            return (DiscreteAlphabetMapping[])this.transformation.clone();
        }

        private SimpleDiscreteSequence getOriginalSequence() {
            return this.original;
        }
    }
}

