/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class ArrayParameterSet
extends ExpandableParameterSet {
    private int numberChanged;
    private String lengthName;
    private String lengthComment;
    private NumberValidator<Integer> allowedLengths;

    public ArrayParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, String lengthName, String lengthComment, NumberValidator<Integer> allowedLengths) throws CloneNotSupportedException, SimpleParameter.IllegalValueException {
        super(template, nameTemplate, commentTemplate);
        SimpleParameter length;
        this.lengthName = lengthName;
        this.lengthComment = lengthComment;
        this.allowedLengths = allowedLengths;
        try {
            length = new SimpleParameter(DataType.INT, lengthName, lengthComment, true, allowedLengths);
        }
        catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
        length.setDefault(allowedLengths.getLowerBound());
        length.setValue(allowedLengths.getLowerBound());
        length.setRangeable(false);
        this.parameters.add(0, (Parameter)length);
        for (int i = 1; i < (Integer)length.getValue(); ++i) {
            this.addParameterToSet();
        }
        this.numberChanged = 1;
    }

    public ArrayParameterSet(ParameterSet template, String nameTemplate, String commentTemplate) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        this(template, nameTemplate, commentTemplate, "Length", "The length of the array.", new NumberValidator<Integer>(1, Integer.MAX_VALUE));
    }

    public ArrayParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public void setLength(int length) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        block3: {
            int numBefore;
            block2: {
                ((Parameter)this.parameters.get(0)).setValue(length);
                numBefore = this.parameters.size() - 1;
                if (numBefore >= length) break block2;
                for (int i = numBefore; i < length; ++i) {
                    this.addParameterToSet();
                }
                break block3;
            }
            if (numBefore <= length) break block3;
            for (int i = numBefore; i > length; --i) {
                this.removeParameterFromSet();
            }
        }
    }

    @Override
    public int getNumberOfParameters() {
        return super.getNumberOfParameters();
    }

    @Override
    public Parameter getParameterAt(int i) {
        return super.getParameterAt(i);
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.numberChanged != 0) {
            return false;
        }
        return super.hasDefaultOrIsSet();
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "arrayParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superRepresentation"));
        this.lengthName = XMLParser.extractObjectForTags(representation, "lengthName", String.class);
        this.lengthComment = XMLParser.extractObjectForTags(representation, "lengthComment", String.class);
        this.allowedLengths = XMLParser.extractObjectForTags(representation, "allowedLengths", NumberValidator.class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer supBuf = super.toXML();
        XMLParser.addTags(supBuf, "superRepresentation");
        XMLParser.appendObjectWithTags(supBuf, this.lengthName, "lengthName");
        XMLParser.appendObjectWithTags(supBuf, this.lengthComment, "lengthComment");
        XMLParser.appendObjectWithTags(supBuf, this.allowedLengths, "allowedLengths");
        XMLParser.addTags(supBuf, "arrayParameterSet");
        return supBuf;
    }
}

