/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.AbstractTwoClassPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;
import java.util.ArrayList;

public class ROCCurve
extends AbstractTwoClassPerformanceMeasure {
    public static final String NAME = "Receiver Operating Characteristic curve";

    public ROCCurve() {
    }

    public ROCCurve(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        boolean unique;
        ArrayList<double[]> list = null;
        if (!(this instanceof NumericalPerformanceMeasure)) {
            list = new ArrayList<double[]>();
        }
        int i = 0;
        int j = 0;
        int d = sortedScoresClass1.length;
        int m = sortedScoresClass0.length;
        double fn = 0.0;
        double tn = 0.0;
        double pos = weightsClass0 == null ? (double)m : ToolBox.sum(0, m, weightsClass0);
        double neg = weightsClass1 == null ? (double)d : ToolBox.sum(0, d, weightsClass1);
        double erg = 0.0;
        double[] p = new double[]{1.0, 1.0};
        if (list != null) {
            list.add((double[])p.clone());
        }
        boolean fromMotif = false;
        if (sortedScoresClass0[i] == sortedScoresClass1[j]) {
            unique = false;
        } else {
            unique = true;
            fromMotif = sortedScoresClass0[i] < sortedScoresClass1[j];
        }
        while (i < m && j < d) {
            if (unique) {
                if (fromMotif) {
                    while (i < m && sortedScoresClass0[i] < sortedScoresClass1[j]) {
                        fn += ROCCurve.getWeight(weightsClass0, i);
                        ++i;
                    }
                } else {
                    while (j < d && sortedScoresClass0[i] > sortedScoresClass1[j]) {
                        tn += ROCCurve.getWeight(weightsClass1, j);
                        ++j;
                    }
                }
            } else {
                while (i + 1 < m && sortedScoresClass0[i] == sortedScoresClass0[i + 1]) {
                    fn += ROCCurve.getWeight(weightsClass0, i);
                    ++i;
                }
                while (j + 1 < d && sortedScoresClass1[j] == sortedScoresClass1[j + 1]) {
                    tn += ROCCurve.getWeight(weightsClass1, j);
                    ++j;
                }
                fn += ROCCurve.getWeight(weightsClass0, i);
                tn += ROCCurve.getWeight(weightsClass1, j);
                ++i;
                ++j;
            }
            double help1 = (neg - tn) / neg;
            double help2 = (pos - fn) / pos;
            erg += (p[1] + help2) / 2.0 * (p[0] - help1);
            p[0] = help1;
            p[1] = help2;
            if (list != null) {
                list.add((double[])p.clone());
            }
            if (i >= m || j >= d) continue;
            if (sortedScoresClass0[i] == sortedScoresClass1[j]) {
                unique = false;
                continue;
            }
            unique = true;
            if (sortedScoresClass0[i] < sortedScoresClass1[j]) {
                fromMotif = true;
                continue;
            }
            fromMotif = false;
        }
        if (list != null) {
            list.add(new double[]{0.0, 0.0});
        }
        NumericalResult auc = new NumericalResult("AUC-ROC", this.getName(), erg);
        if (list == null) {
            return new NumericalResultSet(auc);
        }
        return new ResultSet(new Result[][]{{auc, new AbstractScoreBasedClassifier.DoubleTableResult(this.getName(), this.getName(), list)}});
    }
}

