/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;

public class ConfusionMatrix
extends AbstractPerformanceMeasure {
    public ConfusionMatrix() {
    }

    public ConfusionMatrix(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] weightClass0, double[] sortedScoresClass1, double[] weightClass1) {
        int i;
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        double tn = 0.0;
        double w = 1.0;
        for (i = 0; i < sortedScoresClass0.length; ++i) {
            if (weightClass0 != null) {
                w = weightClass0[i];
            }
            if (sortedScoresClass0[i] >= 0.0) {
                tp += w;
                continue;
            }
            fn += w;
        }
        w = 1.0;
        for (i = 0; i < sortedScoresClass1.length; ++i) {
            if (weightClass1 != null) {
                w = weightClass1[i];
            }
            if (sortedScoresClass0[i] >= 0.0) {
                fp += w;
                continue;
            }
            tn += w;
        }
        return new ResultSet(new ListResult(this.getName(), this.getName() + " for two classes.", null, new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("TP", "true positives", tp), new NumericalResult("FN", "false negatives", fn)}}), new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("FP", "false positives", fp), new NumericalResult("TN", "true negatives", tn)}})));
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores, double[][] weights) {
        double[][] res = new double[classSpecificScores.length][classSpecificScores.length];
        for (int i = 0; i < classSpecificScores.length; ++i) {
            double w = 1.0;
            for (int j = 0; j < classSpecificScores[i].length; ++j) {
                if (weights != null && weights[i] != null) {
                    w = weights[i][j];
                }
                int predicted = ToolBox.getMaxIndex(classSpecificScores[i][j]);
                double[] dArray = res[i];
                int n = predicted;
                dArray[n] = dArray[n] + w;
            }
        }
        ResultSet[] sets = new NumericalResultSet[classSpecificScores.length];
        for (int i = 0; i < res.length; ++i) {
            NumericalResult[] temp = new NumericalResult[res[i].length];
            for (int j = 0; j < res[i].length; ++j) {
                temp[j] = new NumericalResult(i + "/" + j, "correct class: " + i + ", predicted class: " + j, res[i][j]);
            }
            sets[i] = new NumericalResultSet(new NumericalResult[][]{temp});
        }
        return new ResultSet(new ListResult(this.getName(), this.getName() + " for " + classSpecificScores.length + " classes", null, sets));
    }

    @Override
    public int getAllowedNumberOfClasses() {
        return 0;
    }

    @Override
    public String getName() {
        return "Confusion matrix";
    }
}

