/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.Function;
import de.jstacs.algorithms.optimization.OneDimensionalFunction;

public class OneDimensionalSubFunction
extends OneDimensionalFunction {
    private double[] d;
    private double[] current;
    private Function f;

    public OneDimensionalSubFunction(Function f) {
        this.f = f;
        this.d = null;
        this.current = null;
    }

    @Override
    public double evaluateFunction(double x) throws EvaluationException {
        double[] p = new double[this.d.length];
        for (int counter = 0; counter < p.length; ++counter) {
            p[counter] = this.current[counter] + x * this.d[counter];
        }
        try {
            return this.f.evaluateFunction(p);
        }
        catch (DimensionException impossible) {
            EvaluationException ee = new EvaluationException(impossible.getMessage());
            ee.setStackTrace(impossible.getStackTrace());
            throw ee;
        }
    }

    public void set(double[] current, double[] d) throws DimensionException {
        int n = this.f.getDimensionOfScope();
        if (n != d.length && n != current.length) {
            throw new DimensionException();
        }
        if (this.d == null) {
            this.d = (double[])d.clone();
            this.current = (double[])current.clone();
        } else {
            System.arraycopy(current, 0, this.current, 0, this.current.length);
            System.arraycopy(d, 0, this.d, 0, this.d.length);
        }
    }
}

