/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.ZoomDataRecord;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class ZoomDataBlock {
    private static Logger log = Logger.getLogger(ZoomDataBlock.class);
    private long fileOffset;
    private long dataBlockSize;
    private boolean isLowToHigh;
    private int zoomLevel;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] zoomBuffer;
    private int remDataSize;
    private LittleEndianInputStream lbdis = null;
    private DataInputStream dis = null;
    private ArrayList<ZoomDataRecord> zoomDataList;

    public ZoomDataBlock(int n, SeekableStream seekableStream, RPTreeLeafNodeItem rPTreeLeafNodeItem, HashMap<Integer, String> hashMap, boolean bl, int n2) {
        this.zoomLevel = n;
        this.leafHitItem = rPTreeLeafNodeItem;
        this.chromosomeMap = hashMap;
        this.isLowToHigh = bl;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] byArray = new byte[(int)this.dataBlockSize];
        try {
            seekableStream.seek(this.fileOffset);
            seekableStream.readFully(byArray);
            this.zoomBuffer = n2 > 0 ? BBCompressionUtils.decompress(byArray, n2) : byArray;
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading Zoom level " + this.zoomLevel + " data for leaf item "), (Throwable)iOException);
            String string = String.format("Error reading zoom level %d data for leaf item %d\n", this.zoomLevel);
            throw new RuntimeException(string, iOException);
        }
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(this.zoomBuffer));
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(this.zoomBuffer));
        }
        this.remDataSize = this.zoomBuffer.length;
    }

    public ArrayList<ZoomDataRecord> getZoomData(RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        block8: {
            int n = 0;
            this.zoomDataList = new ArrayList();
            RPChromosomeRegion rPChromosomeRegion2 = new RPChromosomeRegion(this.leafHitItem.getChromosomeBounds());
            int n2 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
            try {
                int n3 = 0;
                while (this.remDataSize > 0) {
                    ZoomDataRecord zoomDataRecord;
                    String string;
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    n = n3 + 1;
                    if (this.isLowToHigh) {
                        n7 = this.lbdis.readInt();
                        n6 = this.lbdis.readInt();
                        n5 = this.lbdis.readInt();
                        n4 = this.lbdis.readInt();
                        f4 = this.lbdis.readFloat();
                        f3 = this.lbdis.readFloat();
                        f2 = this.lbdis.readFloat();
                        f = this.lbdis.readFloat();
                    } else {
                        n7 = this.dis.readInt();
                        n6 = this.dis.readInt();
                        n5 = this.dis.readInt();
                        n4 = this.dis.readInt();
                        f4 = this.dis.readFloat();
                        f3 = this.dis.readFloat();
                        f2 = this.dis.readFloat();
                        f = this.dis.readFloat();
                    }
                    if (n2 == 0) {
                        string = this.chromosomeMap.get(n7);
                        zoomDataRecord = new ZoomDataRecord(this.zoomLevel, n, string, n7, n6, n5, n4, f4, f3, f2, f);
                        this.zoomDataList.add(zoomDataRecord);
                    } else {
                        rPChromosomeRegion2 = new RPChromosomeRegion(n7, n6, n7, n5);
                        int n8 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
                        if (!bl && Math.abs(n8) < 2 || n8 == 0) {
                            string = this.chromosomeMap.get(n7);
                            zoomDataRecord = new ZoomDataRecord(this.zoomLevel, n, string, n7, n6, n5, n4, f4, f3, f2, f);
                            this.zoomDataList.add(zoomDataRecord);
                        }
                    }
                    this.remDataSize -= 32;
                    ++n3;
                }
            }
            catch (IOException iOException) {
                log.error((Object)("Read error for zoom level " + this.zoomLevel + " leaf item "));
                if (n != 1) break block8;
                throw new RuntimeException("Read error for zoom level " + this.zoomLevel + " leaf item ");
            }
        }
        return this.zoomDataList;
    }

    public void print() {
        log.debug((Object)("Zoom Level " + this.zoomLevel + "data for leaf item :"));
        for (int i = 0; i <= this.zoomDataList.size(); ++i) {
            this.zoomDataList.get(i).print();
        }
    }
}

