/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BigWigSectionHeader;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.WigItem;
import org.broad.tribble.util.LittleEndianInputStream;

public class BigWigSection {
    private static Logger log = Logger.getLogger(BigWigSection.class);
    private boolean isLowToHigh;
    private LittleEndianInputStream lbdis;
    private DataInputStream dis;
    private RPTreeLeafNodeItem leafHitItem;
    private int sectionDataSize;
    private HashMap<Integer, String> chromosomeMap;
    private BigWigSectionHeader wigSectionHeader;

    public BigWigSection(byte[] byArray, HashMap<Integer, String> hashMap, boolean bl, RPTreeLeafNodeItem rPTreeLeafNodeItem) {
        this.chromosomeMap = hashMap;
        this.isLowToHigh = bl;
        this.leafHitItem = rPTreeLeafNodeItem;
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            this.wigSectionHeader = new BigWigSectionHeader(this.lbdis);
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(byArray));
            this.wigSectionHeader = new BigWigSectionHeader(this.dis);
        }
        if (this.wigSectionHeader.getItemType() == BigWigSectionHeader.WigItemType.Unknown) {
            throw new RuntimeException("Read error on wig section leaf index ");
        }
        this.sectionDataSize = 24;
    }

    public boolean isValidSectionType() {
        return this.wigSectionHeader.IsValidType();
    }

    public int getItemCount() {
        return this.wigSectionHeader.getItemCount();
    }

    public BigWigSectionHeader getSectionHeader() {
        return this.wigSectionHeader;
    }

    public int getSectionDataSize() {
        return this.sectionDataSize;
    }

    public int getSectionData(RPChromosomeRegion rPChromosomeRegion, boolean bl, ArrayList<WigItem> arrayList) {
        int n = this.wigSectionHeader.getChromID();
        String string = this.chromosomeMap.get(n);
        int n2 = this.wigSectionHeader.getItemCount();
        int n3 = this.wigSectionHeader.getChromosomeStart();
        int n4 = this.wigSectionHeader.getChromosomeEnd();
        int n5 = this.wigSectionHeader.getItemStep();
        int n6 = this.wigSectionHeader.getItemSpan();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        float f = 0.0f;
        BigWigSectionHeader.WigItemType wigItemType = this.wigSectionHeader.getItemType();
        RPChromosomeRegion rPChromosomeRegion2 = new RPChromosomeRegion(n, n3, n, n4);
        int n10 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
        try {
            for (int i = 0; i < n2; ++i) {
                ++n7;
                if (this.isLowToHigh) {
                    if (wigItemType == BigWigSectionHeader.WigItemType.FixedStep) {
                        n8 = n3;
                        n9 = n8 + n6;
                        f = this.lbdis.readFloat();
                        n3 = n8 + n5;
                        this.sectionDataSize += 4;
                    } else if (wigItemType == BigWigSectionHeader.WigItemType.VarStep) {
                        n8 = this.lbdis.readInt();
                        n9 = n8 + n6;
                        f = this.lbdis.readFloat();
                        this.sectionDataSize += 8;
                    } else if (wigItemType == BigWigSectionHeader.WigItemType.BedGraph) {
                        n8 = this.lbdis.readInt();
                        n9 = this.lbdis.readInt();
                        f = this.lbdis.readFloat();
                        this.sectionDataSize += 12;
                    }
                } else if (wigItemType == BigWigSectionHeader.WigItemType.FixedStep) {
                    n8 = n3;
                    n9 = n8 + n6;
                    f = this.dis.readFloat();
                    n3 = n8 + n5;
                    this.sectionDataSize += 4;
                } else if (wigItemType == BigWigSectionHeader.WigItemType.VarStep) {
                    n8 = this.dis.readInt();
                    n9 = n8 + n6;
                    f = this.dis.readFloat();
                    this.sectionDataSize += 8;
                } else if (wigItemType == BigWigSectionHeader.WigItemType.BedGraph) {
                    n8 = this.dis.readInt();
                    n9 = this.dis.readInt();
                    f = this.dis.readFloat();
                    this.sectionDataSize += 12;
                }
                if (n10 == 0) {
                    WigItem wigItem = new WigItem(n7, string, n8, n9, f);
                    arrayList.add(wigItem);
                    continue;
                }
                rPChromosomeRegion2 = new RPChromosomeRegion(n, n8, n, n9);
                int n11 = rPChromosomeRegion2.compareRegions(rPChromosomeRegion);
                if (n11 != 0 && (bl || Math.abs(n11) >= 2)) continue;
                WigItem wigItem = new WigItem(n7, string, n8, n9, f);
                arrayList.add(wigItem);
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Read error for Wig section item " + n7));
            throw new RuntimeException("Read error for Wig section item " + n7);
        }
        return this.sectionDataSize;
    }

    public void print() {
        log.debug((Object)("Wig section for leaf item  has a data size = " + this.sectionDataSize));
        this.wigSectionHeader.print();
    }
}

