/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeLeafNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeLeafNode
implements BPTreeNode {
    private static Logger log = Logger.getLogger(BPTreeLeafNode.class);
    private final boolean isLeafNode = true;
    private long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private ArrayList<BPTreeLeafNodeItem> leafItems;

    public BPTreeLeafNode(long l) {
        this.nodeIndex = l;
        this.leafItems = new ArrayList();
    }

    @Override
    public long getNodeIndex() {
        return this.nodeIndex;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem bPTreeNodeItem) {
        this.leafItems.add((BPTreeLeafNodeItem)bPTreeNodeItem);
        if (this.leafItems.size() == 1) {
            this.lowestChromKey = bPTreeNodeItem.getChromKey();
            this.lowestChromID = ((BPTreeLeafNodeItem)bPTreeNodeItem).getChromID();
        } else {
            this.highestChromKey = bPTreeNodeItem.getChromKey();
            this.highestChromID = ((BPTreeLeafNodeItem)bPTreeNodeItem).getChromID();
        }
        return true;
    }

    @Override
    public boolean deleteItem(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            return false;
        }
        this.leafItems.remove(n);
        return true;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public BPTreeNodeItem getItem(int n) {
        if (this.getItemCount() > 0 && n < this.getItemCount()) {
            return this.leafItems.get(n);
        }
        return null;
    }

    @Override
    public String getLowestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.leafItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int n = this.getItemCount();
        log.debug((Object)("Leaf node " + this.nodeIndex + "contains " + n + " leaf items:"));
        for (int i = 0; i < n; ++i) {
            this.leafItems.get(i).print();
        }
    }

    public ArrayList<BPTreeLeafNodeItem> getLeafItems() {
        return this.leafItems;
    }
}

