/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BPTreeHeader {
    private static Logger log = Logger.getLogger(BPTreeHeader.class);
    public static final int BPTREE_HEADER_SIZE = 32;
    public static final int BPTREE_MAGIC_LTH = 2026540177;
    public static final int BPTREE_MAGIC_HTL = -1853044104;
    private long headerOffset;
    private boolean headerOK;
    private int magic;
    private int blockSize;
    private int keySize;
    private int valSize;
    private long itemCount;
    private long reserved;

    public BPTreeHeader(SeekableStream seekableStream, long l, boolean bl) {
        this.headerOffset = l;
        this.headerOK = this.readHeader(seekableStream, this.headerOffset, bl);
    }

    public static int getHeaderSize() {
        return 32;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public boolean isHeaderOK() {
        return this.headerOK;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValSize() {
        return this.valSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void print() {
        if (this.headerOK) {
            log.debug((Object)("B+ Tree Header was read from file location " + this.headerOffset));
        }
        log.debug((Object)(" Magic ID =" + this.magic));
        log.debug((Object)(" Block size = " + this.blockSize));
        log.debug((Object)(" Key size = " + this.keySize));
        log.debug((Object)(" Indexed value size = " + this.valSize));
        log.debug((Object)(" Item Count = " + this.itemCount));
        log.debug((Object)(" Reserved = " + this.reserved));
    }

    private boolean readHeader(SeekableStream seekableStream, long l, boolean bl) {
        byte[] byArray = new byte[32];
        try {
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (bl) {
                LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
                this.magic = littleEndianInputStream.readInt();
                if (this.magic != 2026540177) {
                    return false;
                }
                this.blockSize = littleEndianInputStream.readInt();
                this.keySize = littleEndianInputStream.readInt();
                this.valSize = littleEndianInputStream.readInt();
                this.itemCount = littleEndianInputStream.readLong();
                this.reserved = littleEndianInputStream.readLong();
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.magic = dataInputStream.readInt();
                if (this.magic != -1853044104) {
                    return false;
                }
                this.blockSize = dataInputStream.readInt();
                this.keySize = dataInputStream.readInt();
                this.valSize = dataInputStream.readInt();
                this.itemCount = dataInputStream.readLong();
                this.reserved = dataInputStream.readLong();
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Error reading B+ tree header " + iOException));
            throw new RuntimeException("Error reading B+ tree header \n", iOException);
        }
        return true;
    }
}

