/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeChildNodeItem
implements BPTreeNodeItem {
    private static Logger log = Logger.getLogger(BPTreeChildNodeItem.class);
    private final boolean isLeafItem = false;
    private long itemIndex;
    private String chromKey;
    private BPTreeNode childNode;

    public BPTreeChildNodeItem(int n, String string, BPTreeNode bPTreeNode) {
        this.itemIndex = n;
        this.chromKey = string;
        this.childNode = bPTreeNode;
    }

    @Override
    public long getItemIndex() {
        return this.itemIndex;
    }

    @Override
    public boolean isLeafItem() {
        return false;
    }

    @Override
    public String getChromKey() {
        return this.chromKey;
    }

    @Override
    public boolean chromKeysMatch(String string) {
        int n;
        String string2 = this.chromKey;
        String string3 = string;
        int n2 = string2.length();
        if (n2 > (n = string3.length())) {
            string2 = string2.substring(0, n);
        } else if (n > n2) {
            string3 = string3.substring(0, n2);
        }
        return string2.compareTo(string3) == 0;
    }

    @Override
    public void print() {
        log.debug((Object)("B+ Tree child node " + this.itemIndex));
        log.debug((Object)("Key value = " + this.chromKey));
        this.childNode.printItems();
    }

    public BPTreeNode getChildNode() {
        return this.childNode;
    }
}

