/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BBZoomLevelFormat {
    private static Logger log = Logger.getLogger(BBZoomLevelFormat.class);
    public static final int ZOOM_FORMAT_HEADER_SIZE = 4;
    public static final int MAX_ZOOM_DATA_RECORDS = 100000000;
    private int zoomLevel;
    private SeekableStream fis;
    private long zoomFormatOffset;
    private long zoomDataOffset;
    private long zoomIndexOffset;
    private boolean isLowToHigh;
    private int zoomRecordCount;
    private long zoomDataSize;

    public BBZoomLevelFormat(int n, SeekableStream seekableStream, long l, long l2, boolean bl, int n2) {
        this.zoomLevel = n;
        this.fis = seekableStream;
        this.zoomFormatOffset = l;
        this.zoomDataSize = l2;
        this.isLowToHigh = bl;
        byte[] byArray = new byte[4];
        try {
            seekableStream.seek(this.zoomFormatOffset);
            seekableStream.readFully(byArray);
            if (this.isLowToHigh) {
                LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
                this.zoomRecordCount = littleEndianInputStream.readInt();
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.zoomRecordCount = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error reading zoom level data records (Table O) ", (Throwable)iOException);
            throw new RuntimeException("Error reading zoom level data records (Table O)", iOException);
        }
        if (this.zoomRecordCount < 0 || this.zoomRecordCount > 100000000) {
            return;
        }
        this.zoomDataOffset = this.zoomFormatOffset + 4L;
        this.zoomIndexOffset = this.zoomDataOffset + this.zoomDataSize;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public long getZoomFormatLocation() {
        return this.zoomFormatOffset;
    }

    public int getZoomRecordCount() {
        return this.zoomRecordCount;
    }

    public long getZoomDataOffset() {
        return this.zoomDataOffset;
    }

    public long getZoomDataSize() {
        return this.zoomDataSize;
    }

    public long getZoomIndexOffset() {
        return this.zoomIndexOffset;
    }

    public void print() {
        log.debug((Object)("Zoom level " + this.zoomLevel + " format Table O found at " + this.zoomFormatOffset));
        log.debug((Object)("Zoom record count is " + this.zoomRecordCount));
        log.debug((Object)("Zoom data location is " + this.zoomDataOffset));
        log.debug((Object)("Zoom data size is " + this.zoomDataOffset));
        log.debug((Object)("Zoom index tree location is " + this.zoomIndexOffset));
    }
}

