/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BBTotalSummaryBlock {
    private static Logger log = Logger.getLogger(BBTotalSummaryBlock.class);
    public static final int TOTAL_SUMMARY_BLOCK_SIZE = 40;
    private SeekableStream fis;
    private long summaryBlockOffset;
    private long basesCovered;
    private float minVal;
    private float maxVal;
    private float sumData;
    private float sumSquares;

    public BBTotalSummaryBlock(SeekableStream seekableStream, long l, boolean bl) {
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[40];
        this.fis = seekableStream;
        this.summaryBlockOffset = l;
        try {
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (bl) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            }
            if (bl) {
                this.basesCovered = littleEndianInputStream.readLong();
                this.minVal = littleEndianInputStream.readFloat();
                this.maxVal = littleEndianInputStream.readFloat();
                this.sumData = littleEndianInputStream.readFloat();
                this.sumSquares = littleEndianInputStream.readFloat();
            } else {
                this.basesCovered = dataInputStream.readLong();
                this.minVal = dataInputStream.readFloat();
                this.maxVal = dataInputStream.readFloat();
                this.sumData = dataInputStream.readFloat();
                this.sumSquares = dataInputStream.readFloat();
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error reading Total Summary Block ", (Throwable)iOException);
            throw new RuntimeException("Error reading Total Summary Block", iOException);
        }
    }

    public BBTotalSummaryBlock(long l, float f, float f2, float f3, float f4) {
        this.basesCovered = l;
        this.minVal = f;
        this.maxVal = f2;
        this.sumData = f3;
        this.sumSquares = f4;
    }

    public static int getSummaryBlockSize() {
        return 40;
    }

    public SeekableStream getMBBFis() {
        return this.fis;
    }

    public long getSummaryBlockOffset() {
        return this.summaryBlockOffset;
    }

    public long getBasesCovered() {
        return this.basesCovered;
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public float getSumData() {
        return this.sumData;
    }

    public float getSumSquares() {
        return this.sumSquares;
    }

    public void printTotalSummaryBlock() {
        log.debug((Object)"BBFile TotalSummaryBlock (Table DD):");
        log.debug((Object)("Number of bases covered= " + this.basesCovered));
        log.debug((Object)("MinVal = " + this.minVal));
        log.debug((Object)("MaxVal = " + this.maxVal));
        log.debug((Object)("Sum of data values = " + this.sumData));
        log.debug((Object)("Sum of squares values = " + this.sumSquares));
    }
}

