/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BBZoomLevels;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.ZoomLevelIterator;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableStream;

public class BBFileReader {
    public static final long BBFILE_HEADER_OFFSET = 0L;
    private static Logger log = Logger.getLogger(BBFileReader.class);
    private String path;
    private SeekableStream fis;
    private long fileOffset;
    private BBFileHeader fileHeader;
    private int dataCount;
    private boolean isLowToHigh;
    private int uncompressBufSize;
    private long autoSqlOffset;
    private String autoSqlFormat;
    private int zoomLevelCount;
    private long zoomLevelOffset;
    private BBZoomLevels zoomLevels;
    private long mTotalSummaryBlockOffset;
    private BBTotalSummaryBlock totalSummaryBlock;
    private long chromIDTreeOffset;
    private BPTree chromosomeIDTree;
    private long chromDataTreeOffset;
    private RPTree chromosomeDataTree;

    public BBFileReader(String string) throws IOException {
        this(string, new SeekableFileStream(new File(string)));
    }

    public BBFileReader(String string, SeekableStream seekableStream) {
        log.debug((Object)("Opening BBFile source  " + string));
        this.path = string;
        this.fis = seekableStream;
        this.fileOffset = 0L;
        this.fileHeader = new BBFileHeader(string, this.fis, this.fileOffset);
        if (!this.fileHeader.isHeaderOK()) {
            log.error((Object)("BBFile header is unrecognized type, header magic = " + this.fileHeader.getMagic()));
            throw new RuntimeException("Error reading BBFile header for: " + string);
        }
        this.isLowToHigh = this.fileHeader.isLowToHigh();
        this.uncompressBufSize = this.fileHeader.getUncompressBuffSize();
        this.fileOffset += 64L;
        this.zoomLevelCount = this.fileHeader.getZoomLevels();
        if (this.zoomLevelCount > 0) {
            this.zoomLevelOffset = this.fileOffset;
            this.zoomLevels = new BBZoomLevels(this.fis, this.zoomLevelOffset, this.zoomLevelCount, this.isLowToHigh, this.uncompressBufSize);
            this.fileOffset += (long)(this.zoomLevelCount * 24);
        }
        this.autoSqlOffset = this.fileHeader.getAutoSqlOffset();
        if (this.autoSqlOffset != 0L) {
            // empty if block
        }
        this.fileOffset = this.fileHeader.getTotalSummaryOffset();
        if (this.fileHeader.getVersion() >= 2 && this.fileOffset > 0L) {
            this.totalSummaryBlock = new BBTotalSummaryBlock(this.fis, this.fileOffset, this.isLowToHigh);
            this.fileOffset += 40L;
        }
        this.chromIDTreeOffset = this.fileHeader.getChromosomeTreeOffset();
        if (this.chromIDTreeOffset != 0L) {
            this.fileOffset = this.chromIDTreeOffset;
            this.chromosomeIDTree = new BPTree(this.fis, this.fileOffset, this.isLowToHigh);
        }
        this.chromDataTreeOffset = this.fileHeader.getFullIndexOffset();
        if (this.chromDataTreeOffset != 0L) {
            this.fileOffset = this.chromDataTreeOffset;
            boolean bl = false;
            this.chromosomeDataTree = new RPTree(this.fis, this.fileOffset, this.isLowToHigh, this.uncompressBufSize, bl);
        }
        this.fileOffset = this.fileHeader.getFullDataOffset();
        this.dataCount = this.getDataCount(this.fis, this.fileOffset);
    }

    public String getBBFilePath() {
        return this.path;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BBFileHeader getBBFileHeader() {
        return this.fileHeader;
    }

    public boolean isBigBedFile() {
        return this.fileHeader.isBigBed();
    }

    public boolean isBigWigFile() {
        return this.fileHeader.isBigWig();
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public long getChromosomeNameCount() {
        return this.chromosomeIDTree.getItemCount();
    }

    public long getChromosomeRegionCount() {
        return this.chromosomeDataTree.getItemCount();
    }

    public int getDecompressionBufSize() {
        return this.uncompressBufSize;
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public BBTotalSummaryBlock getTotalSummaryBlock() {
        return this.totalSummaryBlock;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromosomeIDTree;
    }

    public RPTree getChromosomeDataTree() {
        return this.chromosomeDataTree;
    }

    public int getZoomLevelCount() {
        return this.zoomLevelCount;
    }

    public BBZoomLevels getZoomLevels() {
        return this.zoomLevels;
    }

    public RPChromosomeRegion getZoomLevelBounds(int n, int n2, int n3) {
        RPChromosomeRegion rPChromosomeRegion = this.zoomLevels.getZoomLevelRPTree(n).getChromosomeRegion(n2, n3);
        return rPChromosomeRegion;
    }

    public RPChromosomeRegion getZoomLevelBounds(int n) {
        RPChromosomeRegion rPChromosomeRegion = this.zoomLevels.getZoomLevelRPTree(n).getChromosomeBounds();
        return rPChromosomeRegion;
    }

    public int getZoomLevelRecordCount(int n) {
        return this.zoomLevels.getZoomLevelFormats().get(n - 1).getZoomRecordCount();
    }

    public String getChromosomeName(int n) {
        String string = this.chromosomeIDTree.getChromosomeName(n);
        return string;
    }

    public ArrayList<String> getChromosomeNames() {
        ArrayList<String> arrayList = this.chromosomeIDTree.getChromosomeNames();
        return arrayList;
    }

    public int getChromosomeID(String string) {
        int n = this.chromosomeIDTree.getChromosomeID(string);
        return n;
    }

    public RPChromosomeRegion getChromosomeBounds(int n, int n2) {
        RPChromosomeRegion rPChromosomeRegion = this.chromosomeDataTree.getChromosomeRegion(n, n2);
        return rPChromosomeRegion;
    }

    public RPChromosomeRegion getChromosomeBounds() {
        RPChromosomeRegion rPChromosomeRegion = this.chromosomeDataTree.getChromosomeBounds();
        return rPChromosomeRegion;
    }

    public ArrayList<RPChromosomeRegion> getChromosomeRegions() {
        ArrayList<RPChromosomeRegion> arrayList = this.chromosomeDataTree.getAllChromosomeRegions();
        return arrayList;
    }

    public ArrayList<RPChromosomeRegion> getZoomLevelRegions(int n) {
        ArrayList<RPChromosomeRegion> arrayList = this.zoomLevels.getZoomLevelRPTree(n).getAllChromosomeRegions();
        return arrayList;
    }

    public BigBedIterator getBigBedIterator(String string, int n, String string2, int n2, boolean bl) {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion rPChromosomeRegion = this.getChromosomeBounds(string, n, string2, n2);
        if (rPChromosomeRegion == null) {
            return new BigBedIterator();
        }
        BigBedIterator bigBedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, rPChromosomeRegion, bl);
        return bigBedIterator;
    }

    public BigBedIterator getBigBedIterator() {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion rPChromosomeRegion = this.chromosomeDataTree.getChromosomeBounds();
        boolean bl = true;
        BigBedIterator bigBedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, rPChromosomeRegion, bl);
        return bigBedIterator;
    }

    public BigWigIterator getBigWigIterator(String string, int n, String string2, int n2, boolean bl) {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion rPChromosomeRegion = this.getChromosomeBounds(string, n, string2, n2);
        if (rPChromosomeRegion == null) {
            return new BigWigIterator();
        }
        BigWigIterator bigWigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, rPChromosomeRegion, bl);
        return bigWigIterator;
    }

    public BigWigIterator getBigWigIterator() {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion rPChromosomeRegion = this.chromosomeDataTree.getChromosomeBounds();
        boolean bl = true;
        BigWigIterator bigWigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, rPChromosomeRegion, bl);
        return bigWigIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int n, String string, int n2, String string2, int n3, boolean bl) {
        if (n < 1 || n > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree rPTree = this.zoomLevels.getZoomLevelRPTree(n);
        RPChromosomeRegion rPChromosomeRegion = this.getChromosomeBounds(string, n2, string2, n3);
        if (rPChromosomeRegion == null) {
            return ZoomLevelIterator.EmptyIterator.theInstance;
        }
        ZoomLevelIterator zoomLevelIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, rPTree, n, rPChromosomeRegion, bl);
        return zoomLevelIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int n) {
        if (n < 1 || n > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree rPTree = this.zoomLevels.getZoomLevelRPTree(n);
        RPChromosomeRegion rPChromosomeRegion = rPTree.getChromosomeBounds();
        boolean bl = true;
        ZoomLevelIterator zoomLevelIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, rPTree, n, rPChromosomeRegion, bl);
        return zoomLevelIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int n, RPChromosomeRegion rPChromosomeRegion, boolean bl) {
        if (n < 1 || n > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree rPTree = this.zoomLevels.getZoomLevelRPTree(n);
        ZoomLevelIterator zoomLevelIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, rPTree, n, rPChromosomeRegion, bl);
        return zoomLevelIterator;
    }

    private RPChromosomeRegion getChromosomeBounds(String string, int n, String string2, int n2) {
        if (string.length() > this.chromosomeIDTree.getKeySize()) {
            return null;
        }
        String string3 = this.chromosomeIDTree.getChromosomeKey(string);
        int n3 = this.chromosomeIDTree.getChromosomeID(string3);
        if (n3 < 0) {
            return null;
        }
        String string4 = this.chromosomeIDTree.getChromosomeKey(string2);
        int n4 = this.chromosomeIDTree.getChromosomeID(string4);
        if (n4 < 0) {
            return null;
        }
        RPChromosomeRegion rPChromosomeRegion = new RPChromosomeRegion(n3, n, n4, n2);
        return rPChromosomeRegion;
    }

    private int getDataCount(SeekableStream seekableStream, long l) {
        int n;
        LittleEndianInputStream littleEndianInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = new byte[4];
        try {
            seekableStream.seek(l);
            seekableStream.readFully(byArray);
            if (this.isLowToHigh) {
                littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
                n = littleEndianInputStream.readInt();
            } else {
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                n = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading data count for all data", iOException);
        }
        return n;
    }
}

