/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.interval;

import htsjdk.tribble.index.AbstractIndex;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.interval.Interval;
import htsjdk.tribble.index.interval.IntervalTree;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class IntervalTreeIndex
extends AbstractIndex {
    public static final int INDEX_TYPE = AbstractIndex.IndexType.INTERVAL_TREE.fileHeaderTypeIdentifier;

    public IntervalTreeIndex(InputStream inputStream) throws IOException {
        LittleEndianInputStream dis = new LittleEndianInputStream(inputStream);
        this.validateIndexHeader(INDEX_TYPE, dis);
        this.read(dis);
    }

    public IntervalTreeIndex(String featureFile) {
        super(featureFile);
    }

    @Override
    public Class getChrIndexClass() {
        return ChrIndex.class;
    }

    @Override
    protected int getType() {
        return INDEX_TYPE;
    }

    public void insert(String chr, Interval interval) {
        ChrIndex chrIdx = (ChrIndex)this.chrIndices.get(chr);
        if (chrIdx == null) {
            chrIdx = new ChrIndex(chr);
            this.chrIndices.put(chr, chrIdx);
        }
        chrIdx.insert(interval);
    }

    protected void setChrIndex(List<ChrIndex> indicies) {
        for (ChrIndex index : indicies) {
            this.chrIndices.put(index.getName(), index);
        }
    }

    public void printTree() {
        for (String chr : this.chrIndices.keySet()) {
            System.out.println(chr + ":");
            ChrIndex chrIdx = (ChrIndex)this.chrIndices.get(chr);
            chrIdx.printTree();
            System.out.println();
        }
    }

    public static class ChrIndex
    implements htsjdk.tribble.index.ChrIndex {
        IntervalTree tree;
        String name;

        public ChrIndex() {
        }

        public ChrIndex(String name) {
            this.name = name;
            this.tree = new IntervalTree();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void insert(Interval iv) {
            this.tree.insert(iv);
        }

        @Override
        public List<Block> getBlocks() {
            return null;
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            List<Interval> intervals = this.tree.findOverlapping(new Interval(start, end));
            if (intervals == null || intervals.isEmpty()) {
                return new ArrayList<Block>();
            }
            Block[] blocks = new Block[intervals.size()];
            int idx = 0;
            for (Interval iv : intervals) {
                blocks[idx++] = iv.getBlock();
            }
            Arrays.sort(blocks, new Comparator<Block>(){

                @Override
                public int compare(Block b1, Block b2) {
                    return b1.getStartPosition() - b2.getStartPosition() < 1L ? -1 : (b1.getStartPosition() - b2.getStartPosition() > 1L ? 1 : 0);
                }
            });
            ArrayList<Block> consolidatedBlocks = new ArrayList<Block>(blocks.length);
            Block lastBlock = blocks[0];
            consolidatedBlocks.add(lastBlock);
            for (int i = 1; i < blocks.length; ++i) {
                Block block = blocks[i];
                if (block.getStartPosition() < lastBlock.getEndPosition() + 1000L) {
                    lastBlock.setEndPosition(block.getEndPosition());
                    continue;
                }
                lastBlock = block;
                consolidatedBlocks.add(lastBlock);
            }
            return consolidatedBlocks;
        }

        public void printTree() {
            System.out.println(this.tree.toString());
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            List<Interval> intervals = this.tree.getIntervals();
            dos.writeInt(intervals.size());
            for (Interval interval : intervals) {
                dos.writeInt(interval.start);
                dos.writeInt(interval.end);
                dos.writeLong(interval.getBlock().getStartPosition());
                dos.writeInt((int)interval.getBlock().getSize());
            }
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.tree = new IntervalTree();
            this.name = dis.readString();
            int nIntervals = dis.readInt();
            while (nIntervals-- > 0) {
                int start = dis.readInt();
                int end = dis.readInt();
                long pos = dis.readLong();
                int size = dis.readInt();
                Interval iv = new Interval(start, end, new Block(pos, size));
                this.tree.insert(iv);
            }
        }
    }
}

