/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.server.PDBInstallation;
import org.biojava.bio.structure.server.StructureEventImpl;
import org.biojava.bio.structure.server.StructureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureFetcherRunnable
implements Runnable {
    PDBInstallation installation;
    List<StructureListener> listeners;

    public StructureFetcherRunnable(PDBInstallation installation) {
        this.installation = installation;
        this.listeners = new ArrayList<StructureListener>();
    }

    @Override
    public void run() {
        Structure s = this.installation.next();
        StructureEventImpl e = new StructureEventImpl(s);
        for (StructureListener li : this.listeners) {
            li.newStructure(e);
        }
    }

    public List<StructureListener> getStructureListeners() {
        return this.listeners;
    }

    public void addStructureListener(StructureListener listener) {
        this.listeners.add(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

