/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.EmblReferenceComparator;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.ReferenceAnnotation;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class SeqIOEventEmitter {
    private static Symbol[] symProto = new Symbol[0];
    private Comparator seqPropComparator;
    private Comparator refPropComparator;
    private Comparator featureComparator;

    public SeqIOEventEmitter(Comparator seqPropComparator, Comparator featureComparator) {
        this.seqPropComparator = seqPropComparator;
        this.featureComparator = featureComparator;
    }

    public void getSeqIOEvents(Sequence seq, SeqIOListener listener) {
        try {
            listener.startSequence();
            listener.setName(seq.getName());
            listener.setURI(seq.getURN());
            Annotation a = seq.getAnnotation();
            ArrayList sKeys = new ArrayList(a.keys());
            Collections.sort(sKeys, this.seqPropComparator);
            for (Object key : sKeys) {
                if (key.equals(ReferenceAnnotation.class)) {
                    ArrayList<Object> references = null;
                    if (a.getProperty(key) instanceof ArrayList) {
                        references = (ArrayList<Object>)a.getProperty(key);
                    } else if (a.getProperty(key) instanceof ReferenceAnnotation) {
                        references = new ArrayList<Object>();
                        references.add(a.getProperty(key));
                    }
                    if (references == null) continue;
                    for (int i = 0; i < references.size(); ++i) {
                        ReferenceAnnotation refAnnot = (ReferenceAnnotation)references.get(i);
                        Map referenceLines = refAnnot.getProperties();
                        ArrayList refKeys = new ArrayList(referenceLines.keySet());
                        this.refPropComparator = EmblReferenceComparator.INSTANCE;
                        Collections.sort(refKeys, this.refPropComparator);
                        for (Object refKey : refKeys) {
                            listener.addSequenceProperty(refKey, refAnnot.getProperty(refKey));
                        }
                    }
                    continue;
                }
                if (key.equals("XX")) continue;
                listener.addSequenceProperty(key, a.getProperty(key));
            }
            List subs = SeqIOEventEmitter.getSubFeatures(seq);
            Collections.sort(subs, this.featureComparator);
            Iterator fi = subs.iterator();
            while (fi.hasNext()) {
                Feature.Template t = ((Feature)fi.next()).makeTemplate();
                listener.startFeature(t);
                List fKeys = this.comparableList(t.annotation.keys());
                Collections.sort(fKeys);
                for (Object key : fKeys) {
                    listener.addFeatureProperty(key, t.annotation.getProperty(key));
                }
                listener.endFeature();
            }
            listener.addSymbols(seq.getAlphabet(), seq.toList().toArray(symProto), 0, seq.length());
            listener.endSequence();
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError("An internal error occurred processing symbols", iae);
        }
        catch (ParseException pe) {
            throw new BioError("An internal error occurred creating SeqIO events", pe);
        }
    }

    private static List getSubFeatures(FeatureHolder fh) {
        ArrayList<FeatureHolder> subfeat = new ArrayList<FeatureHolder>();
        Iterator fi = fh.features();
        while (fi.hasNext()) {
            FeatureHolder sfh = (FeatureHolder)fi.next();
            subfeat.addAll(SeqIOEventEmitter.getSubFeatures(sfh));
            subfeat.add(sfh);
        }
        return subfeat;
    }

    private List comparableList(Collection coll) {
        ArrayList res = new ArrayList();
        for (Object o : coll) {
            if (!(o instanceof Comparable)) continue;
            res.add(o);
        }
        return res;
    }
}

