/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.Unchangeable;

public class CharacterTokenization
extends Unchangeable
implements SymbolTokenization,
Serializable {
    private Alphabet alphabet;
    private Map symbolsToCharacters = new HashMap();
    private Map charactersToSymbols = new HashMap();
    private transient Symbol[] tokenTable;
    private boolean caseSensitive;

    public CharacterTokenization(Alphabet alpha, boolean caseSensitive) {
        this.alphabet = alpha;
        this.caseSensitive = caseSensitive;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolTokenization.TokenType getTokenType() {
        return CHARACTER;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public void bindSymbol(Symbol s, char c) {
        Character chr = new Character(c);
        if (!this.symbolsToCharacters.containsKey(s)) {
            this.symbolsToCharacters.put(s, chr);
        }
        if (!this.charactersToSymbols.containsKey(chr)) {
            this.charactersToSymbols.put(chr, s);
        }
        this.tokenTable = null;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        if (token.length() != 1) {
            throw new IllegalSymbolException("This Tokenization only accepts single-character tokens");
        }
        return this.parseTokenChar(token.charAt(0));
    }

    protected Symbol[] getTokenTable() {
        if (this.tokenTable == null) {
            int maxChar = 0;
            for (Character c : this.charactersToSymbols.keySet()) {
                char cv = c.charValue();
                if (this.caseSensitive) {
                    maxChar = Math.max(maxChar, cv);
                    continue;
                }
                maxChar = Math.max(maxChar, Character.toUpperCase(cv));
                maxChar = Math.max(maxChar, Character.toLowerCase(cv));
            }
            this.tokenTable = new Symbol[maxChar + 1];
            for (Map.Entry entry : this.charactersToSymbols.entrySet()) {
                Symbol sym = (Symbol)entry.getValue();
                Character c = (Character)entry.getKey();
                char cv = c.charValue();
                if (this.caseSensitive) {
                    this.tokenTable[cv] = sym;
                    continue;
                }
                this.tokenTable[Character.toUpperCase((char)cv)] = sym;
                this.tokenTable[Character.toLowerCase((char)cv)] = sym;
            }
        }
        return this.tokenTable;
    }

    protected Symbol parseTokenChar(char c) throws IllegalSymbolException {
        Symbol[] tokenTable = this.getTokenTable();
        Symbol sym = null;
        if (c < tokenTable.length) {
            sym = tokenTable[c];
        }
        if (sym == null) {
            throw new IllegalSymbolException("This tokenization doesn't contain character: '" + c + "'");
        }
        return sym;
    }

    private Character _tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        Character c = (Character)this.symbolsToCharacters.get(s);
        if (c == null) {
            Alphabet alpha = this.getAlphabet();
            this.alphabet.validate(s);
            if (alpha instanceof FiniteAlphabet) {
                c = (Character)this.symbolsToCharacters.get(AlphabetManager.getAllAmbiguitySymbol((FiniteAlphabet)alpha));
            }
            if (c == null) {
                throw new IllegalSymbolException("No mapping for symbol " + s.getName());
            }
        }
        return c;
    }

    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        return String.valueOf(this._tokenizeSymbol(s).charValue());
    }

    public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException {
        if (sl.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = sl.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            try {
                Character c = this._tokenizeSymbol(sym);
                sb.append(c.charValue());
            }
            catch (IllegalSymbolException ex) {
                throw new IllegalAlphabetException(ex, "Couldn't tokenize");
            }
        }
        return sb.substring(0);
    }

    public StreamParser parseStream(SeqIOListener listener) {
        return new TPStreamParser(listener);
    }

    private class TPStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private Symbol[] buffer = new Symbol[256];

        public TPStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) throws IllegalSymbolException {
            int cnt = 0;
            while (cnt < len) {
                int bcnt = 0;
                while (cnt < len && bcnt < this.buffer.length) {
                    this.buffer[bcnt++] = CharacterTokenization.this.parseTokenChar(data[start + cnt++]);
                }
                try {
                    this.listener.addSymbols(CharacterTokenization.this.getAlphabet(), this.buffer, 0, bcnt);
                }
                catch (IllegalAlphabetException ex) {
                    throw new BioError("Assertion failed: can't add symbols.", ex);
                }
            }
        }

        public void close() {
        }
    }
}

