/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.ReparentContext;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeVetoException;

public class SimpleGappedSequence
extends SimpleGappedSymbolList
implements GappedSequence {
    private Sequence sequence;
    private MergeFeatureHolder features;
    private SimpleFeatureHolder localFeatures;
    private FeatureHolder projectedFeatures;
    private boolean createOnUnderlying;

    public SimpleGappedSequence(Sequence seq) {
        super(seq);
        this.sequence = seq;
        this.createOnUnderlying = false;
    }

    public SimpleGappedSequence(GappedSequence seq) {
        super(seq);
        this.sequence = seq;
        this.createOnUnderlying = false;
    }

    public boolean getCreateOnUnderlyingSequence() {
        return this.createOnUnderlying;
    }

    public void setCreateOnUnderlyingSequence(boolean underlying) {
        this.createOnUnderlying = underlying;
    }

    public Annotation getAnnotation() {
        return this.sequence.getAnnotation();
    }

    public String getName() {
        return this.sequence.getName();
    }

    public String getURN() {
        return this.sequence.getURN();
    }

    private FeatureHolder getFeatures() {
        if (this.features == null) {
            this.features = this.makeFeatures();
        }
        return this.features;
    }

    private MergeFeatureHolder makeFeatures() {
        this.projectedFeatures = new ProjectedFeatureHolder(new GappedContext());
        this.localFeatures = new SimpleFeatureHolder();
        this.features = new MergeFeatureHolder();
        try {
            this.features.addFeatureHolder(this.projectedFeatures);
            this.features.addFeatureHolder(this.localFeatures);
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailure("Assertion Failure: Should be able to do this", cve);
        }
        return this.features;
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatures();
        if (this.localFeatures.containsFeature(f)) {
            this.localFeatures.removeFeature(f);
        } else {
            this.projectedFeatures.removeFeature(f);
        }
    }

    public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
        this.getFeatures();
        if (this.createOnUnderlying) {
            return this.projectedFeatures.createFeature(templ);
        }
        Feature f = FeatureImpl.DEFAULT.realizeFeature(this, this, templ);
        this.localFeatures.addFeature(f);
        return f;
    }

    public class GappedContext
    extends ReparentContext {
        public GappedContext() {
            super(SimpleGappedSequence.this, SimpleGappedSequence.this.sequence);
        }

        public Location projectLocation(Location loc) {
            return loc.newInstance(SimpleGappedSequence.this.locationToGapped(loc));
        }

        public Location mapLocation(Location loc) {
            return loc.newInstance(SimpleGappedSequence.this.locationToGapped(loc));
        }

        public Location revertLocation(Location oldLoc) {
            return SimpleGappedSequence.this.gappedToLocation(oldLoc);
        }
    }
}

