/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.io.Serializable;
import org.biojava.bio.search.FilterTest;
import org.biojava.utils.TriState;
import org.biojava.utils.walker.WalkerFactory;

public interface BlastLikeSearchFilter
extends Serializable {
    public static final String KEY_QUERY_ID = "___QUERY_ID___";

    public TriState accept();

    public void evaluate(Node var1);

    public void reset();

    public static final class BySubHitProperty
    extends AbstractBlastLikeSearchFilter {
        private Object key;
        private FilterTest test;

        public BySubHitProperty(String key, FilterTest test) {
            this.key = key;
            this.test = test;
        }

        public void evaluate(Node fch) {
            Object propertyValue = fch.getSubHitProperty(this.key);
            this.cachedOutcome = propertyValue != null && this.test.accept(propertyValue) ? TriState.TRUE : TriState.FALSE;
        }
    }

    public static final class ByHitProperty
    extends AbstractBlastLikeSearchFilter {
        private Object key;
        private FilterTest test;

        public ByHitProperty(String key, FilterTest test) {
            this.key = key;
            this.test = test;
        }

        public void evaluate(Node fch) {
            Object propertyValue = fch.getHitProperty(this.key);
            this.cachedOutcome = propertyValue != null && this.test.accept(propertyValue) ? TriState.TRUE : TriState.FALSE;
        }
    }

    public static final class BySearchProperty
    extends AbstractBlastLikeSearchFilter {
        private Object key;
        private FilterTest test;

        public BySearchProperty(String key, FilterTest test) {
            this.key = key;
            this.test = test;
        }

        public void evaluate(Node fch) {
            Object propertyValue = fch.getSearchProperty(this.key);
            this.cachedOutcome = propertyValue != null && this.test.accept(propertyValue) ? TriState.TRUE : TriState.FALSE;
        }
    }

    public static final class Not
    extends AbstractBlastLikeSearchFilter {
        private AbstractBlastLikeSearchFilter filter;

        public Not(AbstractBlastLikeSearchFilter filter) {
            this.filter = filter;
        }

        public TriState accept() {
            TriState outcome = this.filter.accept();
            if (outcome == TriState.INDETERMINATE) {
                return TriState.INDETERMINATE;
            }
            if (outcome == TriState.TRUE) {
                return TriState.FALSE;
            }
            return TriState.TRUE;
        }

        public void evaluate(Node fch) {
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(Not.class);
        }
    }

    public static final class Or {
        private AbstractBlastLikeSearchFilter filter0;
        private AbstractBlastLikeSearchFilter filter1;

        public Or(AbstractBlastLikeSearchFilter filter0, AbstractBlastLikeSearchFilter filter1) {
            this.filter0 = filter0;
            this.filter1 = filter1;
        }

        public TriState accept() {
            TriState outcome0 = this.filter0.accept();
            TriState outcome1 = this.filter1.accept();
            if (outcome0 == TriState.TRUE || outcome1 == TriState.TRUE) {
                return TriState.TRUE;
            }
            if (outcome0 == TriState.INDETERMINATE || outcome1 == TriState.INDETERMINATE) {
                return TriState.INDETERMINATE;
            }
            return TriState.FALSE;
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(Or.class);
        }
    }

    public static final class And {
        private AbstractBlastLikeSearchFilter filter0;
        private AbstractBlastLikeSearchFilter filter1;

        public And(AbstractBlastLikeSearchFilter filter0, AbstractBlastLikeSearchFilter filter1) {
            this.filter0 = filter0;
            this.filter1 = filter1;
        }

        public TriState accept() {
            TriState outcome0 = this.filter0.accept();
            TriState outcome1 = this.filter1.accept();
            if (outcome0 == TriState.FALSE || outcome1 == TriState.FALSE) {
                return TriState.FALSE;
            }
            if (outcome0 == TriState.INDETERMINATE || outcome1 == TriState.INDETERMINATE) {
                return TriState.INDETERMINATE;
            }
            return TriState.TRUE;
        }

        static {
            WalkerFactory.getInstance().addTypeWithParent(And.class);
        }
    }

    public static abstract class AbstractBlastLikeSearchFilter
    implements BlastLikeSearchFilter {
        protected TriState cachedOutcome = TriState.INDETERMINATE;

        public TriState accept() {
            return this.cachedOutcome;
        }

        public abstract void evaluate(Node var1);

        public void reset() {
            this.cachedOutcome = TriState.INDETERMINATE;
        }

        private AbstractBlastLikeSearchFilter() {
        }
    }

    public static interface Node {
        public Object getSearchProperty(Object var1);

        public Object getHitProperty(Object var1);

        public Object getSubHitProperty(Object var1);
    }
}

