/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.List;
import java.util.Map;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallMap;

public class ChangeTable {
    public static final Changer STRING_TO_INT = new Changer(){

        public Object change(Object val) {
            return new Integer((String)val);
        }
    };
    private final Map changers = new SmallMap();
    private final Map splitters = new SmallMap();

    public void setChanger(Object tag, Changer changer) {
        this.changers.put(tag, changer);
    }

    public void setSplitter(Object tag, Splitter splitter) {
        this.splitters.put(tag, splitter);
    }

    public Changer getChanger(Object tag) {
        return (Changer)this.changers.get(tag);
    }

    public Splitter getSplitter(Object tag) {
        return (Splitter)this.splitters.get(tag);
    }

    public Object change(Object tag, Object value) throws ParserException {
        Changer c = (Changer)this.changers.get(tag);
        if (c != null) {
            return c.change(value);
        }
        Splitter s = (Splitter)this.splitters.get(tag);
        if (s != null) {
            return s.split(value);
        }
        return value;
    }

    public static class ChainedChanger
    implements Changer {
        private Changer[] changers;

        public ChainedChanger(Changer[] changers) {
            this.changers = new Changer[changers.length];
            System.arraycopy(changers, 0, this.changers, 0, changers.length);
        }

        public Object change(Object value) throws ParserException {
            for (int i = 0; i < this.changers.length; ++i) {
                value = this.changers[i].change(value);
            }
            return value;
        }
    }

    public static interface Splitter {
        public List split(Object var1) throws ParserException;
    }

    public static interface Changer {
        public Object change(Object var1) throws ParserException;
    }
}

