/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.phred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class PhredFormat
implements SequenceFormat,
ParseErrorSource,
ParseErrorListener,
Serializable {
    public static final String DEFAULT = "PHRED";
    private Vector mListeners = new Vector();
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    private int lineWidth = 60;

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener siol) throws IllegalSymbolException, IOException, ParseException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature stream end");
        }
        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain Phred formatted data: " + line);
        }
        siol.startSequence();
        String description = line.substring(1).trim();
        siol.addSequenceProperty(PROPERTY_DESCRIPTIONLINE, description);
        boolean seenEOF = this.readSequenceData(reader, symParser, siol);
        siol.endSequence();
        return !seenEOF;
    }

    private boolean readSequenceData(BufferedReader br, SymbolTokenization parser, SeqIOListener listener) throws IOException, IllegalSymbolException {
        char[] buffer = new char[256];
        StreamParser sparser = parser.parseStream(listener);
        boolean seenEOF = false;
        boolean reachedEnd = false;
        while (!reachedEnd) {
            int parseEnd;
            br.mark(buffer.length);
            int bytesRead = br.read(buffer, 0, buffer.length);
            while (Character.isDigit(buffer[buffer.length - 1])) {
                br.reset();
                buffer = new char[buffer.length + 64];
                br.mark(buffer.length);
                bytesRead = br.read(buffer, 0, buffer.length);
            }
            if (bytesRead < 0) {
                reachedEnd = true;
                seenEOF = true;
                continue;
            }
            for (parseEnd = 0; !reachedEnd && parseEnd < bytesRead && buffer[parseEnd] != '>'; ++parseEnd) {
            }
            sparser.characters(buffer, 0, parseEnd);
            if (parseEnd >= bytesRead || buffer[parseEnd] != '>') continue;
            br.reset();
            if (br.skip(parseEnd) != (long)parseEnd) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            reachedEnd = true;
        }
        sparser.close();
        return seenEOF;
    }

    protected String describeSequence(Sequence seq) {
        String description = null;
        try {
            description = seq.getAnnotation().getProperty(PROPERTY_DESCRIPTIONLINE).toString();
        }
        catch (NoSuchElementException ex) {
            description = seq.getName();
        }
        return description;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        os.print(">");
        os.println(this.describeSequence(seq));
        StringBuffer line = new StringBuffer();
        int seqLen = seq.length();
        for (int i = 1; i <= seqLen; ++i) {
            int val = ((IntegerAlphabet.IntegerSymbol)seq.symbolAt(i)).intValue();
            String s = Integer.toString(val);
            if (line.length() + s.length() > this.lineWidth) {
                os.println(line.substring(0));
                line = new StringBuffer();
            }
            line.append(s + " ");
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (!format.equalsIgnoreCase(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format '" + format + "'");
        }
        this.writeSequence(seq, os);
    }

    public String getDefaultFormat() {
        return DEFAULT;
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        PhredFormat phredFormat = this;
        synchronized (phredFormat) {
            listeners = (Vector)this.mListeners.clone();
        }
        for (int index = 0; index < listeners.size(); ++index) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
        }
    }
}

