/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.CacheList;
import org.biojava.bio.program.indexdb.ConfigFile;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.indexdb.KeyPair;
import org.biojava.bio.program.indexdb.PrimaryIDList;
import org.biojava.bio.program.indexdb.Record;
import org.biojava.bio.program.indexdb.SearchableList;
import org.biojava.bio.program.indexdb.SecondaryFileAsList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.CommitFailure;
import org.biojava.utils.SmallMap;
import org.biojava.utils.io.RAF;

public class BioStore
implements IndexStore {
    static Comparator STRING_CASE_SENSITIVE_ORDER = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo(b);
        }
    };
    private ConfigFile metaData;
    private File location;
    private String primaryKey;
    private Map idToList;
    private RAF[] fileIDToRAF;
    private SearchableList primaryList;
    private int fileCount;

    public BioStore(File location, boolean cache) throws IOException, BioException {
        this(location, cache, false);
    }

    BioStore(File location, boolean cache, boolean mutable) throws IOException, BioException {
        this.location = location;
        File configFile = BioStoreFactory.makeConfigFile(location);
        if (!configFile.exists()) {
            throw new BioException("Config file does not exist: " + configFile);
        }
        this.metaData = new ConfigFile(BioStoreFactory.makeConfigFile(location));
        this.idToList = new SmallMap();
        this.primaryKey = (String)this.metaData.getProperty("primary_namespace");
        String keyList = (String)this.metaData.getProperty("secondary_namespaces");
        File plFile = BioStoreFactory.makePrimaryKeyFile(location, this.primaryKey);
        this.primaryList = cache ? new CacheList(new PrimaryIDList(plFile, this, mutable)) : new PrimaryIDList(plFile, this, mutable);
        StringTokenizer sTok = new StringTokenizer(keyList, "\t");
        while (sTok.hasMoreTokens()) {
            String k = sTok.nextToken();
            File file = BioStoreFactory.makeSecondaryFile(location, k);
            if (cache) {
                this.idToList.put(k, new CacheList(new SecondaryFileAsList(file, mutable)));
                continue;
            }
            this.idToList.put(k, new SecondaryFileAsList(file, mutable));
        }
        this.readFileIDs();
    }

    public String getName() {
        if (this.metaData.containsProperty("name")) {
            return (String)this.metaData.getProperty("name");
        }
        return null;
    }

    public File getLocation() {
        return this.location;
    }

    private void readFileIDs() throws IOException, BioException {
        this.fileIDToRAF = new RAF[5];
        this.fileCount = 0;
        for (String key : this.metaData.keys()) {
            if (!key.startsWith("fileid_")) continue;
            int indx = Integer.parseInt(key.substring("fileid_".length()));
            String fileLine = (String)this.metaData.getProperty(key);
            int tab = fileLine.indexOf("\t");
            File file = new File(fileLine.substring(0, tab));
            RAF raf = new RAF(file, "r");
            long length = Long.parseLong(fileLine.substring(tab + 1));
            if (file.length() != length) {
                throw new BioException("File changed length: " + file);
            }
            if (indx >= this.fileCount) {
                if (indx >= this.fileIDToRAF.length) {
                    RAF[] tmpr = new RAF[indx + 1];
                    System.arraycopy(this.fileIDToRAF, 0, tmpr, 0, this.fileIDToRAF.length);
                    this.fileIDToRAF = tmpr;
                }
                this.fileCount = indx;
            }
            this.fileIDToRAF[indx] = raf;
        }
    }

    private void writeFileIDs() throws BioException, IOException, ChangeVetoException {
        for (int i = 0; i < this.fileCount; ++i) {
            RAF file = this.fileIDToRAF[i];
            long length = file.length();
            String prop = "fileid_" + i;
            String val = file.getFile().toString() + "\t" + length;
            this.metaData.setProperty(prop, val);
        }
    }

    RAF getFileForID(int fileId) {
        return this.fileIDToRAF[fileId];
    }

    int getIDForFile(RAF file) throws IOException {
        for (int i = 0; i < this.fileCount; ++i) {
            if (!file.equals(this.fileIDToRAF[i])) continue;
            return i;
        }
        if (this.fileCount >= this.fileIDToRAF.length) {
            RAF[] tmpr = new RAF[this.fileIDToRAF.length + 4];
            System.arraycopy(this.fileIDToRAF, 0, tmpr, 0, this.fileCount);
            this.fileIDToRAF = tmpr;
        }
        this.fileIDToRAF[this.fileCount] = file;
        return this.fileCount++;
    }

    public Annotation getMetaData() {
        return this.metaData;
    }

    public Record get(String id) {
        return (Record)this.primaryList.search(id);
    }

    public List get(String id, String namespace) throws BioException {
        ArrayList<Object> hits = new ArrayList<Object>();
        if (namespace.equals(this.primaryKey)) {
            hits.add(this.primaryList.search(id));
        } else {
            SecondaryFileAsList secList = (SecondaryFileAsList)this.idToList.get(namespace);
            List kpList = secList.searchAll(id);
            for (KeyPair keyPair : kpList) {
                hits.add(this.primaryList.search(keyPair.getSecondary()));
            }
        }
        return hits;
    }

    public void writeRecord(RAF file, long offset, int length, String id, Map secIDs) {
        this.primaryList.add(new Record.Impl(id, file, offset, length));
        if (!secIDs.isEmpty()) {
            for (Map.Entry me : secIDs.entrySet()) {
                String sid = (String)me.getKey();
                List sfl = (List)this.idToList.get(sid);
                Collection svals = (Collection)me.getValue();
                for (String sval : svals) {
                    sfl.add(new KeyPair.Impl(sval, id));
                }
            }
        }
    }

    public List getRecordList() {
        return this.primaryList;
    }

    public void commit() throws CommitFailure {
        Collections.sort(this.primaryList, this.primaryList.getComparator());
        this.primaryList.commit();
        for (SearchableList fal : this.idToList.values()) {
            Collections.sort(fal, fal.getComparator());
            fal.commit();
        }
        try {
            this.writeFileIDs();
        }
        catch (ChangeVetoException cve) {
            throw new CommitFailure(cve);
        }
        catch (IOException ioe) {
            throw new CommitFailure(ioe);
        }
        catch (BioException be) {
            throw new CommitFailure(be);
        }
        this.metaData.commit();
    }
}

