/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ListTools;

public class EmissionCache
implements Serializable {
    private final Map eMap = new HashMap();
    private final Alphabet alpha;
    private final State[] states;
    private final int dsi;
    private final ScoreType scoreType;
    private final Symbol[] gap;

    public EmissionCache(Alphabet alpha, State[] states, int dsi, ScoreType scoreType) {
        this.alpha = alpha;
        this.states = states;
        this.dsi = dsi;
        this.scoreType = scoreType;
        List alphas = alpha.getAlphabets();
        this.gap = new Symbol[alphas.size()];
        for (int i = 0; i < this.gap.length; ++i) {
            this.gap[i] = ((Alphabet)alphas.get(i)).getGapSymbol();
        }
    }

    public final double[] getEmissions(List symList) throws IllegalSymbolException {
        return this.getEmissions(symList, true);
    }

    public final double[] getEmissions(List symList, boolean exorcise) throws IllegalSymbolException {
        double[] emission;
        if (exorcise) {
            emission = (double[])this.eMap.get(symList);
            if (emission == null) {
                emission = this.computeEmissions(symList, true);
                this.eMap.put(ListTools.createList(symList), emission);
            }
        } else {
            emission = this.computeEmissions(symList, false);
        }
        return emission;
    }

    private double[] computeEmissions(List symList, boolean exorcise) throws IllegalSymbolException {
        Symbol[][] sym = new Symbol[2][2];
        sym[0][0] = AlphabetManager.getGapSymbol();
        sym[1][1] = this.alpha.getSymbol(Arrays.asList((Symbol)symList.get(0), (Symbol)symList.get(1)));
        sym[1][0] = this.alpha.getSymbol(Arrays.asList((Symbol)symList.get(0), this.gap[1]));
        sym[0][1] = this.alpha.getSymbol(Arrays.asList(this.gap[0], (Symbol)symList.get(1)));
        double[] emission = new double[this.dsi];
        for (int i = 0; i < this.dsi; ++i) {
            if (exorcise && this.states[i] instanceof MagicalState) {
                emission[i] = Double.NEGATIVE_INFINITY;
                continue;
            }
            EmissionState es = (EmissionState)this.states[i];
            int[] advance = es.getAdvance();
            Distribution dis = es.getDistribution();
            Symbol s = sym[advance[0]][advance[1]];
            emission[i] = Math.log(this.scoreType.calculateScore(dis, s));
        }
        return emission;
    }

    public void clear() {
        this.eMap.clear();
    }
}

