/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.annodb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.annodb.AnnotationDB;

public class SimpleAnnotationDB
implements AnnotationDB {
    private final String name;
    private final Set anns;
    private final AnnotationType schema;

    public SimpleAnnotationDB(String name, Set anns, AnnotationType schema) {
        this.name = name;
        this.anns = anns;
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.anns.size();
    }

    public AnnotationType getSchema() {
        return this.schema;
    }

    public Iterator iterator() {
        return this.anns.iterator();
    }

    public AnnotationDB filter(AnnotationType at) {
        HashSet<Annotation> hits = new HashSet<Annotation>();
        AnnotationType intersection = AnnotationTools.intersection(this.schema, at);
        if (intersection != AnnotationType.NONE) {
            for (Annotation ann : this.anns) {
                if (!at.instanceOf(ann)) continue;
                hits.add(ann);
            }
        }
        if (hits.isEmpty()) {
            return AnnotationDB.EMPTY;
        }
        return new SimpleAnnotationDB("", hits, intersection);
    }

    public AnnotationDB search(AnnotationType at) {
        HashSet hits = new HashSet();
        for (Annotation ann : this.anns) {
            hits.addAll(AnnotationTools.searchAnnotation(ann, at));
        }
        if (hits.isEmpty()) {
            return AnnotationDB.EMPTY;
        }
        return new SimpleAnnotationDB("", hits, at);
    }
}

