/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.annodb;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioException;
import org.biojava.bio.annodb.AnnotationDB;
import org.biojava.bio.annodb.LazyFilteredAnnotationDB;
import org.biojava.bio.annodb.LazySearchedAnnotationDB;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.Record;
import org.biojava.bio.program.tagvalue.AnnotationBuilder;
import org.biojava.bio.program.tagvalue.Index2Model;
import org.biojava.bio.program.tagvalue.Indexer2;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.seq.io.filterxml.XMLAnnotationTypeHandler;
import org.biojava.bio.seq.io.filterxml.XMLAnnotationTypeWriter;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.CommitFailure;
import org.biojava.utils.ParserException;
import org.biojava.utils.io.RandomAccessReader;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IndexedAnnotationDB
implements AnnotationDB {
    private final BioStore store;
    private final AnnotationType schema;
    private final ParserListenerFactory plFactory;
    private final ParserListener parserListener;
    private final AnnotationBuilder annBuilder;
    private final Parser recordParser;

    public IndexedAnnotationDB(String dbName, File storeLoc, Index2Model model, List toIndex, int maxKeyLen, AnnotationType schema, ParserListenerFactory plFactory) throws BioException, CommitFailure, IOException, ParserException {
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreName(dbName);
        bsf.setPrimaryKey(model.getPrimaryKeyName());
        bsf.setStoreLocation(storeLoc);
        for (String key : model.getKeys()) {
            bsf.addKey(key, maxKeyLen);
        }
        this.store = bsf.createBioStore();
        this.schema = schema;
        this.plFactory = plFactory;
        this.annBuilder = new AnnotationBuilder(schema);
        this.parserListener = plFactory.getParserListener(this.annBuilder);
        this.recordParser = new Parser();
        File factoryFile = new File(this.store.getLocation(), "ParserListenerFactory.xml");
        XMLEncoder xmlEnc = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(factoryFile)));
        xmlEnc.writeObject(plFactory);
        xmlEnc.close();
        File schemaFile = new File(this.store.getLocation(), "schema.xml");
        PrintWriter schemaPW = new PrintWriter(new FileWriter(schemaFile));
        PrettyXMLWriter schemaWriter = new PrettyXMLWriter(schemaPW);
        XMLAnnotationTypeWriter schemaTW = new XMLAnnotationTypeWriter();
        schemaTW.writeAnnotationType(schema, schemaWriter);
        schemaPW.flush();
        schemaPW.close();
        for (File file : toIndex) {
            Indexer2 ndx = new Indexer2(file, this.store, model);
            ParserListener pl = plFactory.getParserListener(ndx);
            Parser parser = new Parser();
            while (parser.read(ndx.getReader(), pl.getParser(), pl.getListener())) {
            }
        }
        this.store.commit();
    }

    public IndexedAnnotationDB(BioStore store) throws IOException, SAXException {
        this.store = store;
        File factoryFile = new File(store.getLocation(), "ParserListenerFactory.xml");
        XMLDecoder xmlDec = new XMLDecoder(new BufferedInputStream(new FileInputStream(factoryFile)));
        this.plFactory = (ParserListenerFactory)xmlDec.readObject();
        xmlDec.close();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        XMLAnnotationTypeHandler annTypeH = new XMLAnnotationTypeHandler();
        parser.setContentHandler(new SAX2StAXAdaptor(annTypeH));
        this.schema = annTypeH.getAnnotationType();
        this.annBuilder = new AnnotationBuilder(this.schema);
        this.parserListener = this.plFactory.getParserListener(this.annBuilder);
        this.recordParser = new Parser();
    }

    public String getName() {
        return this.store.getName();
    }

    public AnnotationType getSchema() {
        return this.schema;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator rli;
            {
                this.rli = IndexedAnnotationDB.this.store.getRecordList().iterator();
            }

            public boolean hasNext() {
                return this.rli.hasNext();
            }

            public Object next() {
                try {
                    return IndexedAnnotationDB.this.process((Record)this.rli.next());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.store.getRecordList().size();
    }

    public AnnotationDB filter(AnnotationType at) {
        AnnotationType schema = AnnotationTools.intersection(at, this.schema);
        if (schema != AnnotationType.NONE) {
            return new LazyFilteredAnnotationDB("", this, schema);
        }
        return AnnotationDB.EMPTY;
    }

    public AnnotationDB search(AnnotationType at) {
        return new LazySearchedAnnotationDB("", this, at);
    }

    public ParserListenerFactory getParserListenerFactory() {
        return this.plFactory;
    }

    private Annotation process(Record rec) throws IOException, ParserException {
        RandomAccessReader rar = new RandomAccessReader(rec.getFile());
        rar.seek(rec.getOffset());
        BufferedReader reader = new BufferedReader(rar);
        this.recordParser.read(reader, this.parserListener.getParser(), this.parserListener.getListener());
        return this.annBuilder.getLast();
    }

    public static class StaticMethodRPFactory
    implements ParserListenerFactory {
        private final Method method;

        public StaticMethodRPFactory(Method method) throws IllegalArgumentException {
            if ((method.getModifiers() & 8) != 8) {
                throw new IllegalArgumentException("Method must be static");
            }
            if (method.getReturnType() != ParserListener.class) {
                throw new IllegalArgumentException("Method must return a ParserListener instance");
            }
            if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != TagValueListener.class) {
                throw new IllegalArgumentException("Method must accept a single TagValueListener as it's sole parameter");
            }
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public ParserListener getParserListener(TagValueListener tvl) {
            try {
                return (ParserListener)this.method.invoke(null, tvl);
            }
            catch (Exception e) {
                throw new AssertionFailure("Could not invoke underlying method.", e);
            }
        }
    }

    public static interface ParserListenerFactory
    extends Serializable {
        public ParserListener getParserListener(TagValueListener var1);
    }
}

