/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.ErlangMRGParams;
import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import java.util.Random;

public class ErlangMRG
extends MultivariateRandomGenerator {
    private Random r = new Random();

    @Override
    public void generate(double[] d, int start, int n, MRGParams p) {
        int i;
        ErlangMRGParams param = (ErlangMRGParams)p;
        if (param.getDimension() != n) {
            throw new IllegalArgumentException("Hyperparameter doesnot have a correct dimension.");
        }
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            d[start + i] = ErlangMRG.erlangDistributed(param.getHyperparameter(i), this.r);
            sum += d[start + i];
        }
        i += start;
        while (start < i) {
            int n2 = start++;
            d[n2] = d[n2] / sum;
        }
    }

    private static double erlangDistributed(int alpha, Random r) {
        double erg = 0.0;
        for (int i = 0; i < alpha; ++i) {
            erg -= Math.log(1.0 - r.nextDouble());
        }
        return erg;
    }
}

