/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.phylo;

import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.phylo.PhyloNode;
import java.util.ArrayList;

public class PhyloTree
implements Cloneable,
Storable {
    private PhyloNode root;
    private String name;
    private static final String XML_TAG = "PHYLO_TREE";

    public PhyloTree(String name, PhyloNode root) {
        this.name = name;
        this.root = root;
    }

    public PhyloTree(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.root = (PhyloNode)XMLParser.extractObjectForTags(xml, "root");
        this.name = (String)XMLParser.extractObjectForTags(xml, "name");
    }

    public PhyloTree clone() throws CloneNotSupportedException {
        PhyloTree clone = (PhyloTree)super.clone();
        clone.root = this.root.clone();
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public PhyloNode getRoot() {
        return this.root;
    }

    public int getNumberOfNodes() {
        return this.root.getNumberOfAllNodesBelow() + 1;
    }

    public ArrayList<PhyloNode> getAllLeafs() {
        return this.root.getAllLeafs();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.root, "root");
        XMLParser.appendObjectWithTags(xml, this.name, "name");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }
}

