/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.LimitedMedianStartDistance;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMConstraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.utils.RealTime;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;
import de.jstacs.utils.UserTime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class MEMTools {
    public static final byte SGIS_P = 11;
    public static final byte BGIS_P = 12;
    public static final byte GIS = 13;
    public static final byte SGIS = 14;
    public static final byte BGIS = 15;
    protected static final double LIN_EPS = 1.0E9;
    protected static final double STARTDISTANCE = 1.0;

    public static double train(MEMConstraint[] constraints, int[][] cond, SequenceIterator sequence, byte algorithm, TerminationCondition condition, OutputStream stream, int[] alphLen) throws Exception {
        double Z;
        if (constraints.length == 0) {
            return 0.0;
        }
        SafeOutputStream sostream = SafeOutputStream.getSafeOutputStream(stream);
        MEMTools.setParametersToValue(constraints, 0.0);
        int counter1 = 0;
        if (constraints.length > 1) {
            for (int counter2 = 0; counter2 < constraints.length; ++counter2) {
                for (counter1 = 0; counter1 < constraints[counter2].getNumberOfSpecificConstraints(); ++counter1) {
                    MEMTools.check(constraints[counter2].getFreq(counter1));
                }
            }
            sostream.write("numerically: ");
            Z = alphLen[0];
            for (counter1 = 1; counter1 < alphLen.length; ++counter1) {
                Z *= (double)alphLen[counter1];
            }
            sequence.setBounds(alphLen);
            switch (algorithm) {
                case 11: {
                    sostream.writeln("SGIS_P");
                    counter1 = MEMTools.sequentialGeneralizedIterativeScalingP(constraints, Z, alphLen, sequence, condition, sostream);
                    break;
                }
                case 12: {
                    sostream.writeln("BGIS_P");
                    counter1 = MEMTools.blockwiseGeneralizedIterativeScalingP(constraints, Z, alphLen, sequence, condition, sostream);
                    break;
                }
                case 13: {
                    sostream.writeln("GIS");
                    counter1 = MEMTools.generalizedIterativeScaling(constraints, Z, sequence, condition, sostream);
                    break;
                }
                case 14: {
                    sostream.writeln("SGIS");
                    counter1 = MEMTools.sequentialGeneralizedIterativeScaling(constraints, Z, sequence, condition, sostream);
                    break;
                }
                case 15: {
                    sostream.writeln("BGIS");
                    counter1 = MEMTools.blockwiseGeneralizedIterativeScaling(constraints, Z, sequence, condition, sostream);
                    break;
                }
                default: {
                    DualFunction psi = new DualFunction(sequence, constraints);
                    double[] x = new double[psi.getDimensionOfScope()];
                    counter1 = Optimizer.optimize(algorithm, psi, x, condition, 1.0E9, new LimitedMedianStartDistance(5, 1.0), sostream);
                    psi.setValues(x);
                    Z = psi.getZ();
                    break;
                }
            }
        } else {
            if (cond == null) {
                sostream.writeln("unconditional analytically");
                for (counter1 = 0; counter1 < constraints[0].getNumberOfSpecificConstraints(); ++counter1) {
                    constraints[0].setExpLambda(counter1, constraints[0].getFreq(counter1));
                }
            } else {
                int counter3;
                int index;
                int counter2;
                sostream.writeln("conditional analytically");
                int[][] constrOffset = new int[cond.length][];
                double[][] constr = new double[cond.length][];
                sequence.setBounds(alphLen);
                for (counter1 = 0; counter1 < cond.length; ++counter1) {
                    constrOffset[counter1] = new int[cond[counter1].length];
                    constrOffset[counter1][0] = 1;
                    for (counter2 = 1; counter2 < cond[counter1].length; ++counter2) {
                        constrOffset[counter1][counter2] = constrOffset[counter1][counter2 - 1] * alphLen[cond[counter1][counter2 - 1]];
                    }
                    constr[counter1] = new double[constrOffset[counter1][--counter2] * alphLen[cond[counter1][counter2]]];
                }
                do {
                    counter1 = constraints[0].satisfiesSpecificConstraint(sequence);
                    for (counter2 = 0; counter2 < cond.length; ++counter2) {
                        index = 0;
                        for (counter3 = 0; counter3 < cond[counter2].length; ++counter3) {
                            index += constrOffset[counter2][counter3] * sequence.seq[cond[counter2][counter3]];
                        }
                        double[] dArray = constr[counter2];
                        int n = index;
                        dArray[n] = dArray[n] + constraints[0].getFreq(counter1);
                    }
                } while (sequence.next());
                sequence.reset();
                do {
                    counter1 = constraints[0].satisfiesSpecificConstraint(sequence);
                    double q = constraints[0].getFreq(counter1);
                    for (counter2 = 0; counter2 < cond.length; ++counter2) {
                        index = 0;
                        for (counter3 = 0; counter3 < cond[counter2].length; ++counter3) {
                            index += constrOffset[counter2][counter3] * sequence.seq[cond[counter2][counter3]];
                        }
                        q /= constr[counter2][index];
                    }
                    constraints[0].setExpLambda(counter1, q);
                } while (sequence.next());
            }
            Z = 1.0;
            counter1 = 0;
        }
        return Z;
    }

    public static void setParametersToValue(MEMConstraint[] constraint, double val) {
        for (int i = 0; i < constraint.length; ++i) {
            for (int j = 0; j < constraint[i].getNumberOfSpecificConstraints(); ++j) {
                constraint[i].setLambda(j, val);
            }
        }
    }

    private static double[][] createUniformP(int[] alphLen) {
        int il2;
        double anz = 1.0;
        int counter1 = 0;
        int il1 = 1;
        for (il2 = 1; counter1 < alphLen.length && il2 < il2 * alphLen[counter1]; il2 *= alphLen[counter1++]) {
            anz *= (double)alphLen[counter1];
        }
        while (counter1 < alphLen.length && il1 < il1 * alphLen[counter1]) {
            anz *= (double)alphLen[counter1];
            il1 *= alphLen[counter1++];
        }
        if (counter1 != alphLen.length) {
            throw new IllegalArgumentException("Size of distribution too large.");
        }
        double[][] p = new double[il1][il2];
        double startvalue = 1.0 / anz;
        for (counter1 = 0; counter1 < il1; ++counter1) {
            Arrays.fill(p[counter1], startvalue);
        }
        return p;
    }

    public static double getExpPartOfProb(MEMConstraint[] constraints, int[] fulfilled, SequenceIterator sequence) {
        double p = 1.0;
        for (int counter = 0; counter < constraints.length; ++counter) {
            int idx = constraints[counter].satisfiesSpecificConstraint(sequence);
            p *= constraints[counter].getExpLambda(idx);
            if (fulfilled == null) continue;
            fulfilled[counter] = idx;
        }
        return p;
    }

    private static void check(double p) throws IllegalArgumentException {
        if (p <= 0.0) {
            throw new IllegalArgumentException("A marginal distribution became zero, please start the train-method again with a higher ESS.");
        }
    }

    private static Time getTimeObject() {
        Time t;
        try {
            t = new UserTime();
        }
        catch (Error e) {
            System.out.println("Warning: Could not load UserTime. Using RealTime instead.");
            t = new RealTime();
        }
        return t;
    }

    private static void out(SafeOutputStream sostream, int it, double time, double f, double delta) throws IOException {
        sostream.writeln(it + " \t" + time + " \t" + f + " \t" + delta);
    }

    private static int blockwiseGeneralizedIterativeScalingP(MEMConstraint[] constraints, double Z, int[] alphLen, SequenceIterator sequence, TerminationCondition mode, SafeOutputStream sostream) throws IOException, IllegalArgumentException {
        double psi_old;
        int counter2;
        int counter1;
        double log_Z;
        double[][] p = MEMTools.createUniformP(alphLen);
        int il1 = p.length;
        int il2 = p[0].length;
        int iterations = 0;
        int c = constraints.length - 1;
        double psi_new = log_Z = Math.log(Z);
        double[] help_now = new double[constraints[0].getNumberOfSpecificConstraints()];
        Time t = MEMTools.getTimeObject();
        MEMTools.out(sostream, 0, 0.0, psi_new, 0.0);
        sequence.reset();
        for (counter1 = 0; counter1 < il1; ++counter1) {
            for (counter2 = 0; counter2 < il2; ++counter2) {
                int n = constraints[0].satisfiesSpecificConstraint(sequence);
                help_now[n] = help_now[n] + p[counter1][counter2];
                sequence.next();
            }
        }
        do {
            double[] help_next;
            for (int counter3 = 0; counter3 < c; ++counter3) {
                for (counter1 = 0; counter1 < help_now.length; ++counter1) {
                    MEMTools.check(help_now[counter1]);
                    help_now[counter1] = constraints[counter3].getFreq(counter1) / help_now[counter1];
                    constraints[counter3].multiplyExpLambdaWith(counter1, help_now[counter1]);
                }
                sequence.reset();
                help_next = new double[constraints[counter3 + 1].getNumberOfSpecificConstraints()];
                for (counter1 = 0; counter1 < il1; ++counter1) {
                    for (counter2 = 0; counter2 < il2; ++counter2) {
                        double[] dArray = p[counter1];
                        int n = counter2;
                        dArray[n] = dArray[n] * help_now[constraints[counter3].satisfiesSpecificConstraint(sequence)];
                        int n2 = constraints[counter3 + 1].satisfiesSpecificConstraint(sequence);
                        help_next[n2] = help_next[n2] + p[counter1][counter2];
                        sequence.next();
                    }
                }
                help_now = help_next;
            }
            for (counter1 = 0; counter1 < help_now.length; ++counter1) {
                MEMTools.check(help_now[counter1]);
                help_now[counter1] = constraints[c].getFreq(counter1) / help_now[counter1];
                constraints[c].multiplyExpLambdaWith(counter1, help_now[counter1]);
            }
            help_next = new double[constraints[0].getNumberOfSpecificConstraints()];
            sequence.reset();
            for (counter1 = 0; counter1 < il1; ++counter1) {
                for (counter2 = 0; counter2 < il2; ++counter2) {
                    double[] dArray = p[counter1];
                    int n = counter2;
                    dArray[n] = dArray[n] * help_now[constraints[c].satisfiesSpecificConstraint(sequence)];
                    int n3 = constraints[0].satisfiesSpecificConstraint(sequence);
                    help_next[n3] = help_next[n3] + p[counter1][counter2];
                    sequence.next();
                }
            }
            help_now = help_next;
            psi_old = psi_new;
            psi_new = log_Z;
            for (counter1 = 0; counter1 < constraints.length; ++counter1) {
                for (counter2 = 0; counter2 < constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    psi_new -= constraints[counter1].getLambda(counter2) * constraints[counter1].getFreq(counter2);
                }
            }
            MEMTools.out(sostream, ++iterations, t.getElapsedTime(), psi_new, psi_old - psi_new);
        } while (mode.doNextIteration(iterations, psi_old, psi_new, null, null, 0.0, t));
        return iterations;
    }

    private static int blockwiseGeneralizedIterativeScaling(MEMConstraint[] constraints, double Z, SequenceIterator sequence, TerminationCondition mode, SafeOutputStream sostream) throws IOException, IllegalArgumentException {
        double psi_old;
        double log_Z;
        int iterations = 0;
        int c = constraints.length - 1;
        double psi_new = log_Z = Math.log(Z);
        double[] help_now = new double[constraints[0].getNumberOfSpecificConstraints()];
        Time t = MEMTools.getTimeObject();
        MEMTools.out(sostream, 0, 0.0, psi_new, 0.0);
        do {
            int counter1;
            int counter2;
            for (counter2 = 0; counter2 <= c; ++counter2) {
                sequence.reset();
                help_now = new double[constraints[counter2].getNumberOfSpecificConstraints()];
                do {
                    int n = constraints[counter2].satisfiesSpecificConstraint(sequence);
                    help_now[n] = help_now[n] + MEMTools.getExpPartOfProb(constraints, null, sequence);
                } while (sequence.next());
                for (counter1 = 0; counter1 < help_now.length; ++counter1) {
                    int n = counter1;
                    help_now[n] = help_now[n] / Z;
                    MEMTools.check(help_now[counter1]);
                    constraints[counter2].multiplyExpLambdaWith(counter1, constraints[counter2].getFreq(counter1) / help_now[counter1]);
                }
            }
            psi_old = psi_new;
            psi_new = log_Z;
            for (counter1 = 0; counter1 < constraints.length; ++counter1) {
                for (counter2 = 0; counter2 < constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    psi_new -= constraints[counter1].getLambda(counter2) * constraints[counter1].getFreq(counter2);
                }
            }
            MEMTools.out(sostream, ++iterations, t.getElapsedTime(), psi_new, psi_old - psi_new);
        } while (mode.doNextIteration(iterations, psi_old, psi_new, null, null, 0.0, t));
        return iterations;
    }

    private static int generalizedIterativeScaling(MEMConstraint[] constraints, double Z, SequenceIterator sequence, TerminationCondition mode, SafeOutputStream sostream) throws IOException, IllegalArgumentException {
        double psi_old;
        double p;
        int counter1;
        int iterations = 0;
        int n = constraints.length;
        double psi_new = Math.log(Z);
        double[][] adjust = new double[n][];
        for (counter1 = 0; counter1 < n; ++counter1) {
            adjust[counter1] = new double[constraints[counter1].getNumberOfSpecificConstraints()];
        }
        int[] fulfilled = new int[constraints.length];
        sequence.reset();
        Time t = MEMTools.getTimeObject();
        MEMTools.out(sostream, 0, 0.0, psi_new, 0.0);
        do {
            p = MEMTools.getExpPartOfProb(constraints, fulfilled, sequence);
            for (counter1 = 0; counter1 < n; ++counter1) {
                double[] dArray = adjust[counter1];
                int n2 = fulfilled[counter1];
                dArray[n2] = dArray[n2] + p;
            }
        } while (sequence.next());
        do {
            int counter2;
            for (counter1 = 0; counter1 < n; ++counter1) {
                for (counter2 = 0; counter2 < adjust[counter1].length; ++counter2) {
                    double[] dArray = adjust[counter1];
                    int n3 = counter2;
                    dArray[n3] = dArray[n3] / Z;
                    MEMTools.check(adjust[counter1][counter2]);
                    constraints[counter1].multiplyExpLambdaWith(counter2, Math.exp(Math.log(constraints[counter1].getFreq(counter2) / adjust[counter1][counter2]) / (double)n));
                    adjust[counter1][counter2] = 0.0;
                }
            }
            Z = 0.0;
            sequence.reset();
            do {
                p = MEMTools.getExpPartOfProb(constraints, fulfilled, sequence);
                Z += p;
                for (counter1 = 0; counter1 < n; ++counter1) {
                    double[] dArray = adjust[counter1];
                    int n4 = fulfilled[counter1];
                    dArray[n4] = dArray[n4] + p;
                }
            } while (sequence.next());
            psi_old = psi_new;
            psi_new = Math.log(Z);
            for (counter1 = 0; counter1 < constraints.length; ++counter1) {
                for (counter2 = 0; counter2 < constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    psi_new -= constraints[counter1].getLambda(counter2) * constraints[counter1].getFreq(counter2);
                }
            }
            MEMTools.out(sostream, ++iterations, t.getElapsedTime(), psi_new, psi_old - psi_new);
        } while (mode.doNextIteration(iterations, psi_old, psi_new, null, null, 0.0, t));
        return iterations;
    }

    private static int sequentialGeneralizedIterativeScalingP(MEMConstraint[] constraints, double Z, int[] alphLen, SequenceIterator sequence, TerminationCondition mode, SafeOutputStream sostream) throws IOException, IllegalArgumentException {
        double psi_old;
        double[][] p = MEMTools.createUniformP(alphLen);
        int il1 = p.length;
        int il2 = p[0].length;
        int iterations = 0;
        double psi_new = Math.log(Z);
        Time t = MEMTools.getTimeObject();
        MEMTools.out(sostream, 0, 0.0, psi_new, 0.0);
        do {
            int counter2;
            int counter1;
            for (int counter4 = 0; counter4 < constraints.length; ++counter4) {
                for (int counter3 = 0; counter3 < constraints[counter4].getNumberOfSpecificConstraints(); ++counter3) {
                    double help = 0.0;
                    sequence.reset();
                    for (counter1 = 0; counter1 < il1; ++counter1) {
                        for (counter2 = 0; counter2 < il2; ++counter2) {
                            if (constraints[counter4].satisfiesSpecificConstraint(sequence) == counter3) {
                                help += p[counter1][counter2];
                            }
                            sequence.next();
                        }
                    }
                    MEMTools.check(help);
                    double adjust_if = constraints[counter4].getFreq(counter3) / help;
                    double adjust_else = (1.0 - constraints[counter4].getFreq(counter3)) / (1.0 - help);
                    constraints[counter4].multiplyExpLambdaWith(counter3, adjust_if * (1.0 - help) / (1.0 - constraints[counter4].getFreq(counter3)));
                    Z *= (1.0 - help) / (1.0 - constraints[counter4].getFreq(counter3));
                    sequence.reset();
                    for (counter1 = 0; counter1 < il1; ++counter1) {
                        for (counter2 = 0; counter2 < il2; ++counter2) {
                            if (constraints[counter4].satisfiesSpecificConstraint(sequence) == counter3) {
                                double[] dArray = p[counter1];
                                int n = counter2;
                                dArray[n] = dArray[n] * adjust_if;
                            } else {
                                double[] dArray = p[counter1];
                                int n = counter2;
                                dArray[n] = dArray[n] * adjust_else;
                            }
                            sequence.next();
                        }
                    }
                }
            }
            psi_old = psi_new;
            psi_new = Math.log(Z);
            for (counter1 = 0; counter1 < constraints.length; ++counter1) {
                for (counter2 = 0; counter2 < constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    psi_new -= constraints[counter1].getExpLambda(counter2) * constraints[counter1].getFreq(counter2);
                }
            }
            MEMTools.out(sostream, ++iterations, t.getElapsedTime(), psi_new, psi_old - psi_new);
        } while (mode.doNextIteration(iterations, psi_old, psi_new, null, null, 0.0, t));
        return iterations;
    }

    private static int sequentialGeneralizedIterativeScaling(MEMConstraint[] constraints, double Z, SequenceIterator sequence, TerminationCondition mode, SafeOutputStream sostream) throws IOException, IllegalArgumentException {
        double psi_old;
        int iterations = 0;
        double psi_new = Math.log(Z);
        Time t = MEMTools.getTimeObject();
        MEMTools.out(sostream, 0, 0.0, psi_new, 0.0);
        do {
            int counter2;
            for (counter2 = 0; counter2 < constraints.length; ++counter2) {
                for (int counter3 = 0; counter3 < constraints[counter2].getNumberOfSpecificConstraints(); ++counter3) {
                    boolean isCorrect;
                    int pos = constraints[counter2].getCorrectedPosition(0);
                    double help = 0.0;
                    sequence.reset();
                    do {
                        if (constraints[counter2].satisfiesSpecificConstraint(sequence) == counter3) {
                            help += MEMTools.getExpPartOfProb(constraints, null, sequence);
                            isCorrect = sequence.next();
                            continue;
                        }
                        isCorrect = sequence.skip(pos);
                    } while (isCorrect);
                    MEMTools.check(help /= Z);
                    constraints[counter2].multiplyExpLambdaWith(counter3, constraints[counter2].getFreq(counter3) * (1.0 - help) / (help * (1.0 - constraints[counter2].getFreq(counter3))));
                    Z *= (1.0 - help) / (1.0 - constraints[counter2].getFreq(counter3));
                }
            }
            psi_old = psi_new;
            psi_new = Math.log(Z);
            for (int counter1 = 0; counter1 < constraints.length; ++counter1) {
                for (counter2 = 0; counter2 < constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    psi_new -= constraints[counter1].getExpLambda(counter2) * constraints[counter1].getFreq(counter2);
                }
            }
            MEMTools.out(sostream, ++iterations, t.getElapsedTime(), psi_new, psi_old - psi_new);
        } while (mode.doNextIteration(iterations, psi_old, psi_new, null, null, 0.0, t));
        return iterations;
    }

    public static class DualFunction
    extends DifferentiableFunction {
        private int n;
        private SequenceIterator it;
        private int[] shortcut;
        private MEMConstraint[] constraints;
        private double Z;

        public DualFunction(SequenceIterator it, MEMConstraint[] constraints) {
            this.it = it;
            this.constraints = constraints;
            this.shortcut = new int[constraints.length];
            this.shortcut[0] = 0;
            this.n = constraints[0].getNumberOfSpecificConstraints();
            for (int i = 1; i < constraints.length; ++i) {
                this.shortcut[i] = this.shortcut[i - 1] + constraints[i - 1].getNumberOfSpecificConstraints();
                this.n += constraints[i].getNumberOfSpecificConstraints();
            }
        }

        @Override
        public double evaluateFunction(double[] x) throws DimensionException {
            if (x == null || x.length != this.getDimensionOfScope()) {
                if (x != null) {
                    throw new DimensionException(x.length, this.n);
                }
                throw new DimensionException(0, this.n);
            }
            double[] y = this.exp(x);
            double erg = 0.0;
            this.it.reset();
            do {
                erg += this.getExpPartOfProb(y);
            } while (this.it.next());
            erg = Math.log(erg);
            for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                for (int counter2 = 0; counter2 < this.constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    erg -= this.constraints[counter1].getFreq(counter2) * x[this.shortcut[counter1] + counter2];
                }
            }
            return erg;
        }

        @Override
        public double[] evaluateGradientOfFunction(double[] x) throws DimensionException {
            int counter1;
            double[] erg = new double[this.n];
            double[] y = this.exp(x);
            double Z = 0.0;
            int[] fulfilled = new int[this.constraints.length];
            this.it.reset();
            do {
                double p = this.getExpPartOfProb(y, fulfilled);
                Z += p;
                for (counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                    int n = fulfilled[counter1];
                    erg[n] = erg[n] + p;
                }
            } while (this.it.next());
            for (counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                for (int counter2 = 0; counter2 < this.constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    erg[this.shortcut[counter1] + counter2] = erg[this.shortcut[counter1] + counter2] / Z - this.constraints[counter1].getFreq(counter2);
                }
            }
            return erg;
        }

        @Override
        public int getDimensionOfScope() {
            return this.n;
        }

        public void setValues(double[] x) {
            double[] y = this.exp(x);
            for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                for (int counter2 = 0; counter2 < this.constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                    this.constraints[counter1].setExpLambda(counter2, y[this.shortcut[counter1] + counter2]);
                }
            }
            this.Z = 0.0;
            this.it.reset();
            do {
                this.Z += this.getExpPartOfProb(y);
            } while (this.it.next());
        }

        private double getExpPartOfProb(double[] x) {
            double erg = 1.0;
            for (int counter = 0; counter < this.constraints.length; ++counter) {
                erg *= x[this.shortcut[counter] + this.constraints[counter].satisfiesSpecificConstraint(this.it)];
            }
            return erg;
        }

        private double getExpPartOfProb(double[] x, int[] fulfilled) {
            double erg = 1.0;
            for (int counter = 0; counter < this.constraints.length; ++counter) {
                fulfilled[counter] = this.shortcut[counter] + this.constraints[counter].satisfiesSpecificConstraint(this.it);
                erg *= x[fulfilled[counter]];
            }
            return erg;
        }

        private double[] exp(double[] x) {
            double[] expX = new double[this.n];
            for (int counter = 0; counter < this.n; ++counter) {
                expX[counter] = Math.exp(x[counter]);
            }
            return expX;
        }

        private double getZ() {
            return this.Z;
        }
    }
}

