/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.DataType;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures.BTMutualInformation;

public class PMMMutualInformation
extends Measure {
    public PMMMutualInformation(byte order, BTMutualInformation.DataSource clazz, double[] ess) throws Exception {
        this(new PMMMutualInformationParameterSet(order, clazz, ess));
    }

    public PMMMutualInformation(PMMMutualInformationParameterSet parameters) throws Exception {
        super(parameters);
    }

    public PMMMutualInformation(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    @Override
    public String getXMLTag() {
        return "pmmMutualInformation";
    }

    @Override
    public String getInstanceName() {
        PMMMutualInformationParameterSet ps = (PMMMutualInformationParameterSet)this.parameters;
        String str = "Permuted Markov model of order " + ps.getOrder() + " with mutual information of";
        if (ps.getClazz() == BTMutualInformation.DataSource.FG) {
            return str + " foreground";
        }
        if (ps.getClazz() == BTMutualInformation.DataSource.BG) {
            return str + " background";
        }
        return str + " foreground and background";
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        DataSet data = null;
        double[] weights = null;
        double ess2 = 0.0;
        PMMMutualInformationParameterSet ps = (PMMMutualInformationParameterSet)this.parameters;
        BTMutualInformation.DataSource clazz = ps.getClazz();
        double[] ess = ps.getEss();
        byte order = ps.getOrder();
        if (clazz == BTMutualInformation.DataSource.FG) {
            data = fg;
            weights = weightsFg;
            ess2 = ess[0];
        } else if (clazz == BTMutualInformation.DataSource.BG) {
            data = bg;
            weights = weightsBg;
            ess2 = ess[1];
        } else {
            data = DataSet.union(fg, bg);
            weights = PMMMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = ess[0] + ess[1];
        }
        SymmetricTensor t = new SymmetricTensor(length, order);
        PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatistics(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        if (order == 2) {
            PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatisticsOrderTwo(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMMutualInformation.toParents(o, order);
    }

    public static class PMMMutualInformationParameterSet
    extends Measure.MeasureParameterSet {
        public PMMMutualInformationParameterSet() throws ParameterException {
            super((Class<? extends Measure>)BTMutualInformation.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true)});
            this.parameters.add(new Parameter[]{new EnumParameter(BTMutualInformation.DataSource.class, "The data used to compute mutual information.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BYTE, "Order", "The order of the permuted Markov model. Only 1 or 2 allowed.", true)});
        }

        public PMMMutualInformationParameterSet(byte order, BTMutualInformation.DataSource clazz, double[] ess) throws Exception {
            this();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue((Object)clazz);
            ((Parameter)this.parameters.get(3)).setValue(order);
        }

        public PMMMutualInformationParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public BTMutualInformation.DataSource getClazz() {
            return (BTMutualInformation.DataSource)((EnumParameter)this.parameters.get(2)).getValue();
        }

        public byte getOrder() {
            return (Byte)((Parameter)this.parameters.get(3)).getValue();
        }

        @Override
        public String getInstanceComment() {
            return "Permuted Markov model - mutual information";
        }

        @Override
        public String getInstanceName() {
            return "Build a permuted Markov model using mutual information as structure measure.";
        }
    }
}

