/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.AnnotatedEntity;
import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;

public abstract class Parameter
extends AnnotatedEntity
implements Cloneable {
    protected ParameterSet parent;

    public Parameter(String name, String comment, DataType type) {
        super(name, comment, type);
    }

    public Parameter(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public abstract boolean isRequired();

    public abstract boolean checkValue(Object var1);

    public abstract void setValue(Object var1) throws SimpleParameter.IllegalValueException;

    public abstract boolean hasDefaultOrIsSet();

    public abstract boolean isSet();

    public abstract boolean isAtomic();

    public abstract String getErrorMessage();

    public abstract void reset();

    public Parameter clone() throws CloneNotSupportedException {
        Parameter clone = (Parameter)super.clone();
        clone.parent = null;
        return clone;
    }

    public abstract void setDefault(Object var1) throws Exception;

    public void setParent(ParameterSet parent) {
        this.parent = parent;
    }

    public ParameterSet getParent() {
        return this.parent;
    }

    @Override
    protected void extractFurtherInfos(StringBuffer source) throws NonParsableException {
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
    }

    public boolean isComparable(Parameter p) {
        boolean res;
        boolean bl = res = this.getClass().equals(p.getClass()) && this.getDatatype() == p.getDatatype() && this.getName().equals(p.getName()) && this.getComment().equals(p.getComment());
        if (res && this.getDatatype() == DataType.PARAMETERSET) {
            return ((ParameterSet)this.getValue()).isComparable((ParameterSet)p.getValue());
        }
        return res;
    }
}

