/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.utils.galaxy.GalaxyAdaptor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class FileParameter
extends Parameter
implements GalaxyConvertible {
    private boolean required;
    private String mime;
    private FileRepresentation value;
    private FileRepresentation defaultValue;
    private boolean isSet;
    private String errorMessage;
    private ParameterValidator valid;

    @Override
    public FileParameter clone() throws CloneNotSupportedException {
        FileParameter clone = (FileParameter)super.clone();
        clone.value = this.value == null ? null : this.value.clone();
        clone.defaultValue = this.defaultValue == null ? null : this.defaultValue.clone();
        return clone;
    }

    public FileParameter(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public FileParameter(String name, String comment, String mime, boolean required) {
        super(name, comment, DataType.FILE);
        this.mime = mime;
        this.required = required;
    }

    public FileParameter(String name, String comment, String mime, boolean required, ParameterValidator validator) {
        this(name, comment, mime, required);
        this.valid = validator;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void reset() {
        this.value = null;
        this.isSet = false;
        this.errorMessage = null;
    }

    public FileRepresentation getFileContents() {
        return this.value;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value instanceof String) {
            value = new FileRepresentation((String)value);
        }
        if (this.valid != null) {
            if (this.valid.checkValue(value)) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = this.valid.getErrorMessage();
            return false;
        }
        if (value != null && value instanceof FileRepresentation) {
            FileRepresentation f = (FileRepresentation)value;
            if (f.getFilename() != null && f.getFilename().length() != 0 || f.getContent() != null && f.getContent().length() != 0) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "No file specified or file is empty.";
            return false;
        }
        this.errorMessage = "Value is no file or null.";
        return false;
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        if (defaultValue instanceof String) {
            defaultValue = new FileRepresentation((String)defaultValue);
        }
        if (!this.checkValue(defaultValue)) {
            throw new SimpleParameter.IllegalValueException(this.errorMessage);
        }
        this.defaultValue = (FileRepresentation)defaultValue;
        this.setValue(defaultValue);
        this.isSet = false;
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (value instanceof String) {
            value = new FileRepresentation((String)value);
        }
        if (!this.checkValue(value)) {
            throw new SimpleParameter.IllegalValueException(this.errorMessage);
        }
        this.value = (FileRepresentation)value;
        this.isSet = true;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getFilename();
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        return this.isSet();
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public String getXMLTag() {
        return "fileParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.mime, "mime");
        XMLParser.appendObjectWithTags(buf, this.required, "required");
        XMLParser.appendObjectWithTags(buf, this.isSet, "isSet");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.value, "value");
        XMLParser.appendObjectWithTags(buf, this.valid, "validator");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        super.extractFurtherInfos(buf);
        this.mime = XMLParser.extractObjectForTags(buf, "mime", String.class);
        this.required = XMLParser.extractObjectForTags(buf, "required", Boolean.TYPE);
        this.isSet = XMLParser.extractObjectForTags(buf, "isSet", Boolean.TYPE);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(buf, "errorMessage", String.class));
        this.value = XMLParser.extractObjectForTags(buf, "value", FileRepresentation.class);
        this.valid = XMLParser.extractObjectForTags(buf, "validator", ParameterValidator.class);
    }

    public String getAcceptedMimeType() {
        return this.mime;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"data\" format=\"" + this.mime + "\" name=\"" + namePrefix + "\" label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" value=\"" + (this.defaultValue == null ? "" : this.defaultValue) + "\" optional=\"" + !this.isRequired() + "\"");
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, "value");
        StringBuffer buf2 = new StringBuffer();
        buf2.append("${" + configPrefix + namePrefix + ".ext}");
        XMLParser.addTags(buf2, "extension");
        buf.append(buf2);
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    public String toString() {
        return this.name + " (" + this.comment + (this.defaultValue != null ? ", default = " + this.defaultValue.getFilename() : "") + (this.required ? "" : ", OPTIONAL") + ")\t= " + (this.value != null ? this.value.getFilename() : "null");
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer cont = XMLParser.extractForTag(command, namePrefix);
        try {
            String val = XMLParser.extractForTag(cont, "value").toString();
            String ext = XMLParser.extractForTag(cont, "extension").toString().trim();
            this.value = new FileRepresentation(val);
            this.value.setExtension(ext);
        }
        catch (NonParsableException e) {
            this.value = new FileRepresentation(cont.toString());
        }
        this.isSet = true;
    }

    public static class FileRepresentation
    implements Storable,
    Cloneable {
        private String filename;
        private String ext;
        private String content;

        public FileRepresentation(String filename, String content) {
            this.filename = filename;
            this.content = content;
            int idx = filename.lastIndexOf(46);
            if (idx >= 0) {
                this.ext = filename.substring(idx + 1);
            }
        }

        public FileRepresentation(String filename) {
            this.filename = filename;
            int idx = filename.lastIndexOf(46);
            if (idx >= 0) {
                this.ext = filename.substring(idx + 1);
            }
        }

        public FileRepresentation(StringBuffer buf) throws NonParsableException {
            this.fromXML(buf);
        }

        public FileRepresentation clone() throws CloneNotSupportedException {
            return (FileRepresentation)super.clone();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContent() {
            if (this.content == null && this.filename != null) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this.filename));
                    StringBuffer sb = new StringBuffer();
                    String str = "";
                    while ((str = reader.readLine()) != null) {
                        sb.append(reader.readLine());
                        sb.append("\n");
                    }
                    reader.close();
                    return sb.toString();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return this.content;
        }

        public void setExtension(String ext) {
            this.ext = ext;
        }

        public String getExtension() {
            return this.ext;
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = new StringBuffer();
            XMLParser.appendObjectWithTags(buf, this.filename, "filename");
            XMLParser.appendObjectWithTags(buf, this.content, "content");
            XMLParser.addTags(buf, "fileRepresentation");
            return buf;
        }

        private void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "fileRepresentation");
            this.filename = XMLParser.extractObjectForTags(representation, "filename", String.class);
            this.content = XMLParser.extractObjectForTags(representation, "content", String.class);
            int idx = this.filename.lastIndexOf(46);
            if (idx >= 0) {
                this.ext = this.filename.substring(idx + 1);
            }
        }
    }
}

