/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.DataType;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DiscreteAlphabet
extends Alphabet {
    private static final String XML_TAG = "DiscreteAlphabet";
    protected String[] alphabet;
    private Hashtable<String, Integer> hash;
    protected boolean caseInsensitive;
    private int longestCharacter;
    protected Alphabet.AlphabetParameterSet parameters;

    public DiscreteAlphabet(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        try {
            this.init(XMLParser.extractObjectForTags(xml, "symbols", String[].class), XMLParser.extractObjectForTags(xml, "caseInsensitive", Boolean.TYPE));
        }
        catch (Exception e) {
            NonParsableException n = new NonParsableException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public DiscreteAlphabet(DiscreteAlphabetParameterSet parameters) throws IllegalArgumentException, DoubleSymbolException {
        try {
            this.parameters = parameters.clone();
            String alphValue = (String)parameters.getParameterAt(0).getValue();
            boolean caseInsensitive = (Boolean)parameters.getParameterAt(1).getValue();
            StringTokenizer tok = new StringTokenizer(alphValue, " ");
            String[] vals = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                vals[i++] = tok.nextToken();
            }
            this.init(vals, caseInsensitive);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.getCause().getMessage());
        }
    }

    public Alphabet.AlphabetParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters.clone();
        }
        return new DiscreteAlphabetParameterSet((String[])this.alphabet.clone(), this.caseInsensitive);
    }

    private void init(String[] alphabet, boolean caseInsensitive) throws IllegalArgumentException, DoubleSymbolException {
        this.hash = new Hashtable(alphabet.length, 1.0f);
        this.alphabet = new String[alphabet.length];
        this.caseInsensitive = caseInsensitive;
        this.longestCharacter = 0;
        for (int i = 0; i < alphabet.length; ++i) {
            if (alphabet[i].length() == 0) {
                throw new IllegalArgumentException("\"\" can not be a symbol/character.");
            }
            if (alphabet[i].indexOf(" ") >= 0 || alphabet[i].indexOf("\t") >= 0) {
                throw new IllegalArgumentException("blanks and tabs can not be part of a symbol/character.");
            }
            if (this.hash.containsKey(caseInsensitive ? alphabet[i].toUpperCase() : alphabet[i])) {
                throw new DoubleSymbolException(caseInsensitive ? alphabet[i].toUpperCase() : alphabet[i]);
            }
            this.hash.put(caseInsensitive ? alphabet[i].toUpperCase() : alphabet[i], i);
            this.alphabet[i] = alphabet[i];
            if (this.longestCharacter >= alphabet[i].length()) continue;
            this.longestCharacter = alphabet[i].length();
        }
    }

    public DiscreteAlphabet(int min, int max) throws IllegalArgumentException {
        if (min > max) {
            throw new IllegalArgumentException("The maximal value has to be equal or greater than the minimal value.");
        }
        String[] alphabet = new String[max - min + 1];
        for (int i = min; i <= max; ++i) {
            alphabet[i - min] = "" + i;
        }
        try {
            this.init(alphabet, false);
        }
        catch (Exception doesNotHappen) {
            IllegalArgumentException i = new IllegalArgumentException(doesNotHappen.getCause());
            i.setStackTrace(doesNotHappen.getStackTrace());
            throw i;
        }
    }

    public DiscreteAlphabet(boolean caseInsensitive, String ... alphabet) throws DoubleSymbolException, IllegalArgumentException {
        this.init(alphabet, caseInsensitive);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(200);
        XMLParser.appendObjectWithTags(xml, this.alphabet, "symbols");
        XMLParser.appendObjectWithTags(xml, this.caseInsensitive, "caseInsensitive");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public int compareTo(Alphabet b) {
        int i;
        if (!this.getClass().equals(b.getClass())) {
            return this.getClass().getName().compareTo(b.getClass().getName());
        }
        if (b == this) {
            return 0;
        }
        DiscreteAlphabet a = (DiscreteAlphabet)b;
        if (a.alphabet.length != this.alphabet.length) {
            return a.alphabet.length - this.alphabet.length;
        }
        if (a.caseInsensitive != this.caseInsensitive) {
            return a.caseInsensitive ? -1 : 1;
        }
        if (this.caseInsensitive) {
            for (i = 0; i < this.alphabet.length && this.alphabet[i].equalsIgnoreCase(a.getSymbolAt(i)); ++i) {
            }
        } else {
            while (i < this.alphabet.length && this.alphabet[i].equals(a.getSymbolAt(i))) {
                ++i;
            }
        }
        if (i < this.alphabet.length) {
            return this.alphabet[i].compareTo(a.getSymbolAt(i));
        }
        return 0;
    }

    public int getCode(String symbol) throws WrongAlphabetException {
        Integer i;
        if (this.caseInsensitive) {
            symbol = symbol.toUpperCase();
        }
        if ((i = this.hash.get(symbol)) == null) {
            throw new WrongAlphabetException("Symbol \"" + symbol + "\" from input not defined in alphabet.");
        }
        return i;
    }

    public final int getMaximalSymbolLength() {
        return this.longestCharacter;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    public final String getSymbolAt(int i) {
        return this.alphabet[i];
    }

    public final boolean ignoresCase() {
        return this.caseInsensitive;
    }

    public final boolean isEncodedSymbol(int candidate) {
        return 0 <= candidate && candidate < this.alphabet.length;
    }

    public final boolean isSymbol(String candidat) {
        return this.hash.containsKey(this.caseInsensitive ? candidat.toUpperCase() : candidat);
    }

    @Override
    public final double length() {
        return this.alphabet.length;
    }

    @Override
    public String toString() {
        String erg = "{\"" + this.alphabet[0];
        for (int i = 1; i < this.alphabet.length; ++i) {
            erg = erg + "\", \"" + this.alphabet[i];
        }
        return erg + "\"}";
    }

    public static class DiscreteAlphabetParameterSet
    extends Alphabet.AlphabetParameterSet {
        protected DiscreteAlphabetParameterSet(Class<? extends DiscreteAlphabet> clazz) {
            super(clazz);
        }

        public DiscreteAlphabetParameterSet() throws ParameterException {
            this((Class<? extends DiscreteAlphabet>)DiscreteAlphabet.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "Values of the alphabet", "The possible values of the discrete alphabet.If the alphabet consists of single characters, e.g. A, C, G, and T, the values may be set as a single string, e.g. &quot;ACGT&quot;.If the alphabet consists of multi-character symbols, e.g. Gly, Asp, Ser,the symbols must be separated by spaces.", true)});
            this.parameters.add(new Parameter[]{new SelectionParameter(DataType.BOOLEAN, new String[]{"Case insensitive", "Case sensitive"}, new Boolean[]{true, false}, "Case insensitive", "Use the alphabet case insensitive", true)});
        }

        public DiscreteAlphabetParameterSet(String[] alphabet, boolean caseInsensitive) throws Exception {
            this();
            String alphString = "" + alphabet[0];
            for (int i = 1; i < alphabet.length; ++i) {
                alphString = alphString + " " + alphabet[i];
            }
            ((Parameter)this.parameters.get(0)).setValue(alphString);
            ((Parameter)this.parameters.get(1)).setValue(new String(caseInsensitive ? "Case insensitive" : "Case sensitive"));
        }

        public DiscreteAlphabetParameterSet(char[] alphabet, boolean caseInsensitive) throws Exception {
            this();
            String alphString = "" + alphabet[0];
            for (int i = 1; i < alphabet.length; ++i) {
                alphString = alphString + " " + alphabet[i];
            }
            ((Parameter)this.parameters.get(0)).setValue(alphString);
            ((Parameter)this.parameters.get(1)).setValue(new String(caseInsensitive ? "Case insensitive" : "Case sensitive"));
        }

        public DiscreteAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public String getInstanceComment() {
            return "An alphabet that consists of discrete values.";
        }
    }
}

