/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.AbstractNumericalTwoClassPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;

public class PositivePredictiveValueForFixedSensitivity
extends AbstractNumericalTwoClassPerformanceMeasure {
    public PositivePredictiveValueForFixedSensitivity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity for the positive predictive value.", true, new NumberValidator<Double>(0.0, 1.0), 0.95)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public PositivePredictiveValueForFixedSensitivity(double sensitivity) throws Exception {
        this();
        this.getParameterAt(0).setValue(sensitivity);
    }

    public PositivePredictiveValueForFixedSensitivity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "Positive predictive value for fixed sensitivity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        double sensitivity = (Double)this.getParameterAt(0).getValue();
        double threshold = PositivePredictiveValueForFixedSensitivity.findThreshold(sortedScoresClass0, sortedScoresClass1, weightsClass0, 1.0 - sensitivity, false);
        int j = PositivePredictiveValueForFixedSensitivity.findSplitIndex(sortedScoresClass0, threshold);
        double tp = weightsClass0 == null ? (double)(sortedScoresClass0.length - j) : ToolBox.sum(j, sortedScoresClass0.length, weightsClass0);
        int i = PositivePredictiveValueForFixedSensitivity.findSplitIndex(sortedScoresClass1, threshold);
        double fp = weightsClass1 == null ? (double)(sortedScoresClass1.length - i) : ToolBox.sum(i, sortedScoresClass1.length, weightsClass1);
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + sensitivity, "", tp / (tp + fp)), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + sensitivity, "", threshold)}});
    }
}

