/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.AbstractNumericalTwoClassPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;

public class FalsePositiveRateForFixedSensitivity
extends AbstractNumericalTwoClassPerformanceMeasure
implements NumericalPerformanceMeasure {
    public FalsePositiveRateForFixedSensitivity() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Sensitivity", "The fixed sensitivity for the false positive rate.", true, new NumberValidator<Double>(0.0, 1.0), 0.95)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public FalsePositiveRateForFixedSensitivity(double sensitivity) throws Exception {
        this();
        this.getParameterAt(0).setValue(sensitivity);
    }

    public FalsePositiveRateForFixedSensitivity(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "False positive rate for fixed sensitivity";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        double fpr;
        double sensitivity = (Double)this.getParameterAt(0).getValue();
        double threshold = FalsePositiveRateForFixedSensitivity.findThreshold(sortedScoresClass0, sortedScoresClass1, weightsClass0, 1.0 - sensitivity, false);
        int i = FalsePositiveRateForFixedSensitivity.findSplitIndex(sortedScoresClass1, threshold);
        int d = sortedScoresClass1.length;
        if (weightsClass1 == null) {
            fpr = (double)(d - i) / (double)d;
        } else {
            fpr = ToolBox.sum(i, d, weightsClass1);
            fpr /= ToolBox.sum(0, i, weightsClass1) + fpr;
        }
        return new NumericalResultSet(new NumericalResult[][]{{new NumericalResult(this.getName() + " of " + sensitivity, "", fpr), new NumericalResult("Threshold for the " + this.getName().toLowerCase() + " of " + sensitivity, "", threshold)}});
    }
}

