/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;

public abstract class AbstractTwoClassPerformanceMeasure
extends AbstractPerformanceMeasure {
    protected AbstractTwoClassPerformanceMeasure() {
    }

    protected AbstractTwoClassPerformanceMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores, double[][] weights) {
        if (classSpecificScores.length != 2) {
            throw new RuntimeException("Only two classes possible for " + this.getName());
        }
        double[][] classificationScores = new double[2][];
        for (int i = 0; i < classSpecificScores.length; ++i) {
            classificationScores[i] = new double[classSpecificScores[i].length];
            for (int j = 0; j < classSpecificScores[i].length; ++j) {
                if (classSpecificScores[i][j].length != 2) {
                    throw new RuntimeException("Only two classes possible for " + this.getName());
                }
                classificationScores[i][j] = classSpecificScores[i][j][0] - classSpecificScores[i][j][1];
            }
            ToolBox.sortAlongWith(classificationScores[i], new double[][]{weights == null ? null : weights[i]});
        }
        if (weights != null) {
            return this.compute(classificationScores[0], weights[0], classificationScores[1], weights[1]);
        }
        return this.compute(classificationScores[0], null, classificationScores[1], null);
    }

    @Override
    public final int getAllowedNumberOfClasses() {
        return 2;
    }
}

