/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior;

import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;

public abstract class SeparateLogPrior
extends LogPrior
implements Cloneable {
    protected DifferentiableStatisticalModel[] funs;
    protected double[] vars;
    protected double[] classVars;
    protected double[] classMus;
    protected boolean freeParameters;

    public SeparateLogPrior(double[] vars, double[] classVars, double[] classMus) {
        this.vars = vars;
        this.classMus = classMus;
        this.classVars = classVars;
    }

    public SeparateLogPrior(StringBuffer xml) throws NonParsableException {
        StringBuffer content = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.vars = XMLParser.extractObjectForTags(content, "variances", double[].class);
        this.classVars = XMLParser.extractObjectForTags(content, "classVariances", double[].class);
        this.classMus = XMLParser.extractObjectForTags(content, "classMeans", double[].class);
        this.unset();
    }

    @Override
    public void set(boolean freeParameters, DifferentiableSequenceScore ... funs) throws Exception {
        this.funs = new DifferentiableStatisticalModel[funs.length];
        for (int i = 0; i < funs.length; ++i) {
            if (!(funs[i] instanceof DifferentiableStatisticalModel)) {
                throw new Exception("Only DirectedGraphicalModels allowed.");
            }
            this.funs[i] = (DifferentiableStatisticalModel)funs[i];
        }
        this.freeParameters = freeParameters;
        this.unset();
    }

    protected abstract void unset();

    @Override
    public SeparateLogPrior getNewInstance() throws CloneNotSupportedException {
        SeparateLogPrior clone = (SeparateLogPrior)super.clone();
        clone.vars = (double[])this.vars.clone();
        clone.unset();
        clone.funs = null;
        clone.classVars = (double[])this.classVars.clone();
        clone.classMus = (double[])this.classMus.clone();
        return clone;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(20 * (this.vars.length + this.classVars.length + this.classMus.length) + 1000);
        XMLParser.appendObjectWithTags(xml, this.vars, "variances");
        XMLParser.appendObjectWithTags(xml, this.classVars, "classVariances");
        XMLParser.appendObjectWithTags(xml, this.classMus, "classMeans");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

