/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix;

import de.jstacs.DataType;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.ScoreClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.ScoreClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class GenDisMixClassifierParameterSet
extends ScoreClassifierParameterSet {
    public GenDisMixClassifierParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public GenDisMixClassifierParameterSet(AlphabetContainer alphabet, int length, byte algo, double eps, double lineps, double startD, boolean free, OptimizableFunction.KindOfParameter kind, boolean norm, int threads) throws Exception {
        this(GenDisMixClassifier.class, alphabet, length, algo, eps, lineps, startD, free, kind, norm, threads);
    }

    protected GenDisMixClassifierParameterSet(Class<? extends ScoreClassifier> instanceClass, AlphabetContainer alphabet, int length, byte algo, double eps, double lineps, double startD, boolean free, OptimizableFunction.KindOfParameter kind, boolean norm, int threads) throws Exception {
        super(instanceClass, alphabet, length, algo, eps, lineps, startD, free, kind);
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "Normalize", "If true the conditional likelihood will be normalized to the number of data sets.", true, new Boolean(true))});
        this.parameters.add(GenDisMixClassifierParameterSet.getThreadsParameter());
        this.getParameterForName("Normalize").setValue(norm);
        this.setNumberOfThreads(threads);
    }

    private static Parameter getThreadsParameter() {
        try {
            return new SimpleParameter(DataType.INT, "Threads", "The number of threads that is used during an optimization.", true, new NumberValidator<Integer>(1, 128), 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean shouldBeNormalized() {
        return (Boolean)this.getParameterForName("Normalize").getValue();
    }

    public int getNumberOfThreads() {
        return (Integer)this.getParameterForName("Threads").getValue();
    }

    public void setNumberOfThreads(int threads) throws SimpleParameter.IllegalValueException {
        this.getParameterForName("Threads").setValue(threads);
    }
}

