/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class SmallStepCondition
extends AbstractTerminationCondition {
    private double epsilon;

    public SmallStepCondition(double epsilon) throws Exception {
        this(new SmallStepConditionParameterSet(epsilon));
    }

    public SmallStepCondition(SmallStepConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.epsilon = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "SmallStepCondition";
    }

    public SmallStepCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        double s = 0.0;
        for (int counter = 0; counter < direction.length; ++counter) {
            s += direction[counter] * direction[counter];
        }
        return s * (alpha * alpha) >= this.epsilon;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    public static class SmallStepConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public SmallStepConditionParameterSet() throws SimpleParameter.DatatypeNotValidException {
            super((Class<? extends AbstractTerminationCondition>)SmallStepCondition.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "epsilon", "the epsilon for the size of the step used for deciding whether to stop the algorithm or not", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE)))});
        }

        public SmallStepConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public SmallStepConditionParameterSet(double eps) throws IllegalArgumentException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
            this();
            this.getParameterAt(0).setValue(eps);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the SmallStepCondition";
        }

        @Override
        public String getInstanceName() {
            return "SmallStepConditionParameterSet";
        }
    }
}

