/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class SmallDifferenceOfFunctionEvaluationsCondition
extends AbstractTerminationCondition {
    private double eps;

    public SmallDifferenceOfFunctionEvaluationsCondition(double epsilon) throws Exception {
        this(new SmallDifferenceOfFunctionEvaluationsConditionParameterSet(epsilon));
    }

    public SmallDifferenceOfFunctionEvaluationsCondition(SmallDifferenceOfFunctionEvaluationsConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.eps = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "SmallDifferenceOfFunctionEvaluationsCondition";
    }

    public SmallDifferenceOfFunctionEvaluationsCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return this.eps <= Math.abs(f_last - f_current);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public static class SmallDifferenceOfFunctionEvaluationsConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet() {
            super((Class<? extends AbstractTerminationCondition>)SmallDifferenceOfFunctionEvaluationsCondition.class);
            try {
                this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "epsilon", "the epsilon for the difference of function evaluations used for deciding whether to stop the algorithm or not", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE), 1.0E-6)});
            }
            catch (ParameterException doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
        }

        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public SmallDifferenceOfFunctionEvaluationsConditionParameterSet(double eps) throws ParameterException {
            this();
            this.getParameterAt(0).setValue(eps);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the SmallDifferenceOfFunctionEvaluationsCondition";
        }

        @Override
        public String getInstanceName() {
            return "SmallDifferenceOfFunctionEvaluationsConditionParameterSet";
        }
    }
}

