/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs.tensor;

import de.jstacs.algorithms.graphs.tensor.Tensor;
import java.util.Arrays;

public class AsymmetricTensor
extends Tensor {
    protected double[][][] tensor;

    public AsymmetricTensor(int n, byte k) {
        super(n, k);
        this.tensor = new double[k + 1][n][];
        byte i = 0;
        do {
            int l = (int)Math.pow(n, i);
            for (int j = 0; j < n; ++j) {
                this.tensor[i][j] = new double[l];
                Arrays.fill(this.tensor[i][j], Double.NEGATIVE_INFINITY);
            }
        } while (++i <= k);
    }

    public AsymmetricTensor(double[][][] asym_tensor, int n, byte k) throws IllegalArgumentException {
        super(n, (byte)k);
        this.tensor = new double[k + 1][n][];
        for (int i = 0; i <= k; ++i) {
            for (int l = 0; l < n; ++l) {
                if (asym_tensor[i][l].length != this.powers[i]) {
                    throw new IllegalArgumentException("The given tensor has not the correct dimension.");
                }
                this.tensor[i][l] = (double[])asym_tensor[i][l].clone();
            }
        }
    }

    @Override
    public int[] getMaximalEdgeFor(byte k, int child, int ... parents) {
        int[] erg = new int[k + 1];
        System.arraycopy(parents, 0, erg, 0, k);
        erg[k] = child;
        return erg;
    }

    @Override
    public double getRootValue(int child) {
        return this.tensor[0][child][0];
    }

    @Override
    public double getValue(byte k, int child, int ... parents) {
        return this.tensor[k][child][this.getAsymIndex(child, parents, k)];
    }

    @Override
    public void setRootValue(int child, double val) {
        this.tensor[0][child][0] = val;
    }

    @Override
    public void setValue(byte k, double val, int child, int ... parents) {
        this.tensor[k][child][this.getAsymIndex((int)child, (int[])parents, (byte)k)] = val;
    }

    @Override
    public void resetValue(byte k, int child, int ... parents) {
        this.tensor[k][child][this.getAsymIndex((int)child, (int[])parents, (byte)k)] = Double.NEGATIVE_INFINITY;
    }
}

