/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

import de.jstacs.algorithms.graphs.tensor.AsymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import java.util.Arrays;

public class DAG {
    public static int[] computeMaximalHP(Tensor score) {
        int index;
        int counter;
        int i;
        int[] nodes;
        Object pre;
        Object best;
        int k = score.getOrder();
        byte g = (byte)(k - 1);
        int L = score.getNumberOfNodes();
        int numOfSubsets = (int)Math.pow(2.0, L);
        int anz = 1;
        int[] copy = new int[L];
        int[] help = new int[k];
        int[] perm = new int[k];
        int[] powers = new int[k + 1];
        powers[0] = 1;
        do {
            powers[anz] = powers[anz - 1] * L;
        } while (++anz <= k);
        if (k == 1) {
            best = new double[L][numOfSubsets];
            pre = new int[L][numOfSubsets];
        } else {
            best = new double[powers[k]][];
            pre = new int[powers[k]][];
            nodes = new int[k + 1];
            for (anz = 0; anz < k; ++anz) {
                nodes[anz] = (byte)(k - anz - 1);
            }
            do {
                System.arraycopy(nodes, 0, help, 0, k);
                Arrays.sort(help);
                anz = 1;
                i = nodes[0];
                while (anz < k && help[anz] != help[anz - 1]) {
                    i += nodes[anz] * powers[anz++];
                }
                if (anz == k) {
                    best[i] = new double[numOfSubsets];
                    pre[i] = new int[numOfSubsets];
                }
                i = 0;
                while (nodes[i] == L - 1) {
                    nodes[i] = 0;
                    ++i;
                }
                int n = i;
                nodes[n] = nodes[n] + 1;
            } while (nodes[k] == 0);
        }
        nodes = new int[L];
        for (counter = 0; counter < L; ++counter) {
            nodes[counter] = counter;
        }
        help = new int[k];
        i = 0;
        while (true) {
            System.arraycopy(nodes, 0, copy, 0, L);
            index = 0;
            anz = 0;
            for (i = 0; i < k; ++i) {
                counter = help[i];
                perm[i] = copy[counter];
                anz += 1 << perm[i];
                index += perm[i] * powers[g - i];
                while (counter < L - 1) {
                    copy[counter++] = copy[counter];
                }
            }
            best[index][anz] = DAG.getScoreForPath(score, k, (byte)k, perm);
            pre[index][anz] = -1;
            i = g;
            while (i >= 0 && help[i] == L - i - 1) {
                help[i--] = 0;
            }
            if (i < 0) break;
            int n = i;
            help[n] = help[n] + 1;
        }
        block10: for (int l = (int)(k + 1); l <= L; ++l) {
            anz = 0;
            for (counter = 0; counter < l; ++counter) {
                nodes[counter] = counter;
                anz += 1 << counter;
            }
            block12: while (true) {
                help = new int[k];
                i = 0;
                while (i >= 0) {
                    System.arraycopy(nodes, 0, copy, 0, l);
                    counter = help[0];
                    int current = copy[counter];
                    while (counter < l - 1) {
                        copy[counter++] = copy[counter];
                    }
                    index = current;
                    for (i = 1; i < k; ++i) {
                        counter = help[i];
                        perm[i - 1] = copy[counter];
                        index += copy[counter] * powers[i];
                        while (counter < l - 1) {
                            copy[counter++] = copy[counter];
                        }
                    }
                    best[index][anz] = Double.NEGATIVE_INFINITY;
                    int oldIndex = index / L;
                    int oldAnz = anz - (1 << current);
                    for (counter = 0; counter < l - k; ++counter) {
                        perm[g] = copy[counter];
                        double val = best[oldIndex + perm[g] * powers[g]][oldAnz] + score.getValue((byte)k, current, perm);
                        if (!(best[index][anz] < val)) continue;
                        best[index][anz] = val;
                        pre[index][anz] = perm[g];
                    }
                    i = g;
                    while (i >= 0 && help[i] == l - i - 1) {
                        help[i--] = 0;
                    }
                    if (i < 0) continue;
                    int n = i;
                    help[n] = help[n] + 1;
                }
                i = l - 1;
                for (counter = (int)((byte)(L - 1)); i >= 0 && nodes[i] == counter; --counter) {
                    anz -= 1 << nodes[i--];
                }
                if (i < 0) continue block10;
                int n = anz - (1 << nodes[i]);
                int n2 = i++;
                int n3 = nodes[n2] + 1;
                nodes[n2] = n3;
                anz = n + (1 << n3);
                while (true) {
                    if (i >= l) continue block12;
                    nodes[i] = nodes[i - 1];
                    int n4 = i++;
                    int n5 = nodes[n4] + 1;
                    nodes[n4] = n5;
                    anz += 1 << n5;
                }
                break;
            }
        }
        double max = Double.NEGATIVE_INFINITY;
        anz = numOfSubsets - 1;
        for (i = 0; i < powers[k]; ++i) {
            if (best[i] == null || !(best[i][anz] > max)) continue;
            index = i;
            max = best[i][anz];
        }
        int[] erg = new int[L];
        i = L - 1;
        while (pre[index][anz] != -1) {
            erg[i] = index % L;
            index = index / L + pre[index][anz] * powers[g];
            anz -= 1 << erg[i--];
        }
        anz /= L;
        while (i >= 0) {
            erg[i--] = index % L;
            index /= L;
        }
        return erg;
    }

    public static int[][] computeMaximalKDAG(Tensor score) {
        return DAG.computeMaxKDAG(score instanceof SymmetricTensor ? (SymmetricTensor)score : new SymmetricTensor((AsymmetricTensor)score));
    }

    protected static int[][] computeMaxKDAG(SymmetricTensor score) {
        int[] tempEdge;
        int i;
        int L = score.getNumberOfNodes();
        int n = 0;
        int l = 0;
        int k = score.getOrder();
        if (L > 31) {
            throw new IllegalArgumentException("This algorithm can only handle bayesian networks with at most 31 nodes. If you are interested in bayesian networks with more nodes please try an other algorithm.");
        }
        int anz = 1;
        int numOfSubsets = (int)Math.pow(2.0, L);
        int[] nodes = new int[L + 1];
        nodes[0] = 0;
        double[] best = new double[numOfSubsets];
        int[] edge = new int[numOfSubsets];
        do {
            if (l == 0) {
                best[anz] = score.getRootValue(nodes[0]);
                edge[anz] = 0;
            } else {
                byte c = (byte)(k < l ? k : (byte)l);
                int[] par = new int[l];
                System.arraycopy(nodes, 0, par, 0, l);
                best[anz] = best[anz - (1 << nodes[--n])] + score.getBest(nodes[n], par, c);
                edge[anz] = score.getTrueIndexForLastGetBest();
                while (n > 0) {
                    par[--n] = nodes[n + 1] - 1;
                    double temp = best[anz - (1 << nodes[n])] + score.getBest(nodes[n], par, c);
                    if (!(best[anz] < temp)) continue;
                    best[anz] = temp;
                    edge[anz] = score.getTrueIndexForLastGetBest();
                }
            }
            i = 0;
            while ((anz & 1 << i) > 0) {
                ++i;
            }
            ++anz;
            l -= i - 1;
            nodes[0] = i;
            for (n = 1; n <= l; ++n) {
                while ((anz & 1 << ++i) == 0) {
                }
                nodes[n] = i;
            }
        } while (anz < numOfSubsets);
        int[][] tempRandDeps = new int[L][];
        --anz;
        l = L - 1;
        do {
            i = k < l ? k : l;
            tempEdge = score.getEdgeFromIndex(edge[anz], (byte)(i + 1));
            tempRandDeps[tempEdge[i]] = tempEdge;
            anz -= 1 << tempEdge[i];
        } while (--l != 0);
        tempRandDeps[tempEdge[0]] = new int[]{tempEdge[0]};
        return tempRandDeps;
    }

    public static int[] enumerateHP(Tensor score) {
        int counter;
        int L;
        int m = L = score.getNumberOfNodes();
        byte k = score.getOrder();
        --m;
        int[] copy = new int[L];
        int[] index = new int[L];
        int[] bestPerm = new int[L];
        int[] perm = new int[L];
        int[] id = new int[L];
        index[0] = -1;
        for (counter = 0; counter < L; ++counter) {
            id[counter] = counter;
        }
        double bestWeights = Double.NEGATIVE_INFINITY;
        counter = 0;
        do {
            int n = counter;
            index[n] = index[n] + 1;
            System.arraycopy(id, 0, copy, 0, L);
            for (counter = 0; counter < L; ++counter) {
                int i = index[counter];
                perm[counter] = copy[i];
                while (i < m) {
                    copy[i++] = copy[i];
                }
            }
            double weights = DAG.getScoreForPath(score, L, k, perm);
            if (weights > bestWeights) {
                bestWeights = weights;
                System.arraycopy(perm, 0, bestPerm, 0, L);
            }
            counter = m;
            while (--counter >= 0 && index[counter] == m - counter) {
                index[counter] = 0;
            }
        } while (counter >= 0);
        return bestPerm;
    }

    public static double getScore(Tensor t, int[][] structure) throws IllegalArgumentException {
        int n = t.getNumberOfNodes();
        if (structure.length != n) {
            throw new IllegalArgumentException("The given structure and tensor are defined on a different number of nodes.");
        }
        double erg = 0.0;
        for (int counter = 0; counter < n; ++counter) {
            int k = structure[counter].length - 1;
            if (k > 0) {
                erg += t.getValue((byte)k, structure[counter][k], structure[counter]);
                continue;
            }
            if (k != 0) continue;
            erg += t.getRootValue(structure[counter][k]);
        }
        return erg;
    }

    public static double getScoreForPath(Tensor score, int l, byte k, int[] path) {
        int j;
        int c;
        byte i;
        double weight = score.getRootValue(path[0]);
        int[] parents = new int[k];
        for (i = 1; i < k; i = (byte)(i + 1)) {
            c = 0;
            j = i - 1;
            while (j >= 0) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            weight += score.getValue(i, path[i], parents);
        }
        while (i < l) {
            c = 0;
            j = i - 1;
            while (j >= i - k) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            weight += score.getValue(k, path[i], parents);
            i = (byte)(i + 1);
        }
        return weight;
    }

    public static int[][] getStructureFromPath(int[] path, Tensor score) {
        int j;
        int c;
        int i;
        byte by = score.getOrder();
        int l = score.getNumberOfNodes();
        int[][] structure = new int[l][];
        int[] parents = new int[by];
        structure[path[0]] = new int[]{path[0]};
        for (i = 1; i < by; ++i) {
            c = 0;
            j = i - 1;
            while (j >= 0) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            structure[path[i]] = score.getMaximalEdgeFor((byte)i, path[i], parents);
        }
        while (i < l) {
            c = 0;
            j = i - 1;
            while (j >= i - by) {
                parents[c] = path[j];
                --j;
                ++c;
            }
            structure[path[i]] = score.getMaximalEdgeFor(by, path[i], parents);
            ++i;
        }
        return structure;
    }

    public static String toDirectedGraphvizFormat(int[][] structure) {
        return DAG.toGraphvizFormat(structure, " -> ");
    }

    public static String toUndirectedGraphvizFormat(int[][] structure) {
        return DAG.toGraphvizFormat(structure, " -- ");
    }

    public static String toWeightedGraphvizFormat(int[][] structure, String arrow, Tensor t) {
        String erg = "";
        double sum = 0.0;
        for (int i = 0; i < structure.length; i = (int)((byte)(i + 1))) {
            int j = 0;
            double current = 0.0;
            if (structure[i].length > 2) {
                erg = erg + "{" + structure[i][0];
                for (j = 1; j < structure[i].length - 1; ++j) {
                    erg = erg + " " + structure[i][j];
                }
                erg = erg + "} " + arrow + " ";
            } else if (structure[i].length == 2) {
                erg = erg + structure[i][j++] + arrow;
            }
            erg = erg + structure[i][j];
            int k = structure[i].length - 1;
            if (k > 0) {
                current = t.getValue((byte)k, structure[i][k], structure[i]);
            } else if (k == 0) {
                current = t.getRootValue(structure[i][k]);
            }
            erg = erg + "\t[weight=" + current + "]\n";
            sum += current;
        }
        erg = erg + "\nscore = " + sum;
        return erg;
    }

    protected static String toGraphvizFormat(int[][] structure, String arrow) {
        String erg = "";
        for (int i = 0; i < structure.length; ++i) {
            int j = 0;
            if (structure[i].length > 2) {
                erg = erg + "{" + structure[i][0];
                for (j = 1; j < structure[i].length - 1; ++j) {
                    erg = erg + " " + structure[i][j];
                }
                erg = erg + "} " + arrow + " ";
            } else if (structure[i].length == 2) {
                erg = erg + structure[i][j++] + arrow;
            }
            erg = erg + structure[i][j] + "\n";
        }
        return erg;
    }
}

