/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

public class MarchingSquares {
    public static RealFunctionOnTupleIndex scanner(final RealFunctionOnReal2 realFunctionOnReal2, final double d, final double d2, final int n, final double d3, final double d4, final int n2) {
        return new RealFunctionOnTupleIndex(){
            final double xs;
            final double ys;
            {
                this.xSize = n;
                this.ySize = n2;
                this.xs = 1.0 / (double)(this.xSize - 1);
                this.ys = 1.0 / (double)(this.ySize - 1);
            }

            double valueAt(int n3, int n22) {
                double d5 = d * (1.0 - (double)n3 * this.xs) + d2 * (double)n3 * this.xs;
                double d22 = d3 * (1.0 - (double)n22 * this.ys) + d4 * (double)n22 * this.ys;
                return realFunctionOnReal2.valueAt(d5, d22);
            }
        };
    }

    public static double[][] scan(RealFunctionOnReal2 realFunctionOnReal2, double d, double d2, int n, double d3, double d4, int n2) {
        double[][] dArray = new double[n][n2];
        MarchingSquares.scan(dArray, realFunctionOnReal2, d, d2, d3, d4);
        return dArray;
    }

    public static void scan(double[][] dArray, RealFunctionOnReal2 realFunctionOnReal2, double d, double d2, double d3, double d4) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        RealFunctionOnTupleIndex realFunctionOnTupleIndex = MarchingSquares.scanner(realFunctionOnReal2, d, d2, n, d3, d4, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = realFunctionOnTupleIndex.valueAt(i, j);
            }
        }
    }

    public static IndexedLineSet compute(RealFunctionOnReal2 realFunctionOnReal2, double d, double d2, double d3, int n, double d4, double d5, int n2) {
        RealFunctionOnTupleIndex realFunctionOnTupleIndex = MarchingSquares.scanner(realFunctionOnReal2, d2, d3, n, d4, d5, n2);
        return MarchingSquares.compute(realFunctionOnTupleIndex, d, d2, d3, d4, d5);
    }

    public static IndexedLineSet compute(RealFunctionOnTupleIndex realFunctionOnTupleIndex, double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        int n;
        double d9;
        int n2;
        int n3 = realFunctionOnTupleIndex.xSize;
        int n4 = realFunctionOnTupleIndex.ySize;
        int[][] nArray = new int[n3][n4 - 1];
        int[][] nArray2 = new int[n3 - 1][n4];
        int n5 = 0;
        double[] dArray = new double[100];
        for (n2 = 0; n2 < n3; ++n2) {
            d9 = realFunctionOnTupleIndex.valueAt(n2, 0) - d;
            for (n = 1; n < n4; ++n) {
                d8 = realFunctionOnTupleIndex.valueAt(n2, n) - d;
                if (d9 * d8 < 0.0) {
                    d7 = Math.abs(d9) / (Math.abs(d9) + Math.abs(d8));
                    d6 = (1.0 - d7) * (double)(n - 1) + d7 * (double)n;
                    dArray = MarchingSquares.setPoint(dArray, n5, n2, d6);
                    nArray[n2][n - 1] = n5++;
                } else {
                    nArray[n2][n - 1] = -1;
                }
                d9 = d8;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            d9 = realFunctionOnTupleIndex.valueAt(0, n2) - d;
            for (n = 1; n < n3; ++n) {
                d8 = realFunctionOnTupleIndex.valueAt(n, n2) - d;
                if (d9 * d8 < 0.0) {
                    d7 = Math.abs(d9) / (Math.abs(d9) + Math.abs(d8));
                    d6 = (1.0 - d7) * (double)(n - 1) + d7 * (double)n;
                    dArray = MarchingSquares.setPoint(dArray, n5, d6, n2);
                    nArray2[n - 1][n2] = n5++;
                } else {
                    nArray2[n - 1][n2] = -1;
                }
                d9 = d8;
            }
        }
        dArray = MarchingSquares.resize(dArray, 2 * n5);
        int n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            dArray[n6] = d2 * (1.0 - dArray[n6] / (double)(n3 - 1)) + d3 * (dArray[n6] / (double)(n3 - 1));
            dArray[++n6] = d4 * (1.0 - dArray[n6] / (double)(n4 - 1)) + d5 * (dArray[n6] / (double)(n4 - 1));
            ++n6;
        }
        int[] nArray3 = new int[100];
        int[] nArray4 = new int[4];
        int n7 = 0;
        for (n = 0; n < n3 - 1; ++n) {
            for (int i = 0; i < n4 - 1; ++i) {
                nArray4[0] = nArray[n][i];
                nArray4[1] = nArray[n + 1][i];
                nArray4[2] = nArray2[n][i];
                nArray4[3] = nArray2[n][i + 1];
                for (int j = 0; j < 4; ++j) {
                    if (nArray4[j] == -1) continue;
                    for (int k = j + 1; k < 4; ++k) {
                        if (nArray4[k] == -1) continue;
                        nArray3 = MarchingSquares.setEdge(nArray3, n7++, nArray4[j], nArray4[k]);
                    }
                }
            }
        }
        nArray3 = MarchingSquares.resize(nArray3, 2 * n7);
        int[] nArray5 = new int[n7];
        for (int i = 0; i < n7; ++i) {
            nArray5[i] = 2;
        }
        return new IndexedLineSet(dArray, nArray3, nArray5);
    }

    public static IndexedLineSet compute(final double[][] dArray, double d, double d2, double d3, double d4, double d5) {
        RealFunctionOnTupleIndex realFunctionOnTupleIndex = new RealFunctionOnTupleIndex(){
            {
                this.xSize = dArray.length;
                this.ySize = dArray[0].length;
            }

            double valueAt(int n, int n2) {
                return dArray[n][n2];
            }
        };
        return MarchingSquares.compute(realFunctionOnTupleIndex, d, d2, d3, d4, d5);
    }

    private static double[] setPoint(double[] dArray, int n, double d, double d2) {
        if (dArray.length <= 2 * n) {
            double[] dArray2 = new double[2 * dArray.length + 10];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray = dArray2;
        }
        dArray[2 * n] = d;
        dArray[2 * n + 1] = d2;
        return dArray;
    }

    private static double[] resize(double[] dArray, int n) {
        if (dArray.length == n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(n, dArray.length));
        return dArray2;
    }

    private static int[] setEdge(int[] nArray, int n, int n2, int n3) {
        if (nArray.length <= 2 * n + 2) {
            int[] nArray2 = new int[2 * nArray.length + 10];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[2 * n] = n2;
        nArray[2 * n + 1] = n3;
        return nArray;
    }

    private static int[] resize(int[] nArray, int n) {
        if (nArray.length == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(n, nArray.length));
        return nArray2;
    }

    public static double[][] removeDirt(double[][] dArray, int n, int n2, double d, double d2, double d3, double d4) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = (double[][])dArray.clone();
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = (int)((double)(n * n2) * d3);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                if (MarchingSquares.getNumOfDirtyValues(dArray, i, j, n, n2, d, d2) <= n7) continue;
                MarchingSquares.removeDirt(dArray2, i, j, n, n2, d4);
            }
        }
        return dArray2;
    }

    public static int getNumOfDirtyValues(double[][] dArray, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        while (n6 < n3) {
            int n8 = 0;
            int n9 = n2;
            while (n8 < n4) {
                double d3 = dArray[n7][n9];
                if (d3 < d || d3 > d2) {
                    ++n5;
                }
                ++n8;
                ++n9;
            }
            ++n6;
            ++n7;
        }
        return n5;
    }

    public static void removeDirt(double[][] dArray, int n, int n2, int n3, int n4, double d) {
        int n5 = 0;
        int n6 = n;
        while (n5 < n3) {
            int n7 = 0;
            int n8 = n2;
            while (n7 < n4) {
                dArray[n6][n8] = d;
                ++n7;
                ++n8;
            }
            ++n5;
            ++n6;
        }
    }

    public static double[][] removeDirt(double[][] dArray, int n, int n2, double d) {
        double[][] dArray2 = (double[][])dArray.clone();
        MarchingSquares.removeDirt(dArray, dArray2, n, n2, d);
        return dArray2;
    }

    public static void removeDirt(double[][] dArray, double[][] dArray2, int n, int n2, double d) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = dArray.length;
        int n10 = dArray[0].length;
        for (n8 = 0; n8 < n9; ++n8) {
            System.arraycopy(dArray[n8], 0, dArray2[n8], 0, n10);
        }
        n8 = n9 - n;
        int n11 = n10 - n;
        for (n7 = 0; n7 < n9; ++n7) {
            for (n6 = 0; n6 < n11; ++n6) {
                n5 = 0;
                n4 = 1;
                n3 = n6 + 1;
                while (n4 < n) {
                    if ((dArray[n7][n3 - 1] - d) * (dArray[n7][n3] - d) < 0.0) {
                        ++n5;
                    }
                    ++n4;
                    ++n3;
                }
                if (n5 <= n2) continue;
                MarchingSquares.removeDirt(dArray2, n7, n6, 1, n, d);
            }
        }
        for (n7 = 0; n7 < n10; ++n7) {
            for (n6 = 0; n6 < n8; ++n6) {
                n5 = 0;
                n4 = 1;
                n3 = n6 + 1;
                while (n4 < n) {
                    if (dArray[n3 - 1][n7] * dArray[n3][n7] < 0.0) {
                        ++n5;
                    }
                    ++n4;
                    ++n3;
                }
                if (n5 <= n2) continue;
                MarchingSquares.removeDirt(dArray2, n6, n7, n, 1, d);
            }
        }
    }

    public static interface RealFunctionOnReal2 {
        public double valueAt(double var1, double var3);
    }

    static abstract class RealFunctionOnTupleIndex {
        int xSize;
        int ySize;

        RealFunctionOnTupleIndex() {
        }

        abstract double valueAt(int var1, int var2);
    }

    public static class IndexedLineSet {
        double[] points;
        int[] index;
        int[] length;

        IndexedLineSet(double[] dArray, int[] nArray, int[] nArray2) {
            this.points = dArray;
            this.index = nArray;
            this.length = nArray2;
        }

        public int[] getIndex() {
            return this.index;
        }

        public int[] getLength() {
            return this.length;
        }

        public double[] getPoints() {
            return this.points;
        }
    }
}

