/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

public class NewtonRaphson {
    public static double ACC = 1.0E-12;
    public static int MAX_NUM_OF_STEPS = 50;
    public static boolean DEBUG = false;

    private NewtonRaphson() {
    }

    public static void search(RealFunctionWithDerivative realFunctionWithDerivative, double d, double[] dArray) {
        NewtonRaphson.search(realFunctionWithDerivative, d, dArray, ACC, ACC, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(RealFunctionWithDerivative realFunctionWithDerivative, double d, double[] dArray, double d2) {
        NewtonRaphson.search(realFunctionWithDerivative, d, dArray, d2, d2, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(RealFunctionWithDerivative realFunctionWithDerivative, double d, double[] dArray, double d2, double d3, double d4, double d5, int n, boolean bl) {
        if (DEBUG) {
            System.out.println("NewtonRaphson DEBUG: " + d);
        }
        for (int i = 0; i < n; ++i) {
            realFunctionWithDerivative.eval(d, dArray, 1, dArray, 2);
            if (DEBUG) {
                System.out.println("NewtonRaphson :  x  = " + d);
                System.out.println("               f(x) = " + dArray[1]);
                System.out.println("              f'(x) = " + dArray[2]);
            }
            double d6 = dArray[1] / dArray[2];
            dArray[0] = d -= d6;
            if (d < d4 || d > d5) {
                throw new RuntimeException(" left initial brackets ");
            }
            if (Math.abs(d6 / d) < d3 || Math.abs(dArray[1]) < d2) {
                return;
            }
            if (!(Math.abs(d6) < d2)) continue;
            return;
        }
        if (bl) {
            throw new RuntimeException(" exeed max number of steps !!! ");
        }
    }

    public static void search(ComplexFunctionWithDerivative complexFunctionWithDerivative, double d, double d2, double[] dArray) {
        NewtonRaphson.search(complexFunctionWithDerivative, d, d2, dArray, ACC, ACC, ACC, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(ComplexFunctionWithDerivative complexFunctionWithDerivative, double d, double d2, double[] dArray, double d3) {
        NewtonRaphson.search(complexFunctionWithDerivative, d, d2, dArray, d3, d3, d3, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(ComplexFunctionWithDerivative complexFunctionWithDerivative, double d, double d2, double[] dArray, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, boolean bl) {
        if (DEBUG) {
            System.out.println("NewtonRaphson DEBUG: " + d + " + i " + d2);
        }
        for (int i = 0; i < n; ++i) {
            dArray[0] = d;
            dArray[1] = d2;
            complexFunctionWithDerivative.eval(d, d2, dArray, 2, dArray, 4);
            double d10 = dArray[4] * dArray[4] + dArray[5] * dArray[5];
            double d11 = (dArray[2] * dArray[4] + dArray[3] * dArray[5]) / d10;
            double d12 = (dArray[3] * dArray[4] - dArray[2] * dArray[5]) / d10;
            if (DEBUG) {
                System.out.println("NewtonRaphson :  x  = " + d + " + i " + d2);
                System.out.println("               f(x) = " + dArray[2] + " + i " + dArray[3]);
                System.out.println("              f'(x) = " + dArray[4] + " + i " + dArray[5]);
                System.out.println("              dx = " + d11 + " + i " + d12);
            }
            d2 -= d12;
            if ((d -= d11) < d6 || d > d7 || d2 < d8 || d2 > d9) {
                throw new RuntimeException(" left initial brackets ");
            }
            double d13 = Math.abs(d) + Math.abs(d2);
            if (!(Math.abs(d11 / d13) < d4 && Math.abs(d12 / d13) < d5) && (!(Math.abs(dArray[2]) < d3) || !(Math.abs(dArray[3]) < d3))) continue;
            return;
        }
        if (bl) {
            throw new RuntimeException(" exeed max number of steps !!! ");
        }
    }

    public static interface ComplexFunctionWithDerivative {
        public void eval(double var1, double var3, double[] var5, int var6, double[] var7, int var8);
    }

    public static interface RealFunctionWithDerivative {
        public void eval(double var1, double[] var3, int var4, double[] var5, int var6);
    }
}

