/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.interpolation;

import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.util.ArrayUtilities;
import java.io.Serializable;

public class CubicBSpline
implements Serializable {
    double[] x;
    double[] y;
    double[] ddy;
    double[] a;
    double[] b;
    double[] c;
    double[] r;
    int n;
    int N;
    int klo;
    int khi;
    double[] tmp1;
    double[] tmp2;
    double[] tmp3;
    double[] tmp4;
    double[] tmp5;

    private CubicBSpline() {
    }

    private CubicBSpline(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("length of arrays must coinside");
        }
        if (dArray2.length < 2) {
            throw new IllegalArgumentException("length of arrays must be bigger then 1");
        }
        this.x = ArrayUtilities.copy(dArray, null);
        this.y = ArrayUtilities.copy(dArray2, null);
    }

    void compute() {
        int n;
        if (this.ddy == null || this.ddy.length != this.y.length) {
            this.ddy = new double[this.y.length];
        }
        if (this.a == null || this.a.length != this.N) {
            this.a = new double[this.N];
            this.b = new double[this.N];
            this.c = new double[this.N];
            this.r = new double[this.N];
            VectorOperations.assign(this.b, 2.0);
        }
        for (n = 1; n < this.n - 1; ++n) {
            this.a[n] = this.mu(n);
        }
        for (n = 1; n < this.N - 1; ++n) {
            this.c[n] = this.lambda(n);
        }
        for (n = 1; n < this.n - 1; ++n) {
            this.r[n] = this.d(n);
        }
    }

    final double h(int n) {
        return this.x[n] - this.x[n - 1];
    }

    final double d(int n) {
        int n2 = n + 1;
        double d = this.h(n);
        double d2 = this.h(n2);
        return 6.0 / (d + d2) * ((this.y[n2] - this.y[n]) / d2 - (this.y[n] - this.y[n - 1]) / d);
    }

    final double lambda(int n) {
        int n2 = n + 1;
        double d = this.h(n);
        double d2 = this.h(n2);
        return d2 / (d + d2);
    }

    final double mu(int n) {
        int n2 = n + 1;
        double d = this.h(n);
        double d2 = this.h(n2);
        return d / (d + d2);
    }

    private final void searchInterval(double d) {
        this.klo = 0;
        this.khi = this.n - 1;
        while (this.khi - this.klo > 1) {
            int n = this.khi + this.klo >> 1;
            if (this.x[n] > d) {
                this.khi = n;
                continue;
            }
            this.klo = n;
        }
    }

    public double valueAt(double d) {
        return this.valueAt(d, 0);
    }

    public double valueAt(double d, int n) {
        this.searchInterval(d);
        double d2 = this.x[this.khi] - this.x[this.klo];
        if (d2 == 0.0) {
            throw new RuntimeException();
        }
        double d3 = (this.x[this.khi] - d) / d2;
        double d4 = (d - this.x[this.klo]) / d2;
        switch (n) {
            case 0: {
                return d3 * this.y[this.klo] + d4 * this.y[this.khi] + ((d3 * d3 * d3 - d3) * this.ddy[this.klo] + (d4 * d4 * d4 - d4) * this.ddy[this.khi]) * (d2 * d2) / 6.0;
            }
            case 1: {
                return (this.y[this.khi] - this.y[this.klo]) / d2 - ((3.0 * d3 * d3 - 1.0) * this.ddy[this.klo] - (3.0 * d4 * d4 - 1.0) * this.ddy[this.khi]) * d2 / 6.0;
            }
            case 2: {
                return d3 * this.ddy[this.klo] + d4 * this.ddy[this.khi];
            }
        }
        return 0.0;
    }

    public int getLengthOfTable() {
        return this.n;
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double getX(int n) {
        return this.x[n];
    }

    public double getY(int n) {
        return this.y[n];
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public double[] getDDY() {
        return (double[])this.ddy.clone();
    }

    public void setX(double[] dArray) {
        if (dArray.length != this.n) {
            throw new IllegalArgumentException("x array has wrong size");
        }
        if (ArrayUtilities.equal(this.x, dArray)) {
            return;
        }
        this.x = ArrayUtilities.copy(dArray, this.x);
        this.compute();
    }

    public void setY(double[] dArray) {
        if (dArray.length != this.n) {
            throw new IllegalArgumentException("y array has wrong size");
        }
        if (ArrayUtilities.equal(this.y, dArray)) {
            return;
        }
        this.y = ArrayUtilities.copy(dArray, this.y);
        this.compute();
    }

    public void setXY(int n, double d, double d2) {
        if (n != 0 && this.x[n - 1] >= d) {
            throw new IllegalArgumentException("x value in wrong range. It must hold: x[index-1] < x < x[index+1]");
        }
        if (n != this.n - 1 && d >= this.x[n + 1]) {
            throw new IllegalArgumentException("x value in wrong range. It must hold: x[index-1] < x < x[index+1]");
        }
        if (this.x[n] == d && this.y[n] == d2) {
            return;
        }
        this.x[n] = d;
        this.y[n] = d2;
        this.compute();
    }

    public int getIndexOfClosestXValue(double d) {
        if (d <= this.x[0]) {
            return 0;
        }
        if (d >= this.x[this.n - 1]) {
            return this.n - 1;
        }
        int n = 0;
        int n2 = this.n - 1;
        while (n2 - n > 1) {
            int n3 = n2 + n >> 1;
            if (this.x[n3] > d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return d - this.x[n] < this.x[n2] - d ? n : n2;
    }

    public void setXY(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("length of arrays must coinside");
        }
        if (dArray2.length < 2) {
            throw new IllegalArgumentException("length of arrays must be bigger then 1");
        }
        if (ArrayUtilities.equal(this.y, dArray2)) {
            if (ArrayUtilities.equal(this.x, dArray)) {
                return;
            }
            this.x = ArrayUtilities.copy(dArray, this.x);
        } else {
            this.x = ArrayUtilities.copy(dArray, this.x);
            this.y = ArrayUtilities.copy(dArray2, this.y);
        }
        this.compute();
    }

    void tridag(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        if (this.tmp5 == null || this.tmp5.length != dArray.length) {
            this.tmp5 = new double[dArray.length];
        }
        this.tridag(dArray, dArray2, dArray3, dArray4, dArray5, this.tmp5);
    }

    void tridag(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n;
        int n2 = dArray.length;
        double[] dArray7 = dArray6;
        if (dArray2[0] == 0.0) {
            throw new RuntimeException("tridiag not diagonal dominant");
        }
        double d = dArray2[0];
        dArray5[0] = dArray4[0] / d;
        for (n = 1; n < n2; ++n) {
            dArray7[n] = dArray3[n - 1] / d;
            d = dArray2[n] - dArray[n] * dArray7[n];
            if (d == 0.0) {
                throw new RuntimeException("tridiag not diagonal dominant");
            }
            dArray5[n] = (dArray4[n] - dArray[n] * dArray5[n - 1]) / d;
        }
        for (n = n2 - 2; n >= 0; --n) {
            int n3 = n;
            dArray5[n3] = dArray5[n3] - dArray7[n + 1] * dArray5[n + 1];
        }
    }

    void cyclic(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double[] dArray4, double[] dArray5) {
        if (this.tmp1 == null || this.tmp1.length != dArray.length) {
            this.tmp1 = new double[dArray.length];
            this.tmp2 = new double[dArray.length];
            this.tmp3 = new double[dArray.length];
            this.tmp4 = new double[dArray.length];
        }
        this.cyclic(dArray, dArray2, dArray3, d, d2, dArray4, dArray5, this.tmp1, this.tmp2, this.tmp3, this.tmp4);
    }

    void cyclic(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9) {
        int n;
        int n2 = dArray.length;
        double[] dArray10 = dArray6;
        double[] dArray11 = dArray7;
        double[] dArray12 = dArray8;
        if (n2 <= 2) {
            new IllegalArgumentException("n too small in cyclic");
        }
        double d3 = -dArray2[0];
        dArray10[0] = dArray2[0] - d3;
        dArray10[n2 - 1] = dArray2[n2 - 1] - d * d2 / d3;
        for (n = 1; n < n2 - 1; ++n) {
            dArray10[n] = dArray2[n];
        }
        this.tridag(dArray, dArray10, dArray3, dArray4, dArray5, dArray9);
        dArray11[0] = d3;
        dArray11[n2 - 1] = d;
        for (n = 1; n < n2 - 1; ++n) {
            dArray11[n] = 0.0;
        }
        this.tridag(dArray, dArray10, dArray3, dArray11, dArray12, dArray9);
        double d4 = (dArray5[0] + d2 * dArray5[n2 - 1] / d3) / (1.0 + dArray12[0] + d2 * dArray12[n2 - 1] / d3);
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            dArray5[n3] = dArray5[n3] - d4 * dArray12[i];
        }
    }

    public static class Periodic
    extends CubicBSpline {
        public Periodic(double[] dArray, double[] dArray2) {
            super(dArray, dArray2);
            this.compute();
        }

        public void compute() {
            double d;
            this.n = this.y.length;
            this.N = this.n - 1;
            super.compute();
            double d2 = this.h(1) / (this.h(1) + this.h(this.N));
            double d3 = d = 1.0 - d2;
            double d4 = this.lambda(this.N - 1);
            this.c[0] = d2;
            this.r[0] = 6.0 / (this.h(1) + this.h(this.N)) * ((this.y[1] - this.y[0]) / this.h(1) - (this.y[this.N] - this.y[this.N - 1]) / this.h(this.N));
            this.cyclic(this.a, this.b, this.c, d4, d3, this.r, this.ddy);
            this.ddy[this.N] = this.ddy[0];
        }
    }

    public static class Natural
    extends CubicBSpline {
        public Natural(double[] dArray, double[] dArray2) {
            super(dArray, dArray2);
            this.compute();
        }

        public void compute() {
            this.n = this.N = this.y.length;
            super.compute();
            this.a[this.n - 1] = 0.0;
            this.c[0] = 0.0;
            this.r[this.n - 1] = 0.0;
            this.r[0] = 0.0;
            this.tridag(this.a, this.b, this.c, this.r, this.ddy);
        }
    }

    public static class Default
    extends CubicBSpline {
        double dYInFirstX = 0.0;
        double dYInLastX = 0.0;

        public Default(double[] dArray, double[] dArray2, double d, double d2) {
            super(dArray, dArray2);
            this.dYInFirstX = d;
            this.dYInLastX = d2;
            this.compute();
        }

        public Default(double[] dArray, double[] dArray2) {
            this(dArray, dArray2, 0.0, 0.0);
        }

        public double getDYInFirstX() {
            return this.dYInFirstX;
        }

        public void setDYInFirstX(double d) {
            if (this.dYInFirstX == d) {
                return;
            }
            this.dYInFirstX = d;
            this.compute();
        }

        public double getDYInLastX() {
            return this.dYInLastX;
        }

        public void setDYInLastX(double d) {
            if (this.dYInLastX == d) {
                return;
            }
            this.dYInLastX = d;
            this.compute();
        }

        void compute() {
            this.n = this.N = this.y.length;
            super.compute();
            this.a[this.n - 1] = 1.0;
            this.c[0] = 1.0;
            this.r[0] = 6.0 / this.h(1) * ((this.y[1] - this.y[0]) / this.h(1) - this.dYInFirstX);
            this.r[this.n - 1] = -6.0 / this.h(this.n - 1) * ((this.y[this.n - 1] - this.y[this.n - 2]) / this.h(this.n - 1) - this.dYInLastX);
            this.tridag(this.a, this.b, this.c, this.r, this.ddy);
        }
    }
}

