/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

public final class NewtonCotes {
    NewtonCotes() {
    }

    public static double sum(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double average(double[] dArray) {
        return NewtonCotes.sum(dArray) / (double)dArray.length;
    }

    public static double eulerSum(double[] dArray) {
        return (2.0 * NewtonCotes.sum(dArray) - (dArray[0] + dArray[dArray.length - 1])) / 2.0 / (double)(dArray.length - 1);
    }

    public static double simpsonSum(double[] dArray) {
        if (dArray.length % 2 != 1) {
            throw new IllegalArgumentException("length of array have to be odd");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (d + 4.0 * d2) / 6.0 / (double)(n / 2);
    }

    public static double keplerSum(double[] dArray) {
        if (dArray.length % 3 != 1) {
            throw new IllegalArgumentException("length of array modulo 3 has to be 1");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
            d3 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (d + 3.0 * d2 + 3.0 * d3) / 8.0 / (double)(n / 3);
    }

    public static double milneSum(double[] dArray) {
        if (dArray.length % 4 != 1) {
            throw new IllegalArgumentException("length of array modulo 4 has to be 1");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
            d3 += dArray[n2++];
            d4 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (7.0 * d + 32.0 * d2 + 12.0 * d3 + 32.0 * d4) / 90.0 / (double)(n / 4);
    }

    public static double order7Sum(double[] dArray) {
        if (dArray.length % 5 != 1) {
            throw new IllegalArgumentException("length of array modulo 5 has to be 1");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
            d3 += dArray[n2++];
            d4 += dArray[n2++];
            d5 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (19.0 * d + 75.0 * d2 + 50.0 * d3 + 50.0 * d4 + 75.0 * d5) / 288.0 / (double)(n / 5);
    }

    public static double weddleSum(double[] dArray) {
        if (dArray.length % 6 != 1) {
            throw new IllegalArgumentException("length of array modulo 6 has to be 1");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
            d3 += dArray[n2++];
            d4 += dArray[n2++];
            d5 += dArray[n2++];
            d6 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (41.0 * d + 216.0 * d2 + 27.0 * d3 + 272.0 * d4 + 27.0 * d5 + 216.0 * d6) / 840.0 / (double)(n / 6);
    }

    public static double order9Sum(double[] dArray) {
        if (dArray.length % 7 != 1) {
            throw new IllegalArgumentException("length of array modulo 7 has to be 1");
        }
        int n = dArray.length - 1;
        double d = dArray[n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2++];
            d2 += dArray[n2++];
            d3 += dArray[n2++];
            d4 += dArray[n2++];
            d5 += dArray[n2++];
            d6 += dArray[n2++];
            d7 += dArray[n2++];
        }
        d = 2.0 * d - dArray[0] - dArray[n];
        return (751.0 * d + 3577.0 * d2 + 1323.0 * d3 + 2989.0 * d4 + 2989.0 * d5 + 1323.0 * d6 + 3577.0 * d7) / 17280.0 / (double)(n / 7);
    }

    public static double highestOrderSum(double[] dArray) {
        if (dArray.length % 7 == 1) {
            return NewtonCotes.order9Sum(dArray);
        }
        if (dArray.length % 6 == 1) {
            return NewtonCotes.weddleSum(dArray);
        }
        if (dArray.length % 5 == 1) {
            return NewtonCotes.order7Sum(dArray);
        }
        if (dArray.length % 4 == 1) {
            return NewtonCotes.milneSum(dArray);
        }
        if (dArray.length % 3 == 1) {
            return NewtonCotes.keplerSum(dArray);
        }
        if (dArray.length % 2 == 1) {
            return NewtonCotes.simpsonSum(dArray);
        }
        return NewtonCotes.eulerSum(dArray);
    }
}

